/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.mg4j.index.FileIndex;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.PrefixMap;
import it.unimi.dsi.mg4j.index.SkipIndexReader;
import it.unimi.dsi.mg4j.index.TermMap;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.File;
import java.io.IOException;
import org.apache.commons.configuration.ConfigurationException;

public class SkipIndex
extends FileIndex {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    public final int height;
    public final int quantum;

    public IndexReader getReader(int bufferSize) throws IOException {
        return new SkipIndexReader(this, new InputBitStream(this.indexFile, bufferSize));
    }

    protected SkipIndex(CharSequence basename, TermMap termMap, PrefixMap prefixMap, boolean randomAccess, boolean documentSizes) throws ConfigurationException, IOException {
        super(basename, termMap, prefixMap, randomAccess, documentSizes);
        this.quantum = this.properties.getInt("skipquantum");
        this.height = this.properties.getInt("skipheight");
    }

    public SkipIndex(String basename, File indexFile, Properties properties, int numberOfDocuments, int numberOfTerms, int maxCount, long flags, TermMap termMap, PrefixMap prefixMap, LongList offsets, IntList sizes, int quantum, int height) throws IOException {
        super(basename, indexFile, properties, numberOfDocuments, numberOfTerms, maxCount, flags, termMap, prefixMap, offsets, sizes);
        this.quantum = quantum;
        this.height = height;
    }
}

