/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.query.MarkingMutableString;
import it.unimi.dsi.mg4j.query.QueryEngine;
import it.unimi.dsi.mg4j.query.ResultItem;
import it.unimi.dsi.mg4j.query.TextMarker;
import it.unimi.dsi.mg4j.query.parser.ParseException;
import it.unimi.dsi.mg4j.query.parser.TokenMgrError;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.score.DocumentScoreInfo;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.Reader;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.servlet.VelocityServlet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QueryServlet
extends VelocityServlet {
    private static final Logger LOGGER;
    private static final int STD_MAX_NUM_ITEMS = 10;
    private static final String DEFAULT_TEMPLATE = "it/unimi/dsi/mg4j/query/query.velocity";
    private static String template;
    private static QueryEngine queryEngine;
    private static DocumentCollection documentCollection;
    private static Map indexMap;
    private static Index[] sortedIndex;
    private static String mimeType;
    private static boolean useUri;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$query$QueryServlet;

    public void init() {
        ServletContext context = this.getServletContext();
        queryEngine = (QueryEngine)context.getAttribute("queryEngine");
        documentCollection = QueryServlet.queryEngine.queryParser.documentCollection;
        if (documentCollection != null) {
            context.setAttribute("collection", (Object)documentCollection);
        }
        indexMap = QueryServlet.queryEngine.queryParser.indexMap;
        mimeType = (String)context.getAttribute("mimeType");
        boolean bl = false;
        if (context.getAttribute("uri") != null) {
            bl = useUri = true;
        }
        if ((template = (String)context.getAttribute("template")) == null) {
            template = DEFAULT_TEMPLATE;
        }
        if (documentCollection != null) {
            sortedIndex = new Index[indexMap.size()];
            indexMap.values().toArray(sortedIndex);
            Arrays.sort(sortedIndex, new Comparator(){

                public final int compare(Object x, Object y) {
                    return documentCollection.factory().fieldIndex(((Index)x).field) - documentCollection.factory().fieldIndex(((Index)y).field);
                }
            });
        }
    }

    public Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context context) {
        try {
            String query = request.getParameter("q") != null ? new String(request.getParameter("q").getBytes("ISO-8859-1"), "UTF-8") : null;
            context.put("action", (Object)(request.getContextPath() + request.getServletPath()));
            int start = 0;
            int maxNumItems = 10;
            try {
                maxNumItems = Integer.parseInt(request.getParameter("m"));
            }
            catch (NumberFormatException dontCare) {
                // empty catch block
            }
            try {
                start = Integer.parseInt(request.getParameter("s"));
            }
            catch (NumberFormatException dontCare) {
                // empty catch block
            }
            if (maxNumItems < 0 || maxNumItems > 1000) {
                maxNumItems = 10;
            }
            if (start < 0) {
                start = 0;
            }
            if (query != null && query.length() != 0) {
                int globNumItems;
                context.put("q", (Object)StringEscapeUtils.escapeHtml((String)query));
                context.put("qUrl", (Object)URLEncoder.encode(query, "UTF-8"));
                context.put("firstItem", (Object)new Integer(start));
                long time = -System.currentTimeMillis();
                ObjectArrayList results = new ObjectArrayList();
                try {
                    globNumItems = queryEngine.result(query, start, maxNumItems, (ObjectList)results);
                }
                catch (TokenMgrError e) {
                    context.put("errmsg", (Object)e.getMessage());
                    return Velocity.getTemplate((String)template);
                }
                catch (ParseException e) {
                    context.put("errmsg", (Object)e.getMessage());
                    return Velocity.getTemplate((String)template);
                }
                time += System.currentTimeMillis();
                ObjectArrayList resultItems = new ObjectArrayList();
                if (!results.isEmpty()) {
                    Interval[] markedInterval = null;
                    int i = 0;
                    while (i < results.size()) {
                        DocumentScoreInfo dsi = (DocumentScoreInfo)results.get(i);
                        LOGGER.debug((Object)("Intervals for item " + i));
                        ResultItem resultItem = new ResultItem(dsi.document, dsi.score);
                        resultItems.add((Object)resultItem);
                        if (documentCollection != null) {
                            Document document = documentCollection.document(dsi.document);
                            resultItem.title = StringEscapeUtils.escapeHtml((String)document.title().toString());
                            resultItem.uri = useUri ? StringEscapeUtils.escapeHtml((String)document.uri().toString()) : new MutableString("./Item?doc=").append(resultItem.doc).append("&m=").append(mimeType).append("&uri=").append(StringEscapeUtils.escapeHtml((String)document.uri().toString()));
                            MarkingMutableString snippet = new MarkingMutableString(TextMarker.HTML_STRONG, MarkingMutableString.HTML_ESCAPE);
                            int j = 0;
                            while (j < sortedIndex.length) {
                                if (QueryServlet.sortedIndex[j].hasPositions) {
                                    markedInterval = (Interval[])((Reference2ReferenceMap)dsi.info).get((Object)sortedIndex[j]);
                                    if (markedInterval != null) {
                                        int field = documentCollection.factory().fieldIndex(QueryServlet.sortedIndex[j].field);
                                        LOGGER.debug((Object)("Found intervals for " + QueryServlet.sortedIndex[j].field + " (" + field + ')'));
                                        Reader content = (Reader)document.content(field);
                                        snippet.startField(markedInterval).appendAndMark(document.wordReader(field).setReader(content)).endField();
                                    }
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug((Object)(QueryServlet.sortedIndex[j].field + ": " + (markedInterval == null ? null : Arrays.asList(markedInterval))));
                                    }
                                    document.close();
                                }
                                ++j;
                            }
                            resultItem.text = snippet;
                        } else {
                            resultItem.title = "Document #" + resultItem.doc;
                            resultItem.uri = new MutableString("./Item?doc=").append(resultItem.doc).append("&m=").append(mimeType);
                            MutableString text = new MutableString();
                            Iterator j = indexMap.values().iterator();
                            while (j.hasNext()) {
                                Index index = (Index)j.next();
                                markedInterval = (Interval[])((Reference2ReferenceMap)dsi.info).get((Object)index);
                                if (markedInterval != null) {
                                    text.append("<p>").append(index.field).append(": ").append(Arrays.asList(markedInterval));
                                }
                                if (!LOGGER.isDebugEnabled()) continue;
                                LOGGER.debug((Object)(index.field + ": " + (markedInterval == null ? null : Arrays.asList(markedInterval))));
                            }
                            resultItem.text = text;
                        }
                        ++i;
                    }
                }
                context.put("result", (Object)resultItems);
                context.put("globNumItems", (Object)new Integer(globNumItems));
                context.put("start", (Object)new Integer(start));
                context.put("maxNumItems", (Object)new Integer(maxNumItems));
                context.put("time", (Object)new Integer((int)time));
            }
            return Velocity.getTemplate((String)template);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$it$unimi$dsi$mg4j$query$QueryServlet;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$query$QueryServlet = QueryServlet.class("[Lit.unimi.dsi.mg4j.query.QueryServlet;", false);
        }
        LOGGER = Fast.getLogger(clazz);
    }
}

