/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CachingDocumentIterator
extends AbstractIntIterator
implements DocumentIterator {
    private final DocumentIterator documentIterator;
    private final Reference2ReferenceOpenHashMap cachingIterators;
    private final Reference2ReferenceOpenHashMap currentIterators;
    private final Map unmodifiableCurrentIterators;

    public int document() {
        return this.documentIterator.document();
    }

    public boolean hasNext() {
        return this.documentIterator.hasNext();
    }

    public Set indices() {
        return this.documentIterator.indices();
    }

    public IntervalIterator intervalIterator(Index index) {
        CachingIntervalIterator result = (CachingIntervalIterator)this.currentIterators.get((Object)index);
        if (result != null) {
            result.restart();
            return result;
        }
        IntervalIterator intervalIterator = this.documentIterator.intervalIterator(index);
        if (intervalIterator == IntervalIterators.TRUE || !intervalIterator.hasNext()) {
            return intervalIterator;
        }
        result = (CachingIntervalIterator)this.cachingIterators.get((Object)index);
        if (result == null) {
            result = new CachingIntervalIterator();
            this.cachingIterators.put((Object)index, (Object)result);
        }
        result.wrap(intervalIterator);
        result.reset();
        this.currentIterators.put((Object)index, (Object)result);
        return result;
    }

    public IntervalIterator intervalIterator() {
        if (this.indices().size() != 1) {
            throw new IllegalStateException();
        }
        return this.intervalIterator((Index)this.indices().iterator().next());
    }

    public Map intervalIterators() {
        Iterator i = this.indices().iterator();
        while (i.hasNext()) {
            this.intervalIterator((Index)i.next());
        }
        return this.unmodifiableCurrentIterators;
    }

    public int nextDocument() {
        this.currentIterators.clear();
        return this.documentIterator.nextDocument();
    }

    public int nextInt() {
        return this.nextDocument();
    }

    public int skipTo(int n) {
        return this.documentIterator.skipTo(n);
    }

    public void dispose() {
        this.documentIterator.dispose();
    }

    public CachingDocumentIterator(DocumentIterator documentIterator) {
        this.documentIterator = documentIterator;
        this.currentIterators = new Reference2ReferenceOpenHashMap(this.indices().size(), 0.5f);
        this.cachingIterators = new Reference2ReferenceOpenHashMap(this.indices().size(), 0.5f);
        this.unmodifiableCurrentIterators = Reference2ReferenceMaps.unmodifiable((Reference2ReferenceMap)this.currentIterators);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class CachingIntervalIterator
    extends AbstractObjectIterator
    implements IntervalIterator {
        private final ObjectArrayList cachedIntervals;
        private IntervalIterator intervalIterator;
        private int pos;

        public final void wrap(IntervalIterator intervalIterator) {
            this.intervalIterator = intervalIterator;
        }

        public final int extent() {
            return this.intervalIterator.extent();
        }

        public final boolean hasNext() {
            boolean bl = false;
            if (this.pos < this.cachedIntervals.size() || this.intervalIterator.hasNext()) {
                bl = true;
            }
            return bl;
        }

        public final Object next() {
            return this.nextInterval();
        }

        public final Interval nextInterval() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.pos < this.cachedIntervals.size()) {
                return (Interval)this.cachedIntervals.get(this.pos++);
            }
            Interval next = this.intervalIterator.nextInterval();
            this.cachedIntervals.add((Object)next);
            ++this.pos;
            return next;
        }

        public final void reset() {
            this.cachedIntervals.clear();
            this.restart();
        }

        public final void restart() {
            this.pos = 0;
        }

        private final /* synthetic */ void this() {
            this.cachedIntervals = new ObjectArrayList();
            this.pos = 0;
        }

        private CachingIntervalIterator() {
            this.this();
        }
    }
}

