/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntHeapIndirectPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectHeapSesquiIndirectDoublePriorityQueue;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.Intervals;
import it.unimi.dsi.mg4j.util.MutableString;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OrDocumentIterator
extends AbstractIntIterator
implements DocumentIterator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    protected final DocumentIterator[] it;
    protected final DocumentIterator[] it2;
    private final int n;
    private final IntHeapIndirectPriorityQueue queue;
    private final int[] curr;
    private final ReferenceOpenHashSet indices;
    private final Reference2ReferenceOpenHashMap intervalIterators;
    private final Reference2ReferenceOpenHashMap currentIterators;
    private final Map unmodifiableCurrentIterators;
    private int next;
    private int last;
    private boolean endOfProcess;

    public Set indices() {
        return this.indices;
    }

    private final void advance(int n) {
        int first;
        if (this.endOfProcess) {
            return;
        }
        int c = this.curr[this.queue.first()];
        while (!this.endOfProcess && this.curr[first = this.queue.first()] == c) {
            int res;
            if (n >= 0) {
                res = this.it[first].skipTo(n);
            } else {
                int n2 = res = this.it[first].hasNext() ? this.it[first].nextInt() : -1;
            }
            if (res < 0) {
                this.it[this.queue.dequeue()] = null;
                if (!this.queue.isEmpty()) continue;
                this.endOfProcess = true;
                continue;
            }
            this.curr[first] = res;
            this.queue.changed();
        }
        this.currentIterators.clear();
    }

    public int skipTo(int n) {
        if (this.last >= n) {
            return this.last;
        }
        this.advance(n);
        if (this.endOfProcess) {
            return -1;
        }
        this.next = this.curr[this.queue.first()];
        return this.nextInt();
    }

    public int nextInt() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.last = this.next;
        this.next = -1;
        return this.last;
    }

    public int document() {
        if (this.last == -1) {
            throw new IllegalStateException();
        }
        return this.last;
    }

    public int nextDocument() {
        return this.nextInt();
    }

    public boolean hasNext() {
        if (this.next >= 0) {
            return true;
        }
        if (this.endOfProcess) {
            return false;
        }
        this.advance(-1);
        if (this.endOfProcess) {
            return false;
        }
        this.next = this.curr[this.queue.first()];
        return true;
    }

    public Map intervalIterators() {
        Iterator i = this.indices.iterator();
        while (i.hasNext()) {
            this.intervalIterator((Index)i.next());
        }
        return this.unmodifiableCurrentIterators;
    }

    public IntervalIterator intervalIterator() {
        if (this.indices().size() != 1) {
            throw new IllegalStateException();
        }
        return this.intervalIterator((Index)this.indices().iterator().next());
    }

    public IntervalIterator intervalIterator(Index index) {
        IntervalIterator intervalIterator = (IntervalIterator)this.currentIterators.get((Object)index);
        if (intervalIterator != null) {
            return intervalIterator;
        }
        boolean atLeastOneIsTrue = false;
        int c = 0;
        int i = 0;
        while (i < this.n) {
            if (this.it[i] != null && this.it[i].document() == this.last) {
                intervalIterator = this.it[i].intervalIterator(index);
                if (intervalIterator == IntervalIterators.TRUE) {
                    atLeastOneIsTrue = true;
                } else if (intervalIterator != IntervalIterators.FALSE) {
                    ++c;
                }
            }
            ++i;
        }
        if (c == 0) {
            intervalIterator = atLeastOneIsTrue ? IntervalIterators.TRUE : IntervalIterators.FALSE;
        } else {
            intervalIterator = (IntervalIterator)this.intervalIterators.get((Object)index);
            if (intervalIterator == null) {
                intervalIterator = new OrIntervalIterator(index);
                this.intervalIterators.put((Object)index, (Object)intervalIterator);
            }
        }
        this.currentIterators.put((Object)index, (Object)intervalIterator);
        intervalIterator.reset();
        return intervalIterator;
    }

    public void dispose() {
        int i = this.n;
        while (i-- != 0) {
            this.it2[i].dispose();
        }
    }

    public String toString() {
        MutableString res = new MutableString();
        res.append(this.getClass().getName()).append("(").delete(0, res.lastIndexOf('.') + 1);
        int i = 0;
        while (i < this.n) {
            res.append(i > 0 ? "," : "").append(this.it[i]);
            ++i;
        }
        return res.append(")").toString();
    }

    private final /* synthetic */ void this() {
        this.indices = new ReferenceOpenHashSet();
        this.last = -1;
        this.endOfProcess = false;
    }

    public OrDocumentIterator(DocumentIterator[] it) {
        this.this();
        this.it = it;
        this.it2 = (DocumentIterator[])it.clone();
        this.n = it.length;
        this.curr = new int[this.n];
        this.queue = new IntHeapIndirectPriorityQueue(this.curr);
        int i = 0;
        while (i < this.n) {
            this.indices.addAll((Collection)it[i].indices());
            ++i;
        }
        this.intervalIterators = new Reference2ReferenceOpenHashMap(this.indices.size(), 0.5f);
        this.currentIterators = new Reference2ReferenceOpenHashMap(this.indices.size(), 0.5f);
        this.unmodifiableCurrentIterators = Reference2ReferenceMaps.unmodifiable((Reference2ReferenceMap)this.currentIterators);
        this.next = -1;
        i = 0;
        while (i < this.n) {
            if (it[i].hasNext()) {
                this.curr[i] = it[i].nextInt();
                this.queue.enqueue(i);
            } else {
                it[i] = null;
            }
            ++i;
        }
        if (this.queue.size() == 0) {
            this.endOfProcess = true;
        }
        this.next = this.endOfProcess ? -1 : this.curr[this.queue.first()];
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class OrIntervalIterator
    extends AbstractIntIterator
    implements IntervalIterator {
        private static final boolean DEBUG = false;
        private static final boolean ASSERTS = false;
        final Index index;
        private final IntervalIterator[] it;
        private final int n;
        private final Interval[] curr;
        private ObjectHeapSesquiIndirectDoublePriorityQueue queue;
        private boolean endOfProcess;
        private boolean nextIsLoaded;
        private int nextLeft;
        private int nextRight;
        private static final /* synthetic */ boolean assert;

        public void reset() {
            this.nextIsLoaded = false;
            ObjectArrays.fill((Object[])this.curr, null);
            this.queue.clear();
            int i = 0;
            while (i < this.n) {
                DocumentIterator documentIterator = OrDocumentIterator.this.it[i];
                if (documentIterator != null && documentIterator.document() == OrDocumentIterator.this.last) {
                    this.it[i] = documentIterator.intervalIterator(this.index);
                    if (this.it[i] != IntervalIterators.TRUE && this.it[i].hasNext()) {
                        this.curr[i] = this.it[i].nextInterval();
                        this.queue.enqueue(i);
                    }
                }
                ++i;
            }
            this.endOfProcess = this.queue.isEmpty();
        }

        public boolean hasNext() {
            if (this.nextIsLoaded) {
                return true;
            }
            if (this.endOfProcess) {
                return false;
            }
            this.nextIsLoaded = true;
            do {
                int resultIndex = this.queue.first();
                this.nextLeft = this.curr[resultIndex].left;
                this.nextRight = this.curr[resultIndex].right;
                if (this.it[resultIndex].hasNext()) {
                    this.curr[resultIndex] = this.it[resultIndex].nextInterval();
                    this.queue.changed();
                } else if (!this.queue.isEmpty()) {
                    this.queue.dequeue();
                }
                if (!this.queue.isEmpty()) continue;
                this.endOfProcess = true;
            } while (!this.endOfProcess && (this.curr[this.queue.first()].left == this.nextLeft || this.curr[this.queue.secondaryFirst()].right <= this.nextRight));
            return true;
        }

        public Interval nextInterval() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextIsLoaded = false;
            return Interval.getInstance(this.nextLeft, this.nextRight);
        }

        public int extent() {
            int s = Integer.MAX_VALUE;
            int i = this.n;
            while (i-- != 0) {
                int e;
                int n = e = this.curr[i] != null ? this.it[i].extent() : Integer.MAX_VALUE;
                if (e >= s) continue;
                s = e;
            }
            return s;
        }

        public Object next() {
            return this.nextInterval();
        }

        public String toString() {
            MutableString res = new MutableString();
            res.append(this.getClass().getName()).append("(").delete(0, res.lastIndexOf('.') + 1);
            int i = 0;
            while (i < this.n) {
                res.append(i > 0 ? "," : "").append(this.it[i]);
                ++i;
            }
            return res.append(")").toString();
        }

        private final /* synthetic */ void this() {
            this.endOfProcess = false;
        }

        public OrIntervalIterator(Index index) {
            this.this();
            this.index = index;
            this.n = OrDocumentIterator.this.it.length;
            this.curr = new Interval[this.n];
            this.it = new IntervalIterator[this.n];
            this.queue = new ObjectHeapSesquiIndirectDoublePriorityQueue((Object[])this.curr, Intervals.STARTS_BEFORE_OR_PROLONGS, Intervals.ENDS_AFTER);
        }

        static {
            assert = Class.forName("[Lit.unimi.dsi.mg4j.search.OrDocumentIterator;").getComponentType().desiredAssertionStatus() ^ true;
        }
    }
}

