/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.score.Scorer;
import java.io.IOException;

public class DecreasingDocumentRankScorer
implements Scorer {
    private double[] score;
    private double first;
    private double latest;

    public double score(DocumentIterator d) {
        if (this.first == Double.MAX_VALUE) {
            this.first = this.score[d.document()];
            if (this.first == 0.0) {
                this.first = 1.0;
            }
        } else if (this.score[d.document()] > this.latest) {
            throw new IllegalStateException();
        }
        this.latest = this.score[d.document()];
        return this.latest / this.first;
    }

    public double score(DocumentIterator d, Index index) {
        return this.score(d);
    }

    public boolean setWeights(Reference2DoubleMap index2weightUnused) {
        return false;
    }

    public void reset() {
        this.latest = Double.MAX_VALUE;
        this.first = Double.MAX_VALUE;
    }

    public String toString() {
        return "DecreasingDocumentRank";
    }

    public DecreasingDocumentRankScorer(String filename) throws IOException {
        this(BinIO.loadDoubles((CharSequence)filename));
    }

    public DecreasingDocumentRankScorer(double[] score) throws IOException {
        this.score = score;
    }
}

