/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import it.unimi.dsi.mg4j.search.score.DocumentScoreInfo;
import java.util.Comparator;

public class ScoredDocumentBoundedSizeQueue {
    private static final DocumentScoreComparator DOCUMENT_SCORE_COMPARATOR = new DocumentScoreComparator();
    private final ObjectHeapPriorityQueue queue;
    private int maxSize;

    public boolean wouldEnqueue(int d, double s) {
        if (this.queue.size() < this.maxSize) {
            return true;
        }
        DocumentScoreInfo dsi = (DocumentScoreInfo)this.queue.first();
        boolean bl = false;
        if (s > dsi.score || s == dsi.score && d > dsi.document) {
            bl = true;
        }
        return bl;
    }

    public boolean enqueue(int d, double s, Object i) {
        if (this.queue.size() < this.maxSize) {
            this.queue.enqueue((Object)new DocumentScoreInfo(d, s, i));
            return true;
        }
        DocumentScoreInfo dsi = (DocumentScoreInfo)this.queue.first();
        if (s > dsi.score || s == dsi.score && d > dsi.document) {
            dsi.document = d;
            dsi.score = s;
            dsi.info = i;
            this.queue.changed();
            return true;
        }
        return false;
    }

    public boolean enqueue(int d, double s) {
        return this.enqueue(d, s, null);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    public Object dequeue() {
        return this.queue.dequeue();
    }

    public ScoredDocumentBoundedSizeQueue(int capacity) {
        this.maxSize = capacity;
        this.queue = new ObjectHeapPriorityQueue(capacity, (Comparator)DOCUMENT_SCORE_COMPARATOR);
    }

    private static final class DocumentScoreComparator
    implements Comparator {
        public final int compare(Object x, Object y) {
            DocumentScoreInfo dsix = (DocumentScoreInfo)x;
            DocumentScoreInfo dsiy = (DocumentScoreInfo)y;
            if (dsix.score < dsiy.score) {
                return -1;
            }
            if (dsix.score > dsiy.score) {
                return 1;
            }
            return dsiy.document - dsix.document;
        }

        private DocumentScoreComparator() {
        }
    }
}

