/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import it.unimi.dsi.fastutil.objects.ObjectHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.IndexWriter;
import it.unimi.dsi.mg4j.index.SkipIndexWriter;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.tool.Concatenate;
import it.unimi.dsi.mg4j.tool.Index;
import it.unimi.dsi.mg4j.tool.Merge;
import it.unimi.dsi.mg4j.tool.Paste;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.ProgressLogger;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationMap;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Combine
implements CompressionFlags {
    private static final Logger LOGGER;
    private static final boolean ASSERTS = false;
    public static final int DEFAULT_TEMP_FILE_SIZE = 0x1000000;
    protected final int numIndices;
    protected final it.unimi.dsi.mg4j.index.Index[] index;
    protected final IndexReader[] indexReader;
    private InputBitStream[] globCounts;
    private MutableString[] terms;
    private FastBufferedReader[] termReaders;
    protected ObjectHeapSemiIndirectPriorityQueue termQueue;
    protected final int numberOfDocuments;
    protected int maxCount;
    private long numberOfOccurrences;
    protected final String[] inputBasename;
    private final String outputBasename;
    private final int bufferSize;
    private final long logInterval;
    protected IndexWriter indexWriter;
    private Properties properties;
    protected int[] usedIndex;
    protected final int[] frequency;
    protected int[] position;
    protected int[] size;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$tool$Combine;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$SkipIndex;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$FileIndex;

    public static String[] batches(String basename) throws ConfigurationException {
        Properties properties = new Properties(basename + ".properties");
        String[] inputFileName = new String[properties.getInt("batches")];
        int j = 0;
        while (j < inputFileName.length) {
            inputFileName[j] = basename + '@' + j;
            ++j;
        }
        return inputFileName;
    }

    protected it.unimi.dsi.mg4j.index.Index getIndex(CharSequence basename) {
        return it.unimi.dsi.mg4j.index.Index.getInstance(basename, null, null, false, false);
    }

    protected abstract int combineNumberOfDocuments();

    protected abstract int combineSizes() throws IOException;

    protected abstract int combine(int var1) throws IOException;

    public void run() throws ConfigurationException, IOException {
        Logger logger = Fast.getLogger(this.getClass());
        ProgressLogger pl = new ProgressLogger(logger, this.logInterval);
        this.size = new int[this.numberOfDocuments];
        long totalSize = 0L;
        logger.info((Object)"Combining sizes...");
        int maxDocSize = this.combineSizes();
        OutputBitStream outputSizes = new OutputBitStream(this.outputBasename + ".sizes", this.bufferSize);
        int i = 0;
        while (i < this.numberOfDocuments) {
            totalSize += (long)this.size[i];
            outputSizes.writeGamma(this.size[i]);
            ++i;
        }
        outputSizes.close();
        logger.info((Object)"Sizes combined.");
        OutputBitStream outputGlobCounts = new OutputBitStream(this.outputBasename + ".globcounts");
        OutputBitStream frequencies = new OutputBitStream(this.outputBasename + ".frequencies");
        PrintWriter termFile = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputBasename + ".terms"), "UTF-8"), this.bufferSize));
        long numPointers = 0L;
        pl.expectedUpdates = this.numberOfOccurrences;
        pl.itemsName = "occurrences";
        pl.logInterval = this.logInterval;
        pl.start("Combining lists...");
        int numTerms = 0;
        while (!this.termQueue.isEmpty()) {
            int numUsedIndices = 0;
            int n = numUsedIndices++;
            int n2 = this.termQueue.first();
            this.usedIndex[n] = n2;
            int k = n2;
            MutableString currTerm = this.terms[n2].copy();
            currTerm.println(termFile);
            if (this.termReaders[k].readLine(this.terms[k]) == null) {
                this.termQueue.dequeue();
            } else {
                this.termQueue.changed();
            }
            pl.update();
            while (!this.termQueue.isEmpty() && this.terms[this.termQueue.first()].equals(currTerm)) {
                this.usedIndex[numUsedIndices++] = this.termQueue.first();
                k = this.usedIndex[numUsedIndices++];
                if (this.termReaders[k].readLine(this.terms[k]) == null) {
                    this.termQueue.dequeue();
                    continue;
                }
                this.termQueue.changed();
            }
            if (numUsedIndices > 1) {
                Arrays.sort(this.usedIndex, 0, numUsedIndices);
            }
            ++numTerms;
            long totalGlobCount = 0L;
            int i2 = 0;
            while (i2 < numUsedIndices) {
                totalGlobCount += (long)this.globCounts[this.usedIndex[i2]].readGamma();
                ++i2;
            }
            outputGlobCounts.writeLongGamma(totalGlobCount);
            int totalFrequency = this.combine(numUsedIndices);
            frequencies.writeGamma(totalFrequency);
            numPointers += (long)totalFrequency;
            pl.count += totalGlobCount - 1L;
            pl.update();
        }
        pl.done();
        long indexSize = this.indexWriter.writtenBits();
        this.indexWriter.close();
        frequencies.close();
        outputGlobCounts.close();
        termFile.close();
        logger.debug((Object)("Original properties: " + new ConfigurationMap((Configuration)this.properties)));
        this.properties.setProperty("documents", this.numberOfDocuments);
        this.properties.setProperty("maxcount", this.maxCount);
        this.properties.setProperty("maxdocsize", maxDocSize);
        this.properties.setProperty("size", indexSize);
        this.properties.setProperty("terms", numTerms);
        logger.debug((Object)("Post-merge properties: " + new ConfigurationMap((Configuration)this.properties)));
        this.properties.save();
        PrintStream stats = new PrintStream(new FileOutputStream(this.outputBasename + ".stats"));
        stats.println("Number of documents: " + Fast.format(this.numberOfDocuments));
        stats.println("Average size: " + Fast.format((double)totalSize / (double)this.numberOfDocuments));
        stats.println("Number of terms: " + Fast.format(numTerms));
        stats.println("Frequencies: " + Fast.format(this.indexWriter.bitsForFrequencies) + " bits, " + Fast.format((double)this.indexWriter.bitsForFrequencies / (double)numTerms) + " bits/frequency.");
        stats.println("Document pointers: " + Fast.format(numPointers) + " (" + Fast.format(this.indexWriter.bitsForPointers) + " bits, " + Fast.format((double)this.indexWriter.bitsForPointers / (double)numPointers) + " bits/pointer).");
        if (this.indexWriter.hasCounts) {
            stats.println("Counts: " + Fast.format(numPointers) + " (" + Fast.format(this.indexWriter.bitsForCounts) + " bits, " + Fast.format((double)this.indexWriter.bitsForCounts / (double)numPointers) + " bits/count).");
        }
        if (this.indexWriter.hasPositions) {
            stats.println("Occurrences: " + Fast.format(this.numberOfOccurrences) + " (" + Fast.format(this.indexWriter.bitsForPositions) + " bits, " + Fast.format((double)this.indexWriter.bitsForPositions / (double)this.numberOfOccurrences) + " bits/occurrence).");
        }
        if (this.indexWriter instanceof SkipIndexWriter) {
            ((SkipIndexWriter)this.indexWriter).printStats(stats);
        }
        if (this.indexWriter.hasPositions) {
            stats.println("Total: " + Fast.format(this.indexWriter.writtenBits()) + " bits, " + Fast.format((double)this.indexWriter.writtenBits() / (double)this.numberOfOccurrences) + " bits/occurrence");
        } else {
            stats.println("Total: " + Fast.format(this.indexWriter.writtenBits()) + " bits, " + Fast.format((double)this.indexWriter.writtenBits() / (double)this.numberOfOccurrences) + " bits/pointer");
        }
        stats.close();
    }

    public static void main(String[] arg) throws JSAPException, ConfigurationException, IOException {
        Class clazz = class$it$unimi$dsi$mg4j$tool$Combine;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$tool$Combine = Combine.class("[Lit.unimi.dsi.mg4j.tool.Combine;", false);
        }
        SimpleJSAP jsap = new SimpleJSAP(clazz.getName(), "Combines several indices. By default, documents are concatenated, but you can also merge or paste them.", new Parameter[]{new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, "1Mi", false, 'b', "buffer-size", "The size of an I/O buffer."), new FlaggedOption("comp", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'c', "comp", "A compression flag for the index (may be specified several times).").setAllowMultipleDeclarations(true), new Switch("skips", '\u0000', "skips", "Whether the resulting index should contain skips."), new FlaggedOption("quantum", (StringParser)JSAP.INTSIZE_PARSER, "64", false, 'Q', "quantum", "The skip quantum."), new FlaggedOption("height", (StringParser)JSAP.INTSIZE_PARSER, "10", false, 'H', "height", "The skip height."), new Switch("merge", 'm', "merge", "Merges indices (duplicates cause an error)."), new Switch("duplicates", 'd', "duplicates", "Pastes indices, concatenating the document positions for duplicates."), new Switch("properties", 'p', "properties", "The only specified inputBasename will be used to load a property file written by the scanning process."), new FlaggedOption("tempFileDir", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, '\u0000', "temp-file-dir", "The directory for the temporary file used during pasting."), new FlaggedOption("tempFileBufferSize", (StringParser)JSAP.INTSIZE_PARSER, "16Mi", false, '\u0000', "temp-file-buffer-size", "The size of the buffer for the temporary file during pasting."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new UnflaggedOption("outputBasename", (StringParser)JSAP.STRING_PARSER, true, "The basename of the resulting index."), new UnflaggedOption("inputBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, true, "The basenames of the indices to be merged.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        boolean skips = jsapResult.getBoolean("skips");
        if (!skips && (jsapResult.userSpecified("quantum") || jsapResult.userSpecified("height"))) {
            System.err.println("You specified quantum or height, but did not turn on skips.");
            return;
        }
        MutableString writerFlagsString = new MutableString();
        String[] inputBasename = jsapResult.getBoolean("properties") ? Combine.batches(jsapResult.getStringArray("inputBasename")[0]) : jsapResult.getStringArray("inputBasename");
        (jsapResult.getBoolean("duplicates") ? new Paste(jsapResult.getString("outputBasename"), inputBasename, jsapResult.getInt("bufferSize"), jsapResult.getFile("tempFileDir"), jsapResult.getInt("tempFileBufferSize"), Index.parseCompressionFlags(jsapResult.getStringArray("comp"), writerFlagsString), writerFlagsString, skips, jsapResult.getInt("quantum"), jsapResult.getInt("height"), jsapResult.getLong("logInterval")) : (jsapResult.getBoolean("merge") ? new Merge(jsapResult.getString("outputBasename"), inputBasename, jsapResult.getInt("bufferSize"), Index.parseCompressionFlags(jsapResult.getStringArray("comp"), writerFlagsString), writerFlagsString, skips, jsapResult.getInt("quantum"), jsapResult.getInt("height"), jsapResult.getLong("logInterval")) : new Concatenate(jsapResult.getString("outputBasename"), inputBasename, jsapResult.getInt("bufferSize"), Index.parseCompressionFlags(jsapResult.getStringArray("comp"), writerFlagsString), writerFlagsString, skips, jsapResult.getInt("quantum"), jsapResult.getInt("height"), jsapResult.getLong("logInterval")))).run();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public Combine(String outputBasename, String[] inputBasename, int bufferSize, long writerFlags, CharSequence writerFlagsString, boolean skips, int quantum, int height, long logInterval) throws IOException, ConfigurationException {
        String string;
        this.logInterval = logInterval;
        if (quantum == 0) {
            throw new IllegalArgumentException("Invalid quantum: " + quantum);
        }
        this.inputBasename = inputBasename;
        this.outputBasename = outputBasename;
        this.bufferSize = bufferSize;
        this.numIndices = inputBasename.length;
        this.index = new it.unimi.dsi.mg4j.index.Index[this.numIndices];
        this.indexReader = new IndexReader[this.numIndices];
        this.globCounts = new InputBitStream[this.numIndices];
        this.terms = new MutableString[this.numIndices];
        this.termReaders = new FastBufferedReader[this.numIndices];
        this.termQueue = new ObjectHeapSemiIndirectPriorityQueue((Object[])this.terms, this.numIndices);
        boolean hasCounts = true;
        boolean hasPositions = true;
        TermProcessor termProcessor = null;
        String field = null;
        int i = 0;
        while (i < this.numIndices) {
            this.index[i] = this.getIndex(inputBasename[i]);
            if (i == 0) {
                termProcessor = this.index[0].termProcessor;
            } else if (!termProcessor.equals(this.index[i].termProcessor)) {
                throw new IllegalStateException("The term processor of the first index (" + termProcessor + ") is different from the term processor of index " + i + " (" + this.index[i].termProcessor + ')');
            }
            if (this.index[i].field != null) {
                if (field == null) {
                    if (i != 0) {
                        LOGGER.warn((Object)"Not all indices specify the field property");
                    }
                    field = this.index[i].field;
                } else if (!field.equals(this.index[i].field)) {
                    LOGGER.warn((Object)("Index fields disagree: \"" + field + "\", \"" + this.index[i].field + '\"'));
                }
            }
            if (!this.index[i].hasCounts) {
                hasCounts = false;
            }
            if (!this.index[i].hasPositions) {
                hasPositions = false;
            }
            this.maxCount = Math.max(this.maxCount, this.index[i].maxCount);
            this.indexReader[i] = this.index[i].getReader(bufferSize);
            this.numberOfOccurrences += this.index[i].properties.getLong("occurrences");
            this.globCounts[i] = new InputBitStream(inputBasename[i] + ".globcounts");
            this.terms[i] = new MutableString();
            this.termReaders[i] = new FastBufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputBasename[i] + ".terms"), "UTF-8"));
            this.termReaders[i].readLine(this.terms[i]);
            if (this.terms[i].length() != 0) {
                this.termQueue.enqueue(i);
            }
            ++i;
        }
        this.usedIndex = new int[this.numIndices];
        this.frequency = new int[this.numIndices];
        this.position = new int[this.maxCount];
        this.numberOfDocuments = this.combineNumberOfDocuments();
        if ((writerFlags >>> 16 & 0xFFL) != 255L && !hasCounts) {
            throw new IllegalArgumentException("Some of the merged indices do not have counts.");
        }
        if ((writerFlags >>> 24 & 0xFFL) != 255L && !hasPositions) {
            throw new IllegalArgumentException("Some of the merged indices do not have positions.");
        }
        OutputBitStream offsets = new OutputBitStream(outputBasename + ".offsets");
        OutputBitStream mergedIndex = new OutputBitStream(outputBasename + ".index", bufferSize);
        File propertyFile = new File(outputBasename + ".properties");
        if (!propertyFile.exists()) {
            propertyFile.createNewFile();
        }
        this.properties = new Properties(propertyFile);
        this.properties.setProperty("compressionflags", writerFlagsString.toString());
        this.properties.setProperty("termprocessor", termProcessor.getClass().getName());
        if (field != null) {
            this.properties.setProperty("field", field);
        }
        if (skips) {
            this.properties.setProperty("skipquantum", quantum);
            this.properties.setProperty("skipheight", height);
            this.indexWriter = new SkipIndexWriter(mergedIndex, offsets, this.numberOfDocuments, writerFlags, quantum, height);
        } else {
            this.indexWriter = new IndexWriter(mergedIndex, offsets, this.numberOfDocuments, writerFlags);
        }
        if (skips) {
            Class clazz = class$it$unimi$dsi$mg4j$index$SkipIndex;
            if (clazz == null) {
                clazz = class$it$unimi$dsi$mg4j$index$SkipIndex = Combine.class("[Lit.unimi.dsi.mg4j.index.SkipIndex;", false);
            }
            string = clazz.getName();
        } else {
            Class clazz = class$it$unimi$dsi$mg4j$index$FileIndex;
            if (clazz == null) {
                clazz = class$it$unimi$dsi$mg4j$index$FileIndex = Combine.class("[Lit.unimi.dsi.mg4j.index.FileIndex;", false);
            }
            string = clazz.getName();
        }
        this.properties.setProperty("indexclass", string);
        this.properties.setProperty("occurrences", this.numberOfOccurrences);
    }

    static {
        Class clazz = class$it$unimi$dsi$mg4j$tool$Combine;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$tool$Combine = Combine.class("[Lit.unimi.dsi.mg4j.tool.Combine;", false);
        }
        LOGGER = Fast.getLogger(clazz);
    }
}

