/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.mg4j.index.DowncaseTermProcessor;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.io.WordReader;
import it.unimi.dsi.mg4j.tool.Scan;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.ProgressLogger;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ScanVirtual
extends Scan {
    private static final Logger LOGGER;
    private static final boolean ASSERTS = true;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$tool$ScanVirtual;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$NullTermProcessor;

    public static final void run(String basename, DataInput virtualDocuments, int gap, TermProcessor termProcessor, int bufferSize, int occsPerBatch, String renumberingFile, boolean keepUnsorted, long logInterval, String tempDirName) throws ConfigurationException, IOException {
        File tempDir = tempDirName == null ? new File(basename).getParentFile() : new File(tempDirName);
        int[] renumber = renumberingFile != null ? BinIO.loadInts((CharSequence)renumberingFile) : null;
        ProgressLogger pl = new ProgressLogger(LOGGER, logInterval, "fragments");
        ScanVirtual scanVirtual = new ScanVirtual(basename, termProcessor, bufferSize, occsPerBatch, keepUnsorted, tempDir);
        pl.start("Indexing fragments...");
        SelfDelimUTF8WordReader wordReader = new SelfDelimUTF8WordReader(virtualDocuments);
        int[] currMaxPos = IntArrays.EMPTY_ARRAY;
        try {
            while (true) {
                int document = virtualDocuments.readInt();
                if (renumber != null) {
                    document = renumber[document];
                }
                currMaxPos = IntArrays.grow((int[])currMaxPos, (int)(document + 1));
                int n = document;
                currMaxPos[n] = currMaxPos[n] + gap;
                wordReader.count = 0;
                scanVirtual.processDocument(document, currMaxPos[document], wordReader);
                int n2 = document;
                currMaxPos[n2] = currMaxPos[n2] + wordReader.count;
                pl.update();
            }
        }
        catch (EOFException e) {
            scanVirtual.close(null);
            pl.done();
            return;
        }
    }

    public static final void main(String[] arg) throws JSAPException, ConfigurationException, IllegalArgumentException, SecurityException, IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class clazz = class$it$unimi$dsi$mg4j$tool$ScanVirtual;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$tool$ScanVirtual = ScanVirtual.class("[Lit.unimi.dsi.mg4j.tool.ScanVirtual;", false);
        }
        String string = clazz.getName();
        Parameter[] parameterArray = new Parameter[11];
        parameterArray[0] = new FlaggedOption("virtualDocs", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'v', "virtual-documents", "A serialised sequence of virtual documents; it will be used instead of stdin.");
        parameterArray[1] = new FlaggedOption("gap", (StringParser)JSAP.INTEGER_PARSER, "32", false, 'g', "gap", "A gap that will be introducted between different fragments of the same virtual document.");
        Class clazz2 = class$it$unimi$dsi$mg4j$index$NullTermProcessor;
        if (clazz2 == null) {
            clazz2 = class$it$unimi$dsi$mg4j$index$NullTermProcessor = ScanVirtual.class("[Lit.unimi.dsi.mg4j.index.NullTermProcessor;", false);
        }
        parameterArray[2] = new FlaggedOption("termProcessor", (StringParser)JSAP.CLASS_PARSER, clazz2.getName(), false, 't', "term-processor", "Sets the term processor to the given class.");
        parameterArray[3] = new Switch("downcase", '\u0000', "downcase", "A shortcut for setting the term processor to the downcasing processor.");
        parameterArray[4] = new FlaggedOption("batchSize", (StringParser)JSAP.INTSIZE_PARSER, "2Mi", false, 's', "batch-size", "The size of a batch.");
        parameterArray[5] = new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, "1Mi", false, 'b', "buffer-size", "The size of an I/O buffer.");
        parameterArray[6] = new FlaggedOption("renumber", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'r', "renumber", "The filename of a document renumbering.");
        parameterArray[7] = new Switch("keepUnsorted", 'u', "keep-unsorted", "Keep the unsorted term file.");
        parameterArray[8] = new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds.");
        parameterArray[9] = new FlaggedOption("tempDir", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for all temporary files (e.g., batches).");
        parameterArray[10] = new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, true, "The basename of the resulting index.");
        SimpleJSAP jsap = new SimpleJSAP(string, "Builds a set of batches from a file of virtual documents.", parameterArray);
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        Class termProcessorClass = jsapResult.getClass("termProcessor");
        Fast.ensureLog4JIsConfigured();
        DataInputStream input = new DataInputStream((InputStream)new FastBufferedInputStream(jsapResult.contains("virtualDocs") ? new FileInputStream(jsapResult.getString("virtualDocs")) : System.in));
        ScanVirtual.run(jsapResult.getString("basename"), input, jsapResult.getInt("gap"), jsapResult.getBoolean("downcase") ? DowncaseTermProcessor.getInstance() : (TermProcessor)termProcessorClass.getMethod("getInstance", null).invoke((Object)termProcessorClass, null), jsapResult.getInt("bufferSize"), jsapResult.getInt("batchSize"), jsapResult.getString("renumber"), jsapResult.getBoolean("keepUnsorted"), jsapResult.getLong("logInterval"), jsapResult.getString("tempDir"));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public ScanVirtual(String basename, TermProcessor termProcessor, int bufferSize, int occsPerBatch, boolean keepUnsorted, File tempDir) {
        super(basename, termProcessor, false, bufferSize, occsPerBatch, keepUnsorted, null, tempDir);
    }

    static {
        Class clazz = class$it$unimi$dsi$mg4j$tool$ScanVirtual;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$tool$ScanVirtual = ScanVirtual.class("[Lit.unimi.dsi.mg4j.tool.ScanVirtual;", false);
        }
        LOGGER = Fast.getLogger(clazz);
    }

    private static final class SelfDelimUTF8WordReader
    implements WordReader {
        private final DataInput dataInput;
        public int count;

        public final boolean next(MutableString word, MutableString nonWord) throws IOException {
            nonWord.length(0);
            word.readSelfDelimUTF8(this.dataInput);
            ++this.count;
            boolean bl = false;
            if (word.length() != 0) {
                bl = true;
            }
            return bl;
        }

        public final WordReader setReader(Reader reader) {
            return null;
        }

        public final WordReader copy() {
            return null;
        }

        public SelfDelimUTF8WordReader(DataInput dataInput) {
            this.dataInput = dataInput;
        }
    }
}

