/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import it.unimi.dsi.mg4j.util.SignedMinimalPerfectHash;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.zip.CRC32;

public class CRC32SignedMinimalPerfectHash
extends SignedMinimalPerfectHash {
    transient CRC32 crc32;
    long[] signature;

    public void initSignatures(Collection words) {
        int i = 0;
        this.crc32 = new CRC32();
        this.signature = new long[words.size()];
        Iterator e = words.iterator();
        while (e.hasNext()) {
            CharSequence s = (CharSequence)e.next();
            this.crc32.reset();
            int l = s.length();
            while (l-- != 0) {
                char c = s.charAt(l);
                this.crc32.update((byte)c);
                this.crc32.update((byte)(c >> 8));
            }
            this.signature[i] = this.crc32.getValue();
            ++i;
        }
    }

    public boolean checkSignature(CharSequence word, int index) {
        this.crc32.reset();
        int n = word.length();
        while (n-- != 0) {
            char c = word.charAt(n);
            this.crc32.update((byte)c);
            this.crc32.update((byte)(c >> 8));
        }
        boolean bl = false;
        if (this.signature[index] == this.crc32.getValue()) {
            bl = true;
        }
        return bl;
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.crc32 = new CRC32();
    }

    public CRC32SignedMinimalPerfectHash(Collection words, int weightLength) {
        super(words, weightLength);
    }

    public CRC32SignedMinimalPerfectHash(Collection words) {
        super(words);
    }

    public CRC32SignedMinimalPerfectHash(String wordFile, String encoding, int weightLength) {
        super(wordFile, encoding, weightLength);
    }

    public CRC32SignedMinimalPerfectHash(String wordFile) {
        super(wordFile);
    }
}

