/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import cern.colt.GenericPermuting;
import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import cern.jet.random.engine.MersenneTwister;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.mg4j.index.AbstractTermMap;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.FileLinesCollection;
import it.unimi.dsi.mg4j.io.LineIterator;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.ProgressMeter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MinimalPerfectHash
extends AbstractTermMap
implements Serializable {
    public static final int TERM_THRESHOLD = 16;
    public static final int WEIGHT_UNKNOWN = -1;
    public static final int WEIGHT_UNKNOWN_SORTED_TERMS = -2;
    protected static final boolean VERBOSE = Boolean.getBoolean("it.unimi.dsi.mg4j.util.minimalperfecthash.verbose");
    public static final long serialVersionUID = -7046029254386353130L;
    protected final int n;
    protected final int m;
    protected final int rightShift;
    protected final int[] weight0;
    protected final int[] weight1;
    protected final int[] weight2;
    protected final int weightLength;
    protected final int[] g;
    protected final transient Collection terms;
    protected transient long n4;
    protected transient CharSequence[] t;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$util$MinimalPerfectHash;
    static /* synthetic */ Class class$java$nio$charset$Charset;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$String;

    protected void hash(CharSequence term, int[] h) {
        int h0 = 0;
        int h1 = -1;
        int h2 = 0x55555555;
        int i = term.length();
        if (this.weightLength < i) {
            i = this.weightLength;
        }
        while (i-- != 0) {
            char c = term.charAt(i);
            h0 ^= this.weight0[i] * c;
            h1 ^= this.weight1[i] * c;
            h2 ^= this.weight2[i] * c;
        }
        h[0] = (h0 >>> this.rightShift) % this.m;
        h[1] = (h1 >>> this.rightShift) % this.m;
        h[2] = (h2 >>> this.rightShift) % this.m;
    }

    protected int getFromT(CharSequence term) {
        int i = this.n;
        while (i-- != 0) {
            if (!this.t[i].equals(term)) continue;
            return i;
        }
        return 0;
    }

    public int getIndex(CharSequence term) {
        if (this.t != null) {
            return this.getFromT(term);
        }
        int h0 = 0;
        int h1 = -1;
        int h2 = 0x55555555;
        int i = term.length();
        if (this.weightLength < i) {
            i = this.weightLength;
        }
        while (i-- != 0) {
            char c = term.charAt(i);
            h0 ^= this.weight0[i] * c;
            h1 ^= this.weight1[i] * c;
            h2 ^= this.weight2[i] * c;
        }
        return (int)(((long)this.g[(h0 >>> this.rightShift) % this.m] + (long)this.g[(h1 >>> this.rightShift) % this.m] + (long)this.g[(h2 >>> this.rightShift) % this.m] + this.n4) % (long)this.n);
    }

    public int get(MutableString term) {
        if (this.t != null) {
            return this.getFromT(term);
        }
        int h0 = 0;
        int h1 = -1;
        int h2 = 0x55555555;
        int i = term.length();
        char[] a = term.array;
        if (this.weightLength < i) {
            i = this.weightLength;
        }
        while (i-- != 0) {
            char c = a[i];
            h0 ^= this.weight0[i] * c;
            h1 ^= this.weight1[i] * c;
            h2 ^= this.weight2[i] * c;
        }
        return (int)(((long)this.g[(h0 >>> this.rightShift) % this.m] + (long)this.g[(h1 >>> this.rightShift) % this.m] + (long)this.g[(h2 >>> this.rightShift) % this.m] + this.n4) % (long)this.n);
    }

    public int hash(CharSequence term) {
        return this.getIndex(term);
    }

    public int hash(MutableString term) {
        return this.get(term);
    }

    public int getWeightLength() {
        return this.weightLength;
    }

    public int weightLength() {
        return this.weightLength;
    }

    public int size() {
        return this.n;
    }

    private final void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.n < 16) {
            s.writeObject(this.t);
        }
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n4 = this.n * 4;
        if (this.n < 16) {
            this.t = (CharSequence[])s.readObject();
        }
    }

    public static void main(String[] arg) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, FileNotFoundException, IOException, JSAPException {
        MinimalPerfectHash minimalPerfectHash;
        Class clazz = class$it$unimi$dsi$mg4j$util$MinimalPerfectHash;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$util$MinimalPerfectHash = MinimalPerfectHash.class("[Lit.unimi.dsi.mg4j.util.MinimalPerfectHash;", false);
        }
        String string = clazz.getName();
        Parameter[] parameterArray = new Parameter[6];
        parameterArray[0] = new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, "64Ki", false, 'b', "buffer-size", "The size of the I/O buffer used to read terms.");
        Class clazz2 = class$it$unimi$dsi$mg4j$util$MinimalPerfectHash;
        if (clazz2 == null) {
            clazz2 = class$it$unimi$dsi$mg4j$util$MinimalPerfectHash = MinimalPerfectHash.class("[Lit.unimi.dsi.mg4j.util.MinimalPerfectHash;", false);
        }
        parameterArray[1] = new FlaggedOption("class", (StringParser)JSAP.CLASS_PARSER, clazz2.getName(), false, 'c', "class", "A subclass of MinimalPerfectHash to be used when creating the table.");
        Class clazz3 = class$java$nio$charset$Charset;
        if (clazz3 == null) {
            clazz3 = class$java$nio$charset$Charset = MinimalPerfectHash.class("[Ljava.nio.charset.Charset;", false);
        }
        parameterArray[2] = new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser((Class)clazz3), "UTF-8", false, 'e', "encoding", "The term file encoding.");
        parameterArray[3] = new Switch("sorted", 's', "sorted", "The term list is sorted--optimise weight length.");
        parameterArray[4] = new FlaggedOption("termFile", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'o', "offline", "Read terms from this file (without loading them into core memory) instead of standard input.");
        parameterArray[5] = new UnflaggedOption("table", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised minimal perfect hash table.");
        SimpleJSAP jsap = new SimpleJSAP(string, "Builds a minimal perfect hash table reading from standard input a newline-separated list of terms.", parameterArray);
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int bufferSize = jsapResult.getInt("bufferSize");
        String tableName = jsapResult.getString("table");
        String termFile = jsapResult.getString("termFile");
        Class tableClass = jsapResult.getClass("class");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        int n = jsapResult.getBoolean("sorted");
        if (termFile == null) {
            ArrayList<MutableString> termList = new ArrayList<MutableString>();
            ProgressMeter pm = new ProgressMeter(100000, "terms");
            LineIterator termIterator = new LineIterator(new FastBufferedReader(new InputStreamReader(System.in, encoding), bufferSize), pm);
            pm.start("Reading terms...");
            while (termIterator.hasNext()) {
                termList.add(((MutableString)termIterator.next()).copy());
            }
            pm.done();
            System.err.print("Building minimal perfect hash table...");
            Class[] classArray = new Class[2];
            Class clazz4 = class$java$util$Collection;
            if (clazz4 == null) {
                clazz4 = class$java$util$Collection = MinimalPerfectHash.class("[Ljava.util.Collection;", false);
            }
            classArray[0] = clazz4;
            classArray[1] = Integer.TYPE;
            minimalPerfectHash = (MinimalPerfectHash)tableClass.getConstructor(classArray).newInstance(termList, new Integer(-1 - n));
        } else {
            Class clazz5;
            System.err.print("Building minimal perfect hash table...");
            Class[] classArray = new Class[3];
            Class clazz6 = class$java$lang$String;
            if (clazz6 == null) {
                clazz6 = classArray[0] = (class$java$lang$String = MinimalPerfectHash.class("[Ljava.lang.String;", false));
            }
            if ((clazz5 = class$java$lang$String) == null) {
                clazz5 = class$java$lang$String = MinimalPerfectHash.class("[Ljava.lang.String;", false);
            }
            classArray[1] = clazz5;
            classArray[2] = Integer.TYPE;
            minimalPerfectHash = (MinimalPerfectHash)tableClass.getConstructor(classArray).newInstance(termFile, encoding.toString(), new Integer(-1 - n));
        }
        System.err.print(" writing to file...");
        BinIO.storeObject((Object)minimalPerfectHash, (CharSequence)tableName);
        System.err.println(" done.");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public MinimalPerfectHash(Collection terms) {
        this(terms, -1);
    }

    public MinimalPerfectHash(Collection terms, int weightLength) {
        if (weightLength != -1 && weightLength != -2 && weightLength <= 0) {
            throw new IllegalArgumentException("Non-positive weight length: " + weightLength);
        }
        this.terms = terms;
        this.n = terms.size();
        this.n4 = this.n * 4;
        this.m = (int)((float)this.n * 1.25f);
        this.rightShift = (32 - Fast.mostSignificantBit(this.m)) / 2;
        this.g = new int[this.m];
        if (weightLength < 0) {
            if (VERBOSE) {
                System.err.print("Computing weight length...");
            }
            Iterator i = terms.iterator();
            int maxLength = Integer.MIN_VALUE;
            int minPrefixLength = Integer.MIN_VALUE;
            if (i.hasNext()) {
                int prevLength;
                MutableString prevTerm = new MutableString((CharSequence)i.next());
                maxLength = prevLength = prevTerm.length();
                while (i.hasNext()) {
                    CharSequence currTerm = (CharSequence)i.next();
                    int currLength = currTerm.length();
                    if (weightLength == -2) {
                        int k = 0;
                        while (k < prevLength && k < currLength && currTerm.charAt(k) == prevTerm.charAt(k)) {
                            ++k;
                        }
                        if (k == currLength && k == prevLength) {
                            throw new IllegalArgumentException("The term list contains a duplicate (" + currTerm + ')');
                        }
                        minPrefixLength = Math.max(minPrefixLength, k + 1);
                        prevTerm = new MutableString(currTerm);
                        prevLength = currLength;
                    }
                    maxLength = Math.max(maxLength, currLength);
                }
            }
            int n = weightLength = weightLength == -2 ? minPrefixLength : maxLength;
            if (VERBOSE) {
                System.err.println(" done [max term length=" + maxLength + "; weight length=" + weightLength + "].");
            }
        }
        this.weight0 = new int[weightLength];
        this.weight1 = new int[weightLength];
        this.weight2 = new int[weightLength];
        this.weightLength = weightLength;
        if (this.n < 16) {
            int j = 0;
            this.t = new MutableString[this.n];
            Iterator i = terms.iterator();
            while (i.hasNext()) {
                this.t[j++] = new MutableString((CharSequence)i.next());
            }
        } else {
            this.t = null;
            new Visit(terms);
        }
    }

    public MinimalPerfectHash(String termFile, String encoding, int weightLength) {
        this(new FileLinesCollection(termFile, encoding), weightLength);
    }

    public MinimalPerfectHash(String termFile) {
        this(termFile, null, -1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Visit {
        MersenneTwister r;
        int[] d;
        int[][] edge;
        boolean[] removed;
        int[] last;
        int[] inc;
        int[] incOffset;
        int[] stack;
        int top;
        int[] recStackI;
        int[] recStackK;
        int recTop;

        private final void visit(int x) {
            int k = -1;
            this.recTop = 0;
            boolean inside = false;
            while (true) {
                int i;
                if (!inside) {
                    i = 0;
                    while (i < this.last[x]) {
                        k = this.inc[this.incOffset[x] + i];
                        if (!this.removed[k]) break;
                        ++i;
                    }
                    this.stack[this.top++] = k;
                    this.removed[k] = true;
                    i = 0;
                    while (i < 3) {
                        int n = this.edge[i][k];
                        this.d[n] = this.d[n] - 1;
                        ++i;
                    }
                }
                i = 0;
                while (i < 3) {
                    if (this.edge[i][k] != x && this.d[this.edge[i][k]] == 1) {
                        this.recStackI[this.recTop] = i + 1;
                        this.recStackK[this.recTop] = k;
                        ++this.recTop;
                        x = this.edge[i][k];
                        inside = false;
                        break;
                    }
                    ++i;
                }
                if (i < 3) continue;
                if (--this.recTop < 0) {
                    return;
                }
                i = this.recStackI[this.recTop];
                k = this.recStackK[this.recTop];
                inside = true;
            }
        }

        private final /* synthetic */ void this() {
            this.r = new MersenneTwister(new Date());
            this.d = new int[MinimalPerfectHash.this.m];
            this.edge = new int[3][MinimalPerfectHash.this.n];
            this.removed = new boolean[MinimalPerfectHash.this.n];
            this.last = new int[MinimalPerfectHash.this.m];
            this.inc = new int[MinimalPerfectHash.this.m * 3];
            this.incOffset = new int[MinimalPerfectHash.this.m];
            this.stack = new int[MinimalPerfectHash.this.n];
            this.recStackI = new int[MinimalPerfectHash.this.n];
            this.recStackK = new int[MinimalPerfectHash.this.n];
        }

        public Visit(Collection terms) {
            int j;
            this.this();
            int v = -1;
            int[] h = new int[3];
            do {
                if (VERBOSE) {
                    System.err.print("Generating random hypergraph...");
                }
                this.top = 0;
                int i = 0;
                while (i < MinimalPerfectHash.this.weightLength) {
                    MinimalPerfectHash.this.weight0[i] = this.r.nextInt();
                    MinimalPerfectHash.this.weight1[i] = this.r.nextInt();
                    MinimalPerfectHash.this.weight2[i] = this.r.nextInt();
                    ++i;
                }
                i = 0;
                CharSequence cs = null;
                IntArrays.fill((int[])this.d, (int)0);
                Iterator w = terms.iterator();
                while (w.hasNext()) {
                    cs = (CharSequence)w.next();
                    MinimalPerfectHash.this.hash(cs, h);
                    if (h[0] == h[1] || h[1] == h[2] || h[2] == h[0]) break;
                    this.edge[0][i] = h[0];
                    this.edge[1][i] = h[1];
                    this.edge[2][i] = h[2];
                    ++i;
                }
                if (i < MinimalPerfectHash.this.n) {
                    if (!VERBOSE) continue;
                    System.err.println(" hypergraph generation interrupted by degenerate hyperedge " + i + " (string: \"" + cs + "\").");
                    continue;
                }
                j = 0;
                while (j < 3) {
                    i = MinimalPerfectHash.this.n;
                    while (i-- != 0) {
                        int n = this.edge[j][i];
                        this.d[n] = this.d[n] + 1;
                    }
                    ++j;
                }
                if (VERBOSE) {
                    System.err.println(" done.");
                    System.err.print("Checking for duplicate hyperedges...");
                }
                i = MinimalPerfectHash.this.n;
                while (i-- != 0) {
                    this.last[i] = i;
                }
                GenericSorting.quickSort((int)0, (int)MinimalPerfectHash.this.n, (IntComparator)new IntComparator(){

                    public final int compare(int x, int y) {
                        int r = Visit.this.edge[0][x] - Visit.this.edge[0][y];
                        if (r != 0) {
                            return r;
                        }
                        r = Visit.this.edge[1][x] - Visit.this.edge[1][y];
                        if (r != 0) {
                            return r;
                        }
                        return Visit.this.edge[2][x] - Visit.this.edge[2][y];
                    }
                }, (Swapper)new Swapper(){

                    public final void swap(int x, int y) {
                        int e0 = Visit.this.edge[0][x];
                        int e1 = Visit.this.edge[1][x];
                        int e2 = Visit.this.edge[2][x];
                        int p = Visit.this.last[x];
                        Visit.this.edge[0][x] = Visit.this.edge[0][y];
                        Visit.this.edge[1][x] = Visit.this.edge[1][y];
                        Visit.this.edge[2][x] = Visit.this.edge[2][y];
                        Visit.this.edge[0][y] = e0;
                        Visit.this.edge[1][y] = e1;
                        Visit.this.edge[2][y] = e2;
                        Visit.this.last[x] = Visit.this.last[y];
                        Visit.this.last[y] = p;
                    }
                });
                i = MinimalPerfectHash.this.n - 1;
                while (i-- != 0) {
                    if (this.edge[0][i + 1] == this.edge[0][i] && this.edge[1][i + 1] == this.edge[1][i] && this.edge[2][i + 1] == this.edge[2][i]) break;
                }
                if (i != -1) {
                    if (!VERBOSE) continue;
                    System.err.println(" found double hyperedge for terms " + this.last[i + 1] + " and " + this.last[i] + '.');
                    continue;
                }
                i = MinimalPerfectHash.this.n;
                while (i-- != 0) {
                    this.stack[this.last[i]] = i;
                }
                GenericPermuting.permute((int[])this.stack, (Swapper)new Swapper(){

                    public final void swap(int x, int y) {
                        int e0 = Visit.this.edge[0][x];
                        int e1 = Visit.this.edge[1][x];
                        int e2 = Visit.this.edge[2][x];
                        Visit.this.edge[0][x] = Visit.this.edge[0][y];
                        Visit.this.edge[1][x] = Visit.this.edge[1][y];
                        Visit.this.edge[2][x] = Visit.this.edge[2][y];
                        Visit.this.edge[0][y] = e0;
                        Visit.this.edge[1][y] = e1;
                        Visit.this.edge[2][y] = e2;
                    }
                }, (int[])this.last, (int[])this.incOffset);
                if (VERBOSE) {
                    System.err.println(" done.");
                    System.err.print("Visiting hypergraph...");
                }
                IntArrays.fill((int[])this.last, (int)0);
                this.incOffset[0] = 0;
                i = 1;
                while (i < MinimalPerfectHash.this.m) {
                    this.incOffset[i] = this.incOffset[i - 1] + this.d[i - 1];
                    ++i;
                }
                i = 0;
                while (i < MinimalPerfectHash.this.n) {
                    j = 0;
                    while (j < 3) {
                        int n = v = this.edge[j][i];
                        int n2 = this.last[n];
                        this.last[n] = n2 + 1;
                        this.inc[this.incOffset[v] + n2] = i;
                        ++j;
                    }
                    ++i;
                }
                BooleanArrays.fill((boolean[])this.removed, (boolean)false);
                i = 0;
                while (i < MinimalPerfectHash.this.m) {
                    if (this.d[i] == 1) {
                        this.visit(i);
                    }
                    ++i;
                }
                if (!VERBOSE) continue;
                if (this.top == MinimalPerfectHash.this.n) {
                    System.err.println(" done.");
                    continue;
                }
                System.err.println(" failed: stripped " + this.top + " hyperedges out of " + MinimalPerfectHash.this.n + '.');
            } while (this.top != MinimalPerfectHash.this.n);
            if (VERBOSE) {
                System.err.print("Assigning values...");
            }
            IntArrays.fill((int[])MinimalPerfectHash.this.g, (int)-1);
            while (this.top > 0) {
                int k = this.stack[--this.top];
                int s = 0;
                j = 0;
                while (j < 3) {
                    if (MinimalPerfectHash.this.g[this.edge[j][k]] == -1) {
                        MinimalPerfectHash.this.g[this.edge[j][k]] = 0;
                        v = this.edge[j][k];
                    } else {
                        s += MinimalPerfectHash.this.g[this.edge[j][k]];
                    }
                    ++j;
                }
                MinimalPerfectHash.this.g[v] = ((k - s) % MinimalPerfectHash.this.n + MinimalPerfectHash.this.n) % MinimalPerfectHash.this.n;
            }
            if (VERBOSE) {
                System.err.println(" done.");
            }
        }
    }
}

