/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdf.generator;

import org.apache.poi.generator.FieldIterator;

public class HDFFieldIterator
extends FieldIterator {
    public String fillDecoder(String size, String type) {
        String result = "";
        if (type.equals("short[]")) {
            result = "LittleEndian.getSimpleShortArray(data, 0x" + Integer.toHexString(this.offset) + " + offset, size)";
        } else if (type.equals("byte[]")) {
            result = "LittleEndian.getByteArray(data, 0x" + Integer.toHexString(this.offset) + " + offset, size)";
        }
        if (size.equals("2")) {
            result = "LittleEndian.getShort(data, 0x" + Integer.toHexString(this.offset) + " + offset)";
        } else if (size.equals("4")) {
            result = "LittleEndian.getInt(data, 0x" + Integer.toHexString(this.offset) + " + offset)";
        } else if (size.equals("1")) {
            result = "data[ 0x" + Integer.toHexString(this.offset) + " + offset ]";
        } else if (type.equals("double")) {
            result = "LittleEndian.getDouble(data, 0x" + Integer.toHexString(this.offset) + " + offset)";
        }
        try {
            this.offset += Integer.parseInt(size);
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        return result;
    }
}

