/* 
 * ========================================================================
 * 
 * Copyright 2003 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * ========================================================================
 */
package org.apache.cactus.integration.ant.container.tomcat;

import java.io.IOException;

import org.apache.tools.ant.BuildException;

/**
 * Special container support for the Apache Tomcat 5.x servlet container.
 * 
 * @version $Id: Tomcat5xContainer.java 238811 2004-02-29 10:10:42Z vmassol $
 */
public class Tomcat5xContainer extends AbstractCatalinaContainer
{

    // Container Implementation ------------------------------------------------

    /**
     * @see org.apache.cactus.integration.ant.container.Container#init
     */
    public final void init()
    {
        super.init();

        if (!getVersion().startsWith("5"))
        {
            throw new BuildException(
                "This element doesn't support version " + getVersion()
                + " of Tomcat");
        }
    }

    /**
     * @see org.apache.cactus.integration.ant.container.Container#startUp
     */
    public final void startUp()
    {
        try
        {
            prepare("tomcat5x", "cactus/tomcat5x");
            invokeBootstrap("start");
        }
        catch (IOException ioe)
        {
            getLog().error("Failed to startup the container", ioe);
            throw new BuildException(ioe);
        }
    }

    /**
     * @see org.apache.cactus.integration.ant.container.Container#shutDown
     */
    public final void shutDown()
    {
        invokeBootstrap("stop");
    }

}
