/* 
 * ========================================================================
 * 
 * Copyright 2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * ========================================================================
 */
package org.apache.cactus;

import org.apache.cactus.extension.jetty.TestJettyTestSetup;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Run all the Cactus unit tests related to J2EE API 1.3.
 *
 * @version $Id: TestAll.java 238991 2004-05-22 11:34:50Z vmassol $
 */
public class TestAll
{
    /**
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     * @exception Exception on failure to load the cactus properties file
     */
    public static Test suite() throws Exception
    {
        TestSuite suite = new TestSuite(
            "Cactus unit tests for J2EE 1.3");

        // Add shared tests
        suite.addTest(TestShareAll.suite());

        // Add tests specific to the J2EE 1.3 API
        suite.addTestSuite(TestJettyTestSetup.class);
        
        return suite;
    }
}
