/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import nextapp.echo.AbstractImageReference;

public class AwtImageReference
extends AbstractImageReference {
    private transient Image image;

    public AwtImageReference(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public int getHeight() {
        int height = this.image == null ? -1 : this.image.getHeight(null);
        return height;
    }

    public int getWidth() {
        int width = this.image == null ? -1 : this.image.getWidth(null);
        return width;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int width = in.readInt();
        int height = in.readInt();
        int[] pixels = (int[])in.readObject();
        if (pixels != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ColorModel colorModel = ColorModel.getRGBdefault();
            this.image = toolkit.createImage(new MemoryImageSource(width, height, colorModel, pixels, 0, width));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int width = this.getWidth();
        int height = this.getHeight();
        out.writeInt(width);
        out.writeInt(height);
        if (this.image == null) {
            out.writeObject(null);
        } else {
            int[] pixels = new int[width * height];
            try {
                PixelGrabber pg = new PixelGrabber(this.image, 0, 0, width, height, pixels, 0, width);
                pg.grabPixels();
                if ((pg.getStatus() & 0x80) != 0) {
                    throw new IOException("Unable to serialize java.awt.image: PixelGrabber aborted.");
                }
            }
            catch (InterruptedException ex) {
                throw new IOException("Unable to serialize java.awt.Image: PixelGrabber interrupted.");
            }
            out.writeObject(pixels);
        }
    }
}

