/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import nextapp.echo.Extent;
import nextapp.echo.ImageReference;

public class BackgroundImageProperties
implements Serializable {
    public static final int REPEAT = 0;
    public static final int NO_REPEAT = 1;
    public static final int REPEAT_HORIZONTAL = 2;
    public static final int REPEAT_VERTICAL = 3;
    public static final int PERCENT_UNITS = 2;
    public static final int PIXEL_UNITS = 1;
    public static final int ATTACHMENT_FIXED = 0;
    public static final int ATTACHMENT_SCROLL = 1;
    public static final String REPEAT_CHANGED_PROPERTY = "repeat";
    public static final String IMAGE_CHANGED_PROPERTY = "image";
    public static final String ATTACHMENT_CHANGED_PROPERTY = "image";
    public static final String HORIZONTAL_POSITION_CHANGED_PROPERTY = "horizontalPosition";
    public static final String VERTICAL_POSITION_CHANGED_PROPERTY = "verticalPosition";
    private ImageReference image = null;
    private int attachment;
    private int repeat;
    private Extent horizontalPositionExtent;
    private Extent verticalPositionExtent;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public BackgroundImageProperties(ImageReference image) {
        this.image = image;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public int getAttachment() {
        return this.attachment;
    }

    public int getHorizontalPosition() {
        Extent extent = this.getHorizontalPositionExtent();
        if (extent == null) {
            return 0;
        }
        return extent.getValue();
    }

    public Extent getHorizontalPositionExtent() {
        return this.horizontalPositionExtent;
    }

    public int getHorizontalPositionUnits() {
        Extent extent = this.getHorizontalPositionExtent();
        if (extent == null) {
            return 1;
        }
        return extent.getUnits();
    }

    public ImageReference getImage() {
        return this.image;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public Extent getVerticalPositionExtent() {
        return this.verticalPositionExtent;
    }

    public int getVerticalPosition() {
        Extent extent = this.getVerticalPositionExtent();
        if (extent == null) {
            return 0;
        }
        return extent.getValue();
    }

    public int getVerticalPositionUnits() {
        Extent extent = this.getVerticalPositionExtent();
        if (extent == null) {
            return 0;
        }
        return extent.getUnits();
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void setAttachment(int newValue) {
        int oldValue = this.attachment;
        this.attachment = newValue;
        this.pcs.firePropertyChange("image", oldValue, newValue);
    }

    public void setHorizontalPosition(int newValue) {
        Extent extent = new Extent(newValue, this.getHorizontalPositionUnits());
        this.setHorizontalPositionExtent(extent);
    }

    public void setHorizontalPositionExtent(Extent newValue) {
        Extent oldValue = this.horizontalPositionExtent;
        this.horizontalPositionExtent = newValue;
        this.pcs.firePropertyChange(HORIZONTAL_POSITION_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setHorizontalPositionUnits(int newValue) {
        Extent extent = new Extent(this.getHorizontalPosition(), newValue);
        this.setHorizontalPositionExtent(extent);
    }

    public void setImage(ImageReference newValue) {
        ImageReference oldValue = this.image;
        this.image = newValue;
        this.pcs.firePropertyChange("image", oldValue, newValue);
    }

    public void setRepeat(int newValue) {
        int oldValue = this.repeat;
        this.repeat = newValue;
        this.pcs.firePropertyChange(REPEAT_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setVerticalPosition(int newValue) {
        Extent extent = new Extent(newValue, this.getVerticalPositionUnits());
        this.setVerticalPositionExtent(extent);
    }

    public void setVerticalPositionExtent(Extent newValue) {
        Extent oldValue = this.verticalPositionExtent;
        this.verticalPositionExtent = newValue;
        this.pcs.firePropertyChange(VERTICAL_POSITION_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setVerticalPositionUnits(int newValue) {
        Extent extent = new Extent(this.getVerticalPosition(), newValue);
        this.setVerticalPositionExtent(extent);
    }
}

