/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import nextapp.echo.Button;
import nextapp.echo.Color;
import nextapp.echo.DefaultButtonModel;
import nextapp.echo.Extent;
import nextapp.echo.ImageReference;
import nextapp.echo.Insets;
import nextapp.echo.Style;

public class CButton
extends Button {
    public static final int BORDER_INSET = 2;
    public static final int BORDER_NONE = 0;
    public static final int BORDER_OUTSET = 3;
    public static final int BORDER_SOLID = 1;
    public static final String STYLE_BORDER_COLOR = "borderColor";
    public static final String STYLE_BORDER_SIZE = "borderSize";
    public static final String STYLE_BORDER_STYLE = "borderStyle";
    public static final String STYLE_HEIGHT_EXTENT = "heightExtent";
    public static final String STYLE_INSETS = "insets";
    public static final String STYLE_PRESSED_BORDER_COLOR = "pressedBorderColor";
    public static final String STYLE_PRESSED_BORDER_STYLE = "pressedBorderStyle";
    public static final String STYLE_PRESSED_FOREGROUND = "pressedForeground";
    public static final String STYLE_PRESSED_BACKGROUND = "pressedBackground";
    public static final String STYLE_ROLLOVER_BORDER_COLOR = "rolloverBorderColor";
    public static final String STYLE_WIDTH_EXTENT = "widthExtent";
    public static final String BORDER_COLOR_CHANGED_PROPERTY = "borderColor";
    public static final String BORDER_SIZE_CHANGED_PROPERTY = "borderSize";
    public static final String BORDER_STYLE_CHANGED_PROPERTY = "borderStyle";
    public static final String HEIGHT_EXTENT_CHANGED_PROPERTY = "heightExtent";
    public static final String INSETS_CHANGED_PROPERTY = "insets";
    public static final String PRESSED_BORDER_COLOR_CHANGED_PROPERTY = "pressedBorderColor";
    public static final String PRESSED_BORDER_STYLE_CHANGED_PROPERTY = "pressedBorderStyle";
    public static final String PRESSED_BACKGROUND_CHANGED_PROPERTY = "pressedBackground";
    public static final String PRESSED_FOREGROUND_CHANGED_PROPERTY = "pressedForeground";
    public static final String ROLLOVER_BORDER_COLOR_CHANGED_PROPERTY = "rolloverBorderColor";
    public static final String WIDTH_EXTENT_CHANGED_PROPERTY = "widthExtent";
    public static final Insets DEFAULT_INSETS = new Insets(5);
    private Color borderColor = Color.BLACK;
    private int borderSize = 1;
    private int borderStyle = 1;
    private Insets insets = DEFAULT_INSETS;
    private Color pressedBorderColor;
    private int pressedBorderStyle;
    private Color pressedForeground;
    private Color pressedBackground;
    private Extent widthExtent;
    private Extent heightExtent;
    private Color rolloverBorderColor;

    public CButton() {
        this(null, null);
    }

    public CButton(ImageReference icon) {
        this(null, icon);
    }

    public CButton(String text) {
        this(text, null);
    }

    public CButton(String text, ImageReference icon) {
        this.setModel(new DefaultButtonModel());
        this.setIcon(icon);
        this.setText(text);
    }

    public void applyStyle(Style style) {
        super.applyStyle(style);
        if (style.hasAttribute("borderColor")) {
            this.setBorderColor((Color)style.getAttribute("borderColor"));
        }
        if (style.hasAttribute("borderSize")) {
            this.setBorderSize(style.getIntegerAttribute("borderSize"));
        }
        if (style.hasAttribute("borderStyle")) {
            this.setBorderStyle(style.getIntegerAttribute("borderStyle"));
        }
        if (style.hasAttribute("heightExtent")) {
            this.setHeightExtent((Extent)style.getAttribute("heightExtent"));
        }
        if (style.hasAttribute("insets")) {
            this.setInsets((Insets)style.getAttribute("insets"));
        }
        if (style.hasAttribute("pressedBackground")) {
            this.setPressedBackground((Color)style.getAttribute("pressedBackground"));
        }
        if (style.hasAttribute("pressedBorderColor")) {
            this.setPressedBorderColor((Color)style.getAttribute("pressedBorderColor"));
        }
        if (style.hasAttribute("pressedBorderStyle")) {
            this.setPressedBorderStyle(style.getIntegerAttribute("pressedBorderStyle"));
        }
        if (style.hasAttribute("pressedForeground")) {
            this.setPressedForeground((Color)style.getAttribute("pressedForeground"));
        }
        if (style.hasAttribute("rolloverBorderColor")) {
            this.setRolloverBorderColor((Color)style.getAttribute("rolloverBorderColor"));
        }
        if (style.hasAttribute("widthExtent")) {
            this.setWidthExtent((Extent)style.getAttribute("widthExtent"));
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public Extent getHeightExtent() {
        return this.heightExtent;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Color getPressedBackground() {
        return this.pressedBackground;
    }

    public Color getPressedBorderColor() {
        return this.pressedBorderColor;
    }

    public int getPressedBorderStyle() {
        return this.pressedBorderStyle;
    }

    public Color getPressedForeground() {
        return this.pressedForeground;
    }

    public Color getRolloverBorderColor() {
        return this.rolloverBorderColor;
    }

    public Extent getWidthExtent() {
        return this.widthExtent;
    }

    public void setBorderColor(Color newValue) {
        Color oldValue = this.borderColor;
        this.borderColor = newValue;
        this.firePropertyChange("borderColor", oldValue, newValue);
    }

    public void setBorderSize(int newValue) {
        int oldValue = this.borderSize;
        this.borderSize = newValue;
        this.firePropertyChange("borderSize", oldValue, newValue);
    }

    public void setBorderStyle(int newValue) {
        int oldValue = this.borderStyle;
        this.borderStyle = newValue;
        this.firePropertyChange("borderStyle", oldValue, newValue);
    }

    public void setHeightExtent(Extent newValue) {
        Extent oldValue = this.heightExtent;
        this.heightExtent = newValue;
        this.firePropertyChange("heightExtent", oldValue, newValue);
    }

    public void setInsets(Insets newValue) {
        Insets oldValue = this.insets;
        this.insets = newValue;
        this.firePropertyChange("insets", oldValue, newValue);
    }

    public void setPressedBackground(Color newValue) {
        Color oldValue = this.pressedBackground;
        this.pressedBackground = newValue;
        this.firePropertyChange("pressedBackground", oldValue, newValue);
    }

    public void setPressedBorderColor(Color newValue) {
        Color oldValue = this.pressedBorderColor;
        this.pressedBorderColor = newValue;
        this.firePropertyChange("pressedBorderColor", oldValue, newValue);
    }

    public void setPressedBorderStyle(int newValue) {
        int oldValue = this.pressedBorderStyle;
        this.pressedBorderStyle = newValue;
        this.firePropertyChange("pressedBorderStyle", oldValue, newValue);
    }

    public void setPressedForeground(Color newValue) {
        Color oldValue = this.pressedForeground;
        this.pressedForeground = newValue;
        this.firePropertyChange("pressedForeground", oldValue, newValue);
    }

    public void setRolloverBorderColor(Color newValue) {
        Color oldValue = this.rolloverBorderColor;
        this.rolloverBorderColor = newValue;
        this.firePropertyChange("rolloverBorderColor", oldValue, newValue);
    }

    public void setWidthExtent(Extent newValue) {
        Extent oldValue = this.widthExtent;
        this.widthExtent = newValue;
        this.firePropertyChange("widthExtent", oldValue, newValue);
    }
}

