/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.io.Serializable;

public class Color
implements Serializable {
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color BLUE = new Color(0, 0, 255);
    public static final Color GREEN = new Color(0, 255, 0);
    public static final Color CYAN = new Color(0, 255, 255);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color MAGENTA = new Color(255, 0, 255);
    public static final Color YELLOW = new Color(255, 255, 0);
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color DARKGRAY = new Color(127, 127, 127);
    public static final Color LIGHTGRAY = new Color(175, 175, 175);
    public static final Color ORANGE = new Color(255, 175, 0);
    public static final Color PINK = new Color(255, 175, 175);
    private int r;
    private int g;
    private int b;

    public Color(int rgb) {
        this.r = (rgb & 0xFF0000) / 65536;
        this.g = (rgb & 0xFF00) / 256;
        this.b = rgb & 0xFF;
    }

    public Color(int r, int g, int b) {
        this.r = r & 0xFF;
        this.g = g & 0xFF;
        this.b = b & 0xFF;
    }

    public boolean equals(Object o) {
        boolean equal;
        if (this == o) {
            equal = true;
        } else if (o instanceof Color) {
            Color that = (Color)o;
            equal = this.r == that.r && this.g == that.g && this.b == that.b;
        } else {
            equal = false;
        }
        return equal;
    }

    public int getBlue() {
        return this.b;
    }

    public int getGreen() {
        return this.g;
    }

    public int getRed() {
        return this.r;
    }

    public int getRgb() {
        return this.r * 65536 + this.g * 256 + this.b;
    }

    public int hashCode() {
        return this.getRgb();
    }

    public String toString() {
        return this.getClass().getName() + " [r=" + this.r + ",g=" + this.g + ",b=" + this.b + "]";
    }
}

