/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import nextapp.echo.AbstractPane;
import nextapp.echo.Extent;
import nextapp.echo.Style;

public class ContainerPane
extends AbstractPane {
    public static final String CONTENT_CHANGED_PROPERTY = "content";
    public static final String ORIENTATION_CHANGED_PROPERTY = "orientation";
    public static final String PREFERRED_HEIGHT_CHANGED_PROPERTY = "preferredHeight";
    public static final String PREFERRED_HEIGHT_EXTENT_CHANGED_PROPERTY = "preferredHeightExtent";
    public static final String PREFERRED_WIDTH_CHANGED_PROPERTY = "preferredWidth";
    public static final String PREFERRED_WIDTH_EXTENT_CHANGED_PROPERTY = "preferredWidthExtent";
    public static final String STYLE_ORIENTATION = "orientation";
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    private int orientation;
    private Extent preferredHeightExtent = null;
    private Extent preferredWidthExtent = null;

    public ContainerPane() {
        this(0);
    }

    public ContainerPane(int orientation) {
        this.orientation = orientation;
    }

    public void add(AbstractPane pane) {
        super.add(pane);
        this.firePropertyChange(CONTENT_CHANGED_PROPERTY, null, pane);
    }

    public void add(AbstractPane pane, int index) {
        super.add(pane, index);
        this.firePropertyChange(CONTENT_CHANGED_PROPERTY, null, pane);
    }

    public void applyStyle(Style style) {
        super.applyStyle(style);
        if (style.hasAttribute("orientation")) {
            this.setOrientation(style.getIntegerAttribute("orientation"));
        }
    }

    public Extent getHeightExtent() {
        if (this.preferredHeightExtent == null) {
            int childCount = this.getComponentCount();
            if (childCount == 0) {
                return null;
            }
            AbstractPane pane = null;
            Extent calculatedHeight = null;
            if (this.orientation == 0) {
                for (int index = 0; index < childCount; ++index) {
                    pane = (AbstractPane)this.getComponent(index);
                    Extent paneHeight = pane.getHeightExtent();
                    if (paneHeight == null || paneHeight.isPercentage()) {
                        return null;
                    }
                    if (calculatedHeight == null) {
                        calculatedHeight = pane.getHeightExtent();
                        continue;
                    }
                    if ((calculatedHeight = Extent.add(calculatedHeight, paneHeight)) != null) continue;
                    return null;
                }
                return calculatedHeight;
            }
            for (int index = 0; index < childCount; ++index) {
                pane = (AbstractPane)this.getComponent(index);
                Extent paneHeight = pane.getHeightExtent();
                if (paneHeight == null || paneHeight.isPercentage()) {
                    return null;
                }
                if (calculatedHeight == null) {
                    calculatedHeight = paneHeight;
                    continue;
                }
                if (!paneHeight.isComparableTo(calculatedHeight)) {
                    return null;
                }
                if (paneHeight.compareTo(calculatedHeight) <= 0) continue;
                calculatedHeight = paneHeight;
            }
            return calculatedHeight;
        }
        return this.preferredHeightExtent;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getPreferredHeight() {
        Extent extent = this.getPreferredHeightExtent();
        return extent != null && extent.getUnits() == 1 ? extent.getValue() : Integer.MIN_VALUE;
    }

    public Extent getPreferredHeightExtent() {
        return this.preferredHeightExtent;
    }

    public int getPreferredWidth() {
        Extent extent = this.getPreferredWidthExtent();
        return extent != null && extent.getUnits() == 1 ? extent.getValue() : Integer.MIN_VALUE;
    }

    public Extent getPreferredWidthExtent() {
        return this.preferredWidthExtent;
    }

    public Extent getWidthExtent() {
        if (this.preferredWidthExtent == null) {
            int childCount = this.getComponentCount();
            if (childCount == 0) {
                return null;
            }
            AbstractPane pane = null;
            Extent calculatedWidth = null;
            if (this.orientation == 0) {
                for (int index = 0; index < childCount; ++index) {
                    pane = (AbstractPane)this.getComponent(index);
                    Extent paneWidth = pane.getWidthExtent();
                    if (paneWidth == null || paneWidth.isPercentage()) {
                        return null;
                    }
                    if (calculatedWidth == null) {
                        calculatedWidth = paneWidth;
                        continue;
                    }
                    if (!paneWidth.isComparableTo(calculatedWidth)) {
                        return null;
                    }
                    if (paneWidth.compareTo(calculatedWidth) <= 0) continue;
                    calculatedWidth = paneWidth;
                }
                return calculatedWidth;
            }
            for (int index = 0; index < childCount; ++index) {
                pane = (AbstractPane)this.getComponent(index);
                Extent paneWidth = pane.getWidthExtent();
                if (paneWidth == null || paneWidth.isPercentage()) {
                    return null;
                }
                if (calculatedWidth == null) {
                    calculatedWidth = pane.getWidthExtent();
                    continue;
                }
                if ((calculatedWidth = Extent.add(calculatedWidth, paneWidth)) != null) continue;
                return null;
            }
            return calculatedWidth;
        }
        return this.preferredWidthExtent;
    }

    public void remove(AbstractPane pane) {
        super.remove(pane);
        this.firePropertyChange(CONTENT_CHANGED_PROPERTY, pane, null);
    }

    public void setPreferredHeight(int newValue) {
        int oldValue = this.getPreferredHeight();
        this.setPreferredHeightExtent(newValue == Integer.MIN_VALUE ? null : new Extent(newValue, 1));
        this.firePropertyChange(PREFERRED_HEIGHT_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setPreferredHeightExtent(Extent newValue) {
        Extent oldValue = this.preferredHeightExtent;
        this.preferredHeightExtent = newValue;
        this.firePropertyChange(PREFERRED_HEIGHT_EXTENT_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setOrientation(int newValue) {
        int oldValue = this.orientation;
        this.orientation = newValue;
        this.firePropertyChange("orientation", oldValue, newValue);
    }

    public void setPreferredWidth(int newValue) {
        int oldValue = this.getPreferredWidth();
        this.setPreferredWidthExtent(newValue == Integer.MIN_VALUE ? null : new Extent(newValue, 1));
        this.firePropertyChange(PREFERRED_WIDTH_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setPreferredWidthExtent(Extent newValue) {
        Extent oldValue = this.preferredWidthExtent;
        this.preferredWidthExtent = newValue;
        this.firePropertyChange(PREFERRED_WIDTH_EXTENT_CHANGED_PROPERTY, oldValue, newValue);
    }
}

