/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import nextapp.echo.AbstractPane;
import nextapp.echo.BackgroundImageProperties;
import nextapp.echo.EchoInstance;
import nextapp.echo.Extent;
import nextapp.echo.ImageReference;
import nextapp.echo.Insets;
import nextapp.echo.Style;

public class ContentPane
extends AbstractPane {
    public static final String STYLE_BACKGROUND_IMAGE = "backgroundImage";
    public static final String STYLE_BACKGROUND_IMAGE_PROPERTIES = "backgroundImageProperties";
    public static final String STYLE_HEIGHT = "height";
    public static final String STYLE_HEIGHT_EXTENT = "heightExtent";
    public static final String STYLE_HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String STYLE_INSETS = "insets";
    public static final String STYLE_SCROLL_BAR_POLICY = "scrollBarPolicy";
    public static final String STYLE_VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String STYLE_WIDTH = "width";
    public static final String STYLE_WIDTH_EXTENT = "widthExtent";
    public static final String BACKGROUND_IMAGE_PROPERTIES_CHANGED_PROPERTY = "backgroundImageProperties";
    public static final String HEIGHT_CHANGED_PROPERTY = "height";
    public static final String HEIGHT_EXTENT_CHANGED_PROPERTY = "heightExtent";
    public static final String HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY = "horizontalAlignment";
    public static final String INSETS_CHANGED_PROPERTY = "insets";
    public static final String SCROLL_BAR_POLICY_CHANGED_PROPERTY = "scrollBarPolicy";
    public static final String SCROLL_BAR_X_CHANGED_PROPERTY = "scrollBarX";
    public static final String SCROLL_BAR_Y_CHANGED_PROPERTY = "scrollBarY";
    public static final String VERTICAL_ALIGNMENT_CHANGED_PROPERTY = "verticalAlignment";
    public static final String WIDTH_CHANGED_PROPERTY = "width";
    public static final String WIDTH_EXTENT_CHANGED_PROPERTY = "widthExtent";
    public static final int SCROLL_BAR_AUTO = 0;
    public static final int SCROLL_BAR_ALWAYS = 1;
    public static final int SCROLL_BAR_NEVER = 2;
    public static final Insets DEFAULT_INSETS = new Insets(10);
    private Insets insets = DEFAULT_INSETS;
    private int scrollBarPolicy = 0;
    private int scrollBarX = 0;
    private int scrollBarY = 0;
    private int horizontalAlignment = 2;
    private int verticalAlignment = 1;
    private BackgroundImageProperties backgroundImageProperties = null;
    private PropertyChangeForwarder propertyChangeForwarder = new PropertyChangeForwarder();
    private Extent widthExtent = null;
    private Extent heightExtent = null;

    public ContentPane() {
        this.setForeground(EchoInstance.DEFAULT_FOREGROUND);
        this.setBackground(EchoInstance.DEFAULT_BACKGROUND);
        this.setFont(EchoInstance.DEFAULT_FONT);
    }

    public void applyStyle(Style style) {
        super.applyStyle(style);
        if (style.hasAttribute(STYLE_BACKGROUND_IMAGE)) {
            this.setBackgroundImage((ImageReference)style.getAttribute(STYLE_BACKGROUND_IMAGE));
        }
        if (style.hasAttribute("backgroundImageProperties")) {
            this.setBackgroundImageProperties((BackgroundImageProperties)style.getAttribute("backgroundImageProperties"));
        }
        if (style.hasAttribute("height")) {
            this.setHeight(style.getIntegerAttribute("height"));
        }
        if (style.hasAttribute("heightExtent")) {
            this.setHeightExtent((Extent)style.getAttribute("heightExtent"));
        }
        if (style.hasAttribute("horizontalAlignment")) {
            this.setHorizontalAlignment(style.getIntegerAttribute("horizontalAlignment"));
        }
        if (style.hasAttribute("insets")) {
            this.setInsets((Insets)style.getAttribute("insets"));
        }
        if (style.hasAttribute("scrollBarPolicy")) {
            this.setScrollBarPolicy(style.getIntegerAttribute("scrollBarPolicy"));
        }
        if (style.hasAttribute("verticalAlignment")) {
            this.setVerticalAlignment(style.getIntegerAttribute("verticalAlignment"));
        }
        if (style.hasAttribute("width")) {
            this.setWidth(style.getIntegerAttribute("width"));
        }
        if (style.hasAttribute("widthExtent")) {
            this.setWidthExtent((Extent)style.getAttribute("widthExtent"));
        }
    }

    public ImageReference getBackgroundImage() {
        if (this.backgroundImageProperties == null) {
            return null;
        }
        return this.backgroundImageProperties.getImage();
    }

    public BackgroundImageProperties getBackgroundImageProperties() {
        return this.backgroundImageProperties;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public Extent getHeightExtent() {
        return this.heightExtent;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Extent getWidthExtent() {
        return this.widthExtent;
    }

    public int getScrollBarPolicy() {
        return this.scrollBarPolicy;
    }

    public int getScrollBarX() {
        return this.scrollBarX;
    }

    public int getScrollBarY() {
        return this.scrollBarY;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setBackgroundImage(ImageReference newValue) {
        if (this.backgroundImageProperties == null) {
            this.setBackgroundImageProperties(new BackgroundImageProperties(newValue));
        } else {
            this.backgroundImageProperties.setImage(newValue);
        }
    }

    public void setBackgroundImageProperties(BackgroundImageProperties newValue) {
        BackgroundImageProperties oldValue = this.backgroundImageProperties;
        if (oldValue != null) {
            oldValue.removePropertyChangeListener(this.propertyChangeForwarder);
        }
        if (newValue != null) {
            newValue.addPropertyChangeListener(this.propertyChangeForwarder);
        }
        this.backgroundImageProperties = newValue;
        this.firePropertyChange("backgroundImageProperties", oldValue, newValue);
    }

    public void setHeight(int newValue) {
        Extent heightExtent = this.getHeightExtent();
        int oldValue = heightExtent != null && heightExtent.getUnits() == 1 ? heightExtent.getValue() : Integer.MIN_VALUE;
        this.setHeightExtent(new Extent(newValue, 1));
        this.firePropertyChange("height", oldValue, newValue);
    }

    public void setHeightExtent(Extent newValue) {
        Extent oldValue = this.heightExtent;
        this.heightExtent = newValue;
        this.firePropertyChange("heightExtent", oldValue, newValue);
    }

    public void setHorizontalAlignment(int newValue) {
        int oldValue = this.horizontalAlignment;
        this.horizontalAlignment = newValue;
        this.firePropertyChange("horizontalAlignment", oldValue, newValue);
    }

    public void setInsets(Insets newValue) {
        Insets oldValue = this.insets;
        this.insets = newValue;
        this.firePropertyChange("insets", oldValue, newValue);
    }

    public void setScrollBarPolicy(int newValue) {
        int oldValue = this.scrollBarPolicy;
        this.scrollBarPolicy = newValue;
        this.firePropertyChange("scrollBarPolicy", oldValue, newValue);
    }

    public void setScrollBarX(int newValue) {
        int oldValue = this.scrollBarX;
        this.scrollBarX = newValue;
        this.firePropertyChange(SCROLL_BAR_X_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setScrollBarY(int newValue) {
        int oldValue = this.scrollBarY;
        this.scrollBarY = newValue;
        this.firePropertyChange(SCROLL_BAR_Y_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setVerticalAlignment(int newValue) {
        int oldValue = this.verticalAlignment;
        this.verticalAlignment = newValue;
        this.firePropertyChange("verticalAlignment", oldValue, newValue);
    }

    public void setWidth(int newValue) {
        Extent widthExtent = this.getWidthExtent();
        int oldValue = widthExtent != null && widthExtent.getUnits() == 1 ? widthExtent.getValue() : Integer.MIN_VALUE;
        this.setWidthExtent(new Extent(newValue, 1));
        this.firePropertyChange("width", oldValue, newValue);
    }

    public void setWidthExtent(Extent newValue) {
        Extent oldValue = this.widthExtent;
        this.widthExtent = newValue;
        this.firePropertyChange("widthExtent", oldValue, newValue);
    }

    private class PropertyChangeForwarder
    implements PropertyChangeListener,
    Serializable {
        private PropertyChangeForwarder() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == ContentPane.this.backgroundImageProperties) {
                ContentPane.this.firePropertyChange("backgroundImageProperties", null, null);
            }
        }
    }
}

