/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.io.Serializable;
import nextapp.echo.Component;
import nextapp.echo.DefaultListCellRenderer;
import nextapp.echo.DefaultListModel;
import nextapp.echo.DefaultListSelectionModel;
import nextapp.echo.ListCellRenderer;
import nextapp.echo.ListModel;
import nextapp.echo.ListSelectionModel;
import nextapp.echo.Style;
import nextapp.echo.ToolTipSupport;
import nextapp.echo.event.ListDataEvent;
import nextapp.echo.event.ListDataListener;
import nextapp.echo.event.ListSelectionEvent;
import nextapp.echo.event.ListSelectionListener;

public class ListBox
extends Component
implements ToolTipSupport {
    public static final int PIXEL_UNITS = 0;
    public static final int PERCENT_UNITS = 2;
    public static final String STYLE_WIDTH = "width";
    public static final String STYLE_WIDTH_UNITS = "widthUnits";
    public static final String STYLE_VISIBLE_ROW_COUNT = "visibleRowCount";
    public static final String CELL_RENDERER_CHANGED_PROPERTY = "cellRenderer";
    public static final String LIST_DATA_CHANGED_PROPERTY = "listData";
    public static final String LIST_SELECTION_CHANGED_PROPERTY = "listSelection";
    public static final String SELECTION_MODEL_CHANGED_PROPERTY = "selectionModel";
    public static final String VISIBLE_ROW_COUNT_CHANGED_PROPERTY = "visibleRowCount";
    public static final String WIDTH_CHANGED_PROPERTY = "width";
    public static final String WIDTH_UNITS_CHANGED_PROPERTY = "widthUnits";
    private ListCellRenderer cellRenderer = DefaultListCellRenderer.DEFAULT_LIST_CELL_RENDERER;
    private ListModel model;
    private ListSelectionModel selectionModel;
    private int visibleRowCount = 8;
    private ListSelectionListener selectionListener = new ListSelectionHandler();
    private ListDataListener dataListener = new ListDataHandler();
    private String toolTipText;
    private int width = -1;
    private int widthUnits = 0;

    public ListBox() {
        this(new DefaultListModel());
    }

    public ListBox(ListModel model) {
        this.model = model;
        model.addListDataListener(this.dataListener);
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.addListSelectionListener(this.selectionListener);
    }

    public ListBox(Object[] elements) {
        this();
        DefaultListModel model = (DefaultListModel)this.getModel();
        for (int index = 0; index < elements.length; ++index) {
            model.add(elements[index]);
        }
    }

    public void applyStyle(Style style) {
        super.applyStyle(style);
        if (style.hasAttribute("visibleRowCount")) {
            this.setVisibleRowCount(style.getIntegerAttribute("visibleRowCount"));
        }
        if (style.hasAttribute("width")) {
            this.setWidth(style.getIntegerAttribute("width"));
        }
        if (style.hasAttribute("widthUnits")) {
            this.setWidthUnits(style.getIntegerAttribute("widthUnits"));
        }
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
    }

    public ListCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public int getMaxSelectedIndex() {
        return this.selectionModel.getMaxSelectedIndex();
    }

    public int getMinSelectedIndex() {
        return this.selectionModel.getMinSelectedIndex();
    }

    public ListModel getModel() {
        return this.model;
    }

    public int getSelectedIndex() {
        return this.getMinSelectedIndex();
    }

    public Object getSelectedValue() {
        int selectedIndex = this.getMinSelectedIndex();
        Object value = selectedIndex == -1 ? null : this.model.get(this.getMinSelectedIndex());
        return value;
    }

    public int[] getSelectedIndices() {
        int size;
        int min = this.getMinSelectedIndex();
        if (min == -1) {
            return new int[0];
        }
        int selectionCount = 0;
        int max = this.getMaxSelectedIndex();
        if (max >= (size = this.model.size()) - 1) {
            max = size - 1;
        }
        for (int index = min; index <= max; ++index) {
            if (!this.isSelectedIndex(index)) continue;
            ++selectionCount;
        }
        int[] selectedIndices = new int[selectionCount];
        selectionCount = 0;
        for (int index = min; index <= max; ++index) {
            if (!this.isSelectedIndex(index)) continue;
            selectedIndices[selectionCount] = index;
            ++selectionCount;
        }
        return selectedIndices;
    }

    public Object[] getSelectedValues() {
        int size;
        int min = this.getMinSelectedIndex();
        if (min == -1) {
            return new Object[0];
        }
        int selectionCount = 0;
        int max = this.getMaxSelectedIndex();
        if (max >= (size = this.model.size()) - 1) {
            max = size - 1;
        }
        for (int index = min; index <= max; ++index) {
            if (!this.isSelectedIndex(index)) continue;
            ++selectionCount;
        }
        Object[] selectedValues = new Object[selectionCount];
        selectionCount = 0;
        for (int index = min; index <= max; ++index) {
            if (!this.isSelectedIndex(index)) continue;
            selectedValues[selectionCount] = this.model.get(index);
            ++selectionCount;
        }
        return selectedValues;
    }

    public int getSelectionMode() {
        return this.selectionModel.getSelectionMode();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public int getWidth() {
        return this.width;
    }

    public int getWidthUnits() {
        return this.widthUnits;
    }

    public boolean isSelectedIndex(int index) {
        return this.selectionModel.isSelectedIndex(index);
    }

    public void setCellRenderer(ListCellRenderer newValue) {
        ListCellRenderer oldValue = this.cellRenderer;
        this.cellRenderer = newValue;
        this.firePropertyChange(CELL_RENDERER_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setModel(ListModel newValue) {
        ListModel oldValue = this.model;
        this.model = newValue;
        oldValue.removeListDataListener(this.dataListener);
        newValue.addListDataListener(this.dataListener);
        this.firePropertyChange("model", null, null);
    }

    public void setSelectedIndex(int index) {
        this.selectionModel.clearSelection();
        this.selectionModel.setSelectedIndex(index, true);
    }

    public void setSelectedIndex(int index, boolean selected) {
        this.selectionModel.setSelectedIndex(index, selected);
    }

    public void setSelectedIndices(int[] indices) {
        this.selectionModel.clearSelection();
        for (int i = 0; i < indices.length; ++i) {
            this.selectionModel.setSelectedIndex(indices[i], true);
        }
    }

    public void setSelectionMode(int newValue) {
        this.selectionModel.setSelectionMode(newValue);
    }

    public void setSelectionModel(ListSelectionModel newValue) {
        ListSelectionModel oldValue = this.selectionModel;
        this.selectionModel = newValue;
        oldValue.removeListSelectionListener(this.selectionListener);
        newValue.addListSelectionListener(this.selectionListener);
        this.firePropertyChange(SELECTION_MODEL_CHANGED_PROPERTY, null, null);
    }

    public void setToolTipText(String newValue) {
        String oldValue = this.toolTipText;
        this.toolTipText = newValue;
        this.firePropertyChange("toolTipText", oldValue, newValue);
    }

    public void setVisibleRowCount(int newValue) {
        int oldValue = this.visibleRowCount;
        this.visibleRowCount = newValue;
        this.firePropertyChange("visibleRowCount", oldValue, newValue);
    }

    public void setWidth(int newValue) {
        int oldValue = this.width;
        this.width = newValue;
        this.firePropertyChange("width", oldValue, newValue);
    }

    public void setWidthUnits(int newValue) {
        int oldValue = this.widthUnits;
        this.widthUnits = newValue;
        this.firePropertyChange("widthUnits", oldValue, newValue);
    }

    private class ListDataHandler
    implements ListDataListener,
    Serializable {
        private ListDataHandler() {
        }

        public void contentsChanged(ListDataEvent e) {
            ListBox.this.firePropertyChange(ListBox.LIST_DATA_CHANGED_PROPERTY, null, null);
        }

        public void intervalAdded(ListDataEvent e) {
            ListBox.this.firePropertyChange(ListBox.LIST_DATA_CHANGED_PROPERTY, null, null);
        }

        public void intervalRemoved(ListDataEvent e) {
            ListBox.this.firePropertyChange(ListBox.LIST_DATA_CHANGED_PROPERTY, null, null);
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener,
    Serializable {
        private ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ListBox.this.firePropertyChange(ListBox.LIST_SELECTION_CHANGED_PROPERTY, null, null);
        }
    }
}

