/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import nextapp.echo.Component;
import nextapp.echo.Insets;
import nextapp.echo.Style;

public class Panel
extends Component {
    public static final String STYLE_HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String STYLE_INSETS = "insets";
    public static final String STYLE_VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY = "horizontalAlignment";
    public static final String INSETS_CHANGED_PROPERTY = "insets";
    public static final String VERTICAL_ALIGNMENT_CHANGED_PROPERTY = "verticalAlignment";
    public static final Insets DEFAULT_INSETS = new Insets(0);
    private int horizontalAlignment = 2;
    private int verticalAlignment = 1;
    private Insets insets = DEFAULT_INSETS;

    public void applyStyle(Style style) {
        super.applyStyle(style);
        if (style.hasAttribute("horizontalAlignment")) {
            this.setHorizontalAlignment(style.getIntegerAttribute("horizontalAlignment"));
        }
        if (style.hasAttribute("insets")) {
            this.setInsets((Insets)style.getAttribute("insets"));
        }
        if (style.hasAttribute("verticalAlignment")) {
            this.setVerticalAlignment(style.getIntegerAttribute("verticalAlignment"));
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setHorizontalAlignment(int newValue) {
        int oldValue = this.horizontalAlignment;
        this.horizontalAlignment = newValue;
        this.firePropertyChange("horizontalAlignment", oldValue, newValue);
    }

    public void setInsets(Insets newValue) {
        Insets oldValue = this.insets;
        this.insets = newValue;
        this.firePropertyChange("insets", oldValue, newValue);
    }

    public void setVerticalAlignment(int newValue) {
        int oldValue = this.verticalAlignment;
        this.verticalAlignment = newValue;
        this.firePropertyChange("verticalAlignment", oldValue, newValue);
    }
}

