/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo.ImageReference;
import nextapp.echo.event.ImageUpdateListener;

public class ResourceImageReference
implements ImageReference,
Serializable {
    private static final int BUFFER_SIZE = 4096;
    private static final Map extContentType = new HashMap();
    private String contentType;
    private String resourceName;
    private int width;
    private int height;
    static /* synthetic */ Class class$nextapp$echo$ResourceImageReference;

    private static final String getContentType(String resourceName) {
        int extensionDelimiterPosition = resourceName.lastIndexOf(".");
        if (extensionDelimiterPosition == -1) {
            throw new IllegalArgumentException("Invalid file extension (resource has no extension: " + resourceName + ")");
        }
        String extension = resourceName.substring(extensionDelimiterPosition + 1).toLowerCase();
        String contentType = (String)extContentType.get(extension);
        if (contentType == null) {
            throw new IllegalArgumentException("Invalid file extension (no matching content type: " + resourceName + ")");
        }
        return contentType;
    }

    public ResourceImageReference(String resourceName) {
        this(resourceName, ResourceImageReference.getContentType(resourceName), -1, -1);
    }

    public ResourceImageReference(String resourceName, String contentType) {
        this(resourceName, contentType, -1, -1);
    }

    public ResourceImageReference(String resourceName, int width, int height) {
        this(resourceName, ResourceImageReference.getContentType(resourceName), width, height);
    }

    public ResourceImageReference(String resourceName, String contentType, int width, int height) {
        this.resourceName = resourceName;
        this.contentType = contentType;
        this.width = width;
        this.height = height;
    }

    public void addImageUpdateListener(ImageUpdateListener l) {
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void removeImageUpdateListener(ImageUpdateListener l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void render(OutputStream out) throws IOException {
        InputStream in = null;
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        try {
            in = (class$nextapp$echo$ResourceImageReference == null ? (class$nextapp$echo$ResourceImageReference = ResourceImageReference.class$("nextapp.echo.ResourceImageReference")) : class$nextapp$echo$ResourceImageReference).getResourceAsStream(this.resourceName);
            if (in == null) {
                throw new IllegalArgumentException("Specified resource does not exist: " + this.resourceName + ".");
            }
            do {
                if ((bytesRead = in.read(buffer)) <= 0) continue;
                out.write(buffer, 0, bytesRead);
            } while (bytesRead > 0);
            Object var6_5 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return;
        }
        catch (IOException ex) {}
    }

    public void update() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        extContentType.put("gif", "image/gif");
        extContentType.put("png", "image/png");
        extContentType.put("jpeg", "image/jpeg");
        extContentType.put("jpg", "image/jpg");
        extContentType.put("bmp", "image/bmp");
    }
}

