/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.io.Serializable;
import java.util.EventListener;
import nextapp.echo.Component;
import nextapp.echo.DefaultListCellRenderer;
import nextapp.echo.DefaultSelectFieldModel;
import nextapp.echo.ListCellRenderer;
import nextapp.echo.SelectFieldModel;
import nextapp.echo.Style;
import nextapp.echo.ToolTipSupport;
import nextapp.echo.event.ActionEvent;
import nextapp.echo.event.ActionListener;
import nextapp.echo.event.ItemEvent;
import nextapp.echo.event.ItemListener;
import nextapp.echo.event.ListDataEvent;
import nextapp.echo.event.ListDataListener;

public class SelectField
extends Component
implements ToolTipSupport {
    public static final int PIXEL_UNITS = 0;
    public static final int PERCENT_UNITS = 2;
    public static final String STYLE_WIDTH = "width";
    public static final String STYLE_WIDTH_UNITS = "widthUnits";
    public static final String CELL_RENDERER_CHANGED_PROPERTY = "cellRenderer";
    public static final String LIST_DATA_CHANGED_PROPERTY = "listData";
    public static final String WIDTH_CHANGED_PROPERTY = "width";
    public static final String WIDTH_UNITS_CHANGED_PROPERTY = "widthUnits";
    private ListDataListener dataListener = new ListDataHandler();
    private ListCellRenderer cellRenderer = DefaultListCellRenderer.DEFAULT_LIST_CELL_RENDERER;
    private SelectFieldModel model;
    private String actionCommand;
    private String toolTipText;
    private int width = -1;
    private int widthUnits = 0;
    static /* synthetic */ Class class$nextapp$echo$event$ActionListener;
    static /* synthetic */ Class class$nextapp$echo$event$ItemListener;

    public SelectField() {
        this(new DefaultSelectFieldModel());
    }

    public SelectField(Object[] items) {
        this(new DefaultSelectFieldModel(items));
    }

    public SelectField(SelectFieldModel model) {
        if (model == null) {
            throw new IllegalArgumentException("Null model is not allowed.");
        }
        this.model = model;
        if (model.getSelectedItem() == null && model.size() > 0) {
            model.setSelectedItem(model.get(0));
        }
        model.addListDataListener(this.dataListener);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.addListener(class$nextapp$echo$event$ActionListener == null ? (class$nextapp$echo$event$ActionListener = SelectField.class$("nextapp.echo.event.ActionListener")) : class$nextapp$echo$event$ActionListener, l);
    }

    public void addItemListener(ItemListener l) {
        this.listenerList.addListener(class$nextapp$echo$event$ItemListener == null ? (class$nextapp$echo$event$ItemListener = SelectField.class$("nextapp.echo.event.ItemListener")) : class$nextapp$echo$event$ItemListener, l);
    }

    public void applyStyle(Style style) {
        super.applyStyle(style);
        if (style.hasAttribute("width")) {
            this.setWidth(style.getIntegerAttribute("width"));
        }
        if (style.hasAttribute("widthUnits")) {
            this.setWidthUnits(style.getIntegerAttribute("widthUnits"));
        }
    }

    public void fireActionEvent() {
        EventListener[] listeners = this.listenerList.getListeners(class$nextapp$echo$event$ActionListener == null ? (class$nextapp$echo$event$ActionListener = SelectField.class$("nextapp.echo.event.ActionListener")) : class$nextapp$echo$event$ActionListener);
        ActionEvent e = null;
        for (int index = 0; index < listeners.length; ++index) {
            if (e == null) {
                e = new ActionEvent(this, this.actionCommand);
            }
            ((ActionListener)listeners[index]).actionPerformed(e);
        }
    }

    protected void fireItemStateChanged(ItemEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(class$nextapp$echo$event$ItemListener == null ? (class$nextapp$echo$event$ItemListener = SelectField.class$("nextapp.echo.event.ItemListener")) : class$nextapp$echo$event$ItemListener);
        for (int index = 0; index < listeners.length; ++index) {
            ((ItemListener)listeners[index]).itemStateChanged(e);
        }
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public ListCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public SelectFieldModel getModel() {
        return this.model;
    }

    public Object getSelectedItem() {
        return this.model.getSelectedItem();
    }

    public int getSelectedIndex() {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            return -1;
        }
        int size = this.model.size();
        for (int index = 0; index < size; ++index) {
            if (!this.model.get(index).equals(selectedItem)) continue;
            return index;
        }
        return -1;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public int getWidth() {
        return this.width;
    }

    public int getWidthUnits() {
        return this.widthUnits;
    }

    public boolean hasActionListeners() {
        return this.listenerList.getListenerCount(class$nextapp$echo$event$ActionListener == null ? (class$nextapp$echo$event$ActionListener = SelectField.class$("nextapp.echo.event.ActionListener")) : class$nextapp$echo$event$ActionListener) > 0;
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.removeListener(class$nextapp$echo$event$ActionListener == null ? (class$nextapp$echo$event$ActionListener = SelectField.class$("nextapp.echo.event.ActionListener")) : class$nextapp$echo$event$ActionListener, l);
    }

    public void removeItemListener(ItemListener l) {
        this.listenerList.removeListener(class$nextapp$echo$event$ItemListener == null ? (class$nextapp$echo$event$ItemListener = SelectField.class$("nextapp.echo.event.ItemListener")) : class$nextapp$echo$event$ItemListener, l);
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    public void setCellRenderer(ListCellRenderer newValue) {
        ListCellRenderer oldValue = this.cellRenderer;
        this.cellRenderer = newValue;
        this.firePropertyChange(CELL_RENDERER_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setModel(SelectFieldModel newValue) {
        SelectFieldModel oldValue = this.model;
        this.model = newValue;
        oldValue.removeListDataListener(this.dataListener);
        newValue.addListDataListener(this.dataListener);
        this.firePropertyChange("model", null, null);
    }

    public void setSelectedIndex(int index) {
        if (index >= this.model.size()) {
            throw new IllegalArgumentException("Specified index " + index + " is out of range.");
        }
        Object oldValue = this.model.getSelectedItem();
        this.fireItemStateChanged(new ItemEvent(this, oldValue, 2));
        this.model.setSelectedItem(this.model.get(index));
        Object newValue = this.model.get(index);
        this.fireItemStateChanged(new ItemEvent(this, newValue, 1));
    }

    public void setToolTipText(String newValue) {
        String oldValue = this.toolTipText;
        this.toolTipText = newValue;
        this.firePropertyChange("toolTipText", oldValue, newValue);
    }

    public void setWidth(int newValue) {
        int oldValue = this.width;
        this.width = newValue;
        this.firePropertyChange("width", oldValue, newValue);
    }

    public void setWidthUnits(int newValue) {
        int oldValue = this.widthUnits;
        this.widthUnits = newValue;
        this.firePropertyChange("widthUnits", oldValue, newValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ListDataHandler
    implements ListDataListener,
    Serializable {
        private ListDataHandler() {
        }

        public void contentsChanged(ListDataEvent e) {
            SelectField.this.firePropertyChange(SelectField.LIST_DATA_CHANGED_PROPERTY, null, null);
        }

        public void intervalAdded(ListDataEvent e) {
            SelectField.this.firePropertyChange(SelectField.LIST_DATA_CHANGED_PROPERTY, null, null);
        }

        public void intervalRemoved(ListDataEvent e) {
            SelectField.this.firePropertyChange(SelectField.LIST_DATA_CHANGED_PROPERTY, null, null);
        }
    }
}

