/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import nextapp.echo.AbstractButton;
import nextapp.echo.DefaultButtonModel;
import nextapp.echo.ImageReference;
import nextapp.echo.Style;
import nextapp.echo.event.ItemEvent;

public abstract class ToggleButton
extends AbstractButton {
    public static final String STYLE_HORIZONTAL_STATE_ALIGNMENT = "horizontalStateAlignment";
    public static final String STYLE_HORIZONTAL_STATE_POSITION = "horizontalStatePosition";
    public static final String STYLE_STATE_MARGIN = "stateMargin";
    public static final String STYLE_VERTICAL_STATE_ALIGNMENT = "verticalStateAlignment";
    public static final String STYLE_VERTICAL_STATE_POSITION = "verticalStatePosition";
    public static final String HORIZONTAL_STATE_ALIGNMENT_CHANGED_PROPERTY = "horizontalStateAlignment";
    public static final String HORIZONTAL_STATE_POSITION_CHANGED_PROPERTY = "horizontalStatePosition";
    public static final String STATE_MARGIN_CHANGED_PROPERTY = "stateMargin";
    public static final String VERTICAL_STATE_ALIGNMENT_CHANGED_PROPERTY = "verticalStateAlignment";
    public static final String VERTICAL_STATE_POSITION_CHANGED_PROPERTY = "verticalStatePosition";
    private int horizontalStateAlignment = 4;
    private int horizontalStatePosition = 2;
    private int verticalStateAlignment = 4;
    private int verticalStatePosition = 4;
    private int stateMargin = 3;

    public ToggleButton() {
        this(null, null, false);
    }

    public ToggleButton(String text) {
        this(text, null, false);
    }

    public ToggleButton(String text, boolean selected) {
        this(text, null, selected);
    }

    public ToggleButton(ImageReference icon) {
        this(null, icon, false);
    }

    public ToggleButton(ImageReference icon, boolean selected) {
        this(null, icon, selected);
    }

    public ToggleButton(String text, ImageReference icon, boolean selected) {
        this.setModel(new ToggleButtonModel());
        this.setIcon(icon);
        this.setText(text);
        this.setSelected(selected);
    }

    public void applyStyle(Style style) {
        super.applyStyle(style);
        if (style.hasAttribute("horizontalStateAlignment")) {
            this.setHorizontalStateAlignment(style.getIntegerAttribute("horizontalStateAlignment"));
        }
        if (style.hasAttribute("horizontalStatePosition")) {
            this.setHorizontalStatePosition(style.getIntegerAttribute("horizontalStatePosition"));
        }
        if (style.hasAttribute("stateMargin")) {
            this.setStateMargin(style.getIntegerAttribute("stateMargin"));
        }
        if (style.hasAttribute("verticalStateAlignment")) {
            this.setVerticalStateAlignment(style.getIntegerAttribute("verticalStateAlignment"));
        }
        if (style.hasAttribute("verticalStatePosition")) {
            this.setVerticalStatePosition(style.getIntegerAttribute("verticalStatePosition"));
        }
    }

    public int getHorizontalStateAlignment() {
        return this.horizontalStateAlignment;
    }

    public int getHorizontalStatePosition() {
        return this.horizontalStatePosition;
    }

    public int getStateMargin() {
        return this.stateMargin;
    }

    public int getVerticalStateAlignment() {
        return this.verticalStateAlignment;
    }

    public int getVerticalStatePosition() {
        return this.verticalStatePosition;
    }

    public void setHorizontalStateAlignment(int newValue) {
        int oldValue = this.horizontalStateAlignment;
        this.horizontalStateAlignment = newValue;
        this.firePropertyChange("horizontalStateAlignment", oldValue, newValue);
    }

    public void setHorizontalStatePosition(int newValue) {
        int oldValue = this.horizontalStatePosition;
        this.horizontalStatePosition = newValue;
        this.firePropertyChange("horizontalStatePosition", oldValue, newValue);
    }

    public void setStateMargin(int newValue) {
        int oldValue = this.stateMargin;
        this.stateMargin = newValue;
        this.firePropertyChange("stateMargin", oldValue, newValue);
    }

    public void setVerticalStateAlignment(int newValue) {
        int oldValue = this.verticalStateAlignment;
        this.verticalStateAlignment = newValue;
        this.firePropertyChange("verticalStateAlignment", oldValue, newValue);
    }

    public void setVerticalStatePosition(int newValue) {
        int oldValue = this.verticalStatePosition;
        this.verticalStatePosition = newValue;
        this.firePropertyChange("verticalStatePosition", oldValue, newValue);
    }

    public static class ToggleButtonModel
    extends DefaultButtonModel {
        private boolean selected = false;

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            if (this.getGroup() != null) {
                this.getGroup().setSelected(this, selected);
            }
            this.fireItemStateChanged(new ItemEvent(this, this, selected ? 1 : 2));
            this.fireStateChanged();
        }
    }
}

