/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nextapp.echo.table.AbstractTableModel;

public class DefaultTableModel
extends AbstractTableModel
implements Serializable {
    private List rows;
    private List columnNames;

    public DefaultTableModel() {
        this.columnNames = new ArrayList();
        this.rows = new ArrayList();
    }

    public DefaultTableModel(int columns, int rows) {
        this();
        this.setRowCount(rows);
        this.setColumnCount(columns);
    }

    public DefaultTableModel(Object[][] data, Object[] names) {
        if (data == null) {
            this.columnNames = new ArrayList();
            this.rows = new ArrayList();
        } else {
            int height = data.length;
            int width = 0;
            if (height > 0 && data[0] != null) {
                width = data[0].length;
            }
            this.columnNames = new ArrayList(width);
            for (int column = 0; column < width; ++column) {
                this.columnNames.add(names[column]);
            }
            this.rows = new ArrayList(height);
            for (int row = 0; row < height; ++row) {
                if (width == 0) continue;
                ArrayList<Object> rowList = new ArrayList<Object>(width);
                for (int column = 0; column < width; ++column) {
                    rowList.add(data[row][column]);
                }
                this.rows.add(rowList);
            }
        }
    }

    public void deleteRow(int row) {
        this.rows.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public String getColumnName(int column) {
        String name = column < this.columnNames.size() ? (String)this.columnNames.get(column) : "";
        return name;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValueAt(int column, int row) {
        void var3_4;
        if (row >= this.rows.size()) throw new ArrayIndexOutOfBoundsException("Table row " + row + " does not exist.");
        if (column >= this.columnNames.size()) throw new ArrayIndexOutOfBoundsException("Table column " + column + " does not exist.");
        List rowList = (List)this.rows.get(row);
        if (rowList == null) {
            return var3_4;
        }
        Object value = rowList.get(column);
        return var3_4;
    }

    public void insertRow(int row, Object[] rowData) {
        int maxIndex = rowData.length > this.columnNames.size() ? this.columnNames.size() : rowData.length;
        ArrayList<Object> rowList = new ArrayList<Object>(this.columnNames.size());
        for (int index = 0; index < maxIndex; ++index) {
            rowList.add(rowData[index]);
        }
        this.rows.add(row, rowList);
        this.fireTableRowsInserted(row, row);
    }

    public void setColumnCount(int newValue) {
        while (this.columnNames.size() > newValue) {
            this.columnNames.remove(this.columnNames.size() - 1);
        }
        while (this.columnNames.size() < newValue) {
            this.columnNames.add(null);
        }
    }

    public void setRowCount(int newValue) {
        while (this.rows.size() > newValue) {
            this.rows.remove(this.rows.size() - 1);
        }
        while (this.rows.size() < newValue) {
            this.rows.add(null);
        }
    }

    public void setValueAt(Object newValue, int column, int row) {
        if (this.rows.size() < row || this.columnNames.size() < column) {
            throw new ArrayIndexOutOfBoundsException("Table coordinate (" + column + ", " + row + ") does not exist");
        }
        ArrayList<Object> rowList = (ArrayList<Object>)this.rows.get(row);
        if (rowList == null && newValue != null) {
            rowList = new ArrayList<Object>(this.columnNames.size());
            this.rows.set(row, rowList);
        }
        while (rowList.size() <= column) {
            rowList.add(null);
        }
        rowList.set(column, newValue);
        this.fireTableCellUpdated(column, row);
    }
}

