/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.io.Serializable;
import java.util.EventListener;
import nextapp.echo.ButtonModel;
import nextapp.echo.Color;
import nextapp.echo.Component;
import nextapp.echo.DefaultButtonModel;
import nextapp.echo.Font;
import nextapp.echo.ImageReference;
import nextapp.echo.Style;
import nextapp.echo.ToolTipSupport;
import nextapp.echo.event.ActionEvent;
import nextapp.echo.event.ActionListener;
import nextapp.echo.event.ChangeEvent;
import nextapp.echo.event.ChangeListener;
import nextapp.echo.event.ItemEvent;
import nextapp.echo.event.ItemListener;

public abstract class AbstractButton
extends Component
implements ToolTipSupport {
    public static final String STYLE_HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String STYLE_HORIZONTAL_TEXT_POSITION = "horizontalTextPosition";
    public static final String STYLE_ICON_TEXT_MARGIN = "iconTextMargin";
    public static final String STYLE_ROLLOVER_BACKGROUND = "rolloverBackground";
    public static final String STYLE_ROLLOVER_ENABLED = "rolloverEnabled";
    public static final String STYLE_ROLLOVER_FONT = "rolloverFont";
    public static final String STYLE_ROLLOVER_FOREGROUND = "rolloverForeground";
    public static final String STYLE_VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String STYLE_VERTICAL_TEXT_POSITION = "verticalTextPosition";
    public static final String ACTION_COMMAND_CHANGED_PROPERTY = "actionCommand";
    public static final String HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY = "horizontalAlignment";
    public static final String HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY = "horizontalTextPosition";
    public static final String ICON_CHANGED_PROPERTY = "icon";
    public static final String ICON_TEXT_MARGIN_CHANGED_PROPERTY = "iconTextMargin";
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String ROLLOVER_BACKGROUND_CHANGED_PROPERTY = "rolloverBackground";
    public static final String ROLLOVER_ENABLED_CHANGED_PROPERTY = "rolloverEnabled";
    public static final String ROLLOVER_FONT_CHANGED_PROPERTY = "rolloverFont";
    public static final String ROLLOVER_FOREGROUND_CHANGED_PROPERTY = "rolloverForeground";
    public static final String ROLLOVER_ICON_CHANGED_PROPERTY = "rolloverIcon";
    public static final String ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY = "rolloverSelectedIcon";
    public static final String SELECTED_CHANGED_PROPERTY = "selected";
    public static final String SELECTED_ICON_CHANGED_PROPERTY = "selectedIcon";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final String VERTICAL_ALIGNMENT_CHANGED_PROPERTY = "verticalAlignment";
    public static final String VERTICAL_TEXT_POSITION_CHANGED_PROPERTY = "verticalTextPosition";
    private Color rolloverForeground = null;
    private Color rolloverBackground = null;
    private Font rolloverFont = null;
    private ImageReference icon = null;
    private ImageReference rolloverIcon = null;
    private ImageReference selectedIcon = null;
    private ImageReference rolloverSelectedIcon = null;
    private boolean rolloverEnabled = false;
    private String text = null;
    private ButtonModel model;
    private int iconTextMargin = 3;
    private int horizontalAlignment = 2;
    private int horizontalTextPosition = 8;
    private int verticalAlignment = 4;
    private int verticalTextPosition = 4;
    private String toolTipText = null;
    private EventForwarder eventForwarder = null;
    static /* synthetic */ Class class$nextapp$echo$event$ActionListener;
    static /* synthetic */ Class class$nextapp$echo$event$ChangeListener;
    static /* synthetic */ Class class$nextapp$echo$event$ItemListener;

    public void addActionListener(ActionListener l) {
        this.listenerList.addListener(class$nextapp$echo$event$ActionListener == null ? (class$nextapp$echo$event$ActionListener = AbstractButton.class$("nextapp.echo.event.ActionListener")) : class$nextapp$echo$event$ActionListener, l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.addListener(class$nextapp$echo$event$ChangeListener == null ? (class$nextapp$echo$event$ChangeListener = AbstractButton.class$("nextapp.echo.event.ChangeListener")) : class$nextapp$echo$event$ChangeListener, l);
    }

    public void addItemListener(ItemListener l) {
        this.listenerList.addListener(class$nextapp$echo$event$ItemListener == null ? (class$nextapp$echo$event$ItemListener = AbstractButton.class$("nextapp.echo.event.ItemListener")) : class$nextapp$echo$event$ItemListener, l);
    }

    public void applyStyle(Style style) {
        super.applyStyle(style);
        if (style.hasAttribute("horizontalAlignment")) {
            this.setHorizontalAlignment(style.getIntegerAttribute("horizontalAlignment"));
        }
        if (style.hasAttribute("horizontalTextPosition")) {
            this.setHorizontalTextPosition(style.getIntegerAttribute("horizontalTextPosition"));
        }
        if (style.hasAttribute("iconTextMargin")) {
            this.setIconTextMargin(style.getIntegerAttribute("iconTextMargin"));
        }
        if (style.hasAttribute("rolloverBackground")) {
            this.setRolloverBackground((Color)style.getAttribute("rolloverBackground"));
        }
        if (style.hasAttribute("rolloverEnabled")) {
            this.setRolloverEnabled(style.getBooleanAttribute("rolloverEnabled"));
        }
        if (style.hasAttribute("rolloverFont")) {
            this.setRolloverFont((Font)style.getAttribute("rolloverFont"));
        }
        if (style.hasAttribute("rolloverForeground")) {
            this.setRolloverForeground((Color)style.getAttribute("rolloverForeground"));
        }
        if (style.hasAttribute("verticalAlignment")) {
            this.setVerticalAlignment(style.getIntegerAttribute("verticalAlignment"));
        }
        if (style.hasAttribute("verticalTextPosition")) {
            this.setVerticalTextPosition(style.getIntegerAttribute("verticalTextPosition"));
        }
    }

    public void doAction() {
        this.model.doAction();
    }

    public void fireActionPerformed(ActionEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(class$nextapp$echo$event$ActionListener == null ? (class$nextapp$echo$event$ActionListener = AbstractButton.class$("nextapp.echo.event.ActionListener")) : class$nextapp$echo$event$ActionListener);
        for (int index = 0; index < listeners.length; ++index) {
            ((ActionListener)listeners[index]).actionPerformed(e);
        }
    }

    public void fireItemStateChanged(ItemEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(class$nextapp$echo$event$ItemListener == null ? (class$nextapp$echo$event$ItemListener = AbstractButton.class$("nextapp.echo.event.ItemListener")) : class$nextapp$echo$event$ItemListener);
        for (int index = 0; index < listeners.length; ++index) {
            ((ItemListener)listeners[index]).itemStateChanged(e);
        }
    }

    public void fireStateChanged() {
        EventListener[] listeners = this.listenerList.getListeners(class$nextapp$echo$event$ChangeListener == null ? (class$nextapp$echo$event$ChangeListener = AbstractButton.class$("nextapp.echo.event.ChangeListener")) : class$nextapp$echo$event$ChangeListener);
        ChangeEvent e = new ChangeEvent(this);
        for (int index = 0; index < listeners.length; ++index) {
            ((ChangeListener)listeners[index]).stateChanged(e);
        }
    }

    public String getActionCommand() {
        return this.model.getActionCommand();
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public ImageReference getIcon() {
        return this.icon;
    }

    public int getIconTextMargin() {
        return this.iconTextMargin;
    }

    public ButtonModel getModel() {
        return this.model;
    }

    public Color getRolloverBackground() {
        return this.rolloverBackground;
    }

    public Font getRolloverFont() {
        return this.rolloverFont;
    }

    public Color getRolloverForeground() {
        return this.rolloverForeground;
    }

    public ImageReference getRolloverIcon() {
        return this.rolloverIcon;
    }

    public ImageReference getRolloverSelectedIcon() {
        return this.rolloverSelectedIcon;
    }

    public ImageReference getSelectedIcon() {
        return this.selectedIcon;
    }

    public String getText() {
        return this.text;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public boolean hasActionListeners() {
        int listenerCount = this.listenerList.getListenerCount(class$nextapp$echo$event$ActionListener == null ? (class$nextapp$echo$event$ActionListener = AbstractButton.class$("nextapp.echo.event.ActionListener")) : class$nextapp$echo$event$ActionListener);
        if (listenerCount > 0) {
            return true;
        }
        if (this.model instanceof DefaultButtonModel) {
            return ((DefaultButtonModel)this.model).listenerList.getListenerCount(class$nextapp$echo$event$ActionListener == null ? (class$nextapp$echo$event$ActionListener = AbstractButton.class$("nextapp.echo.event.ActionListener")) : class$nextapp$echo$event$ActionListener) > 1;
        }
        return true;
    }

    public boolean isRolloverEnabled() {
        return this.rolloverEnabled;
    }

    public boolean isSelected() {
        return this.model.isSelected();
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.removeListener(class$nextapp$echo$event$ActionListener == null ? (class$nextapp$echo$event$ActionListener = AbstractButton.class$("nextapp.echo.event.ActionListener")) : class$nextapp$echo$event$ActionListener, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.removeListener(class$nextapp$echo$event$ChangeListener == null ? (class$nextapp$echo$event$ChangeListener = AbstractButton.class$("nextapp.echo.event.ChangeListener")) : class$nextapp$echo$event$ChangeListener, l);
    }

    public void removeItemListener(ItemListener l) {
        this.listenerList.removeListener(class$nextapp$echo$event$ItemListener == null ? (class$nextapp$echo$event$ItemListener = AbstractButton.class$("nextapp.echo.event.ItemListener")) : class$nextapp$echo$event$ItemListener, l);
    }

    public void setActionCommand(String newValue) {
        String oldValue = this.model.getActionCommand();
        this.model.setActionCommand(newValue);
        this.firePropertyChange(ACTION_COMMAND_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setHorizontalAlignment(int newValue) {
        int oldValue = this.horizontalAlignment;
        this.horizontalAlignment = newValue;
        this.firePropertyChange("horizontalAlignment", oldValue, newValue);
    }

    public void setHorizontalTextPosition(int newValue) {
        int oldValue = this.horizontalTextPosition;
        this.horizontalTextPosition = newValue;
        this.firePropertyChange("horizontalTextPosition", oldValue, newValue);
    }

    public void setIcon(ImageReference newValue) {
        ImageReference oldValue = this.icon;
        this.icon = newValue;
        this.firePropertyChange(ICON_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setIconTextMargin(int newValue) {
        int oldValue = this.iconTextMargin;
        this.iconTextMargin = newValue;
        this.firePropertyChange("iconTextMargin", oldValue, newValue);
    }

    public void setModel(ButtonModel newValue) {
        ButtonModel oldValue = this.model;
        this.model = newValue;
        if (oldValue != null) {
            oldValue.removeActionListener(this.eventForwarder);
            oldValue.removeChangeListener(this.eventForwarder);
            oldValue.removeItemListener(this.eventForwarder);
            this.eventForwarder = null;
        }
        if (newValue != null) {
            this.eventForwarder = new EventForwarder();
            newValue.addActionListener(this.eventForwarder);
            newValue.addChangeListener(this.eventForwarder);
            newValue.addItemListener(this.eventForwarder);
        }
        this.firePropertyChange(MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setRolloverBackground(Color newValue) {
        Color oldValue = this.rolloverBackground;
        this.rolloverBackground = newValue;
        this.firePropertyChange("rolloverBackground", oldValue, newValue);
    }

    public void setRolloverEnabled(boolean newValue) {
        boolean oldValue = this.rolloverEnabled;
        this.rolloverEnabled = newValue;
        this.firePropertyChange("rolloverEnabled", oldValue, newValue);
    }

    public void setRolloverFont(Font newValue) {
        Font oldValue = this.rolloverFont;
        this.rolloverFont = newValue;
        this.firePropertyChange("rolloverFont", oldValue, newValue);
    }

    public void setRolloverForeground(Color newValue) {
        Color oldValue = this.rolloverForeground;
        this.rolloverForeground = newValue;
        this.firePropertyChange("rolloverForeground", oldValue, newValue);
    }

    public void setRolloverIcon(ImageReference newValue) {
        ImageReference oldValue = this.rolloverIcon;
        this.rolloverIcon = newValue;
        this.firePropertyChange(ROLLOVER_ICON_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setRolloverSelectedIcon(ImageReference newValue) {
        ImageReference oldValue = this.rolloverSelectedIcon;
        this.rolloverSelectedIcon = newValue;
        this.firePropertyChange(ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setSelected(boolean newValue) {
        boolean oldValue = this.model.isSelected();
        this.model.setSelected(newValue);
        this.firePropertyChange(SELECTED_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setSelectedIcon(ImageReference newValue) {
        ImageReference oldValue = this.selectedIcon;
        this.selectedIcon = newValue;
        this.firePropertyChange(SELECTED_ICON_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setText(String newValue) {
        String oldValue = this.text;
        this.text = newValue;
        this.firePropertyChange(TEXT_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setToolTipText(String newValue) {
        String oldValue = this.toolTipText;
        this.toolTipText = newValue;
        this.firePropertyChange("toolTipText", oldValue, newValue);
    }

    public void setVerticalAlignment(int newValue) {
        int oldValue = this.verticalAlignment;
        this.verticalAlignment = newValue;
        this.firePropertyChange("verticalAlignment", oldValue, newValue);
    }

    public void setVerticalTextPosition(int newValue) {
        int oldValue = this.verticalTextPosition;
        this.verticalTextPosition = newValue;
        this.firePropertyChange("verticalTextPosition", oldValue, newValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EventForwarder
    implements ActionListener,
    ChangeListener,
    ItemListener,
    Serializable {
        private EventForwarder() {
        }

        public void actionPerformed(ActionEvent modelEvent) {
            ActionEvent buttonEvent = new ActionEvent(AbstractButton.this, modelEvent.getActionCommand());
            AbstractButton.this.fireActionPerformed(buttonEvent);
        }

        public void stateChanged(ChangeEvent modelEvent) {
            AbstractButton.this.fireStateChanged();
        }

        public void itemStateChanged(ItemEvent modelEvent) {
            ItemEvent buttonEvent = new ItemEvent(AbstractButton.this, modelEvent.getItem(), modelEvent.getStateChange());
            AbstractButton.this.fireItemStateChanged(buttonEvent);
        }
    }
}

