/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import nextapp.echo.AbstractButton;
import nextapp.echo.ButtonModel;

public class ButtonGroup
implements Serializable {
    private Set buttons = new HashSet();
    private ButtonModel selection = null;

    public void add(AbstractButton button) {
        if (!this.buttons.contains(button)) {
            if (button.isSelected() && this.selection != button.getModel()) {
                button.setSelected(false);
            }
            this.buttons.add(button);
            button.getModel().setGroup(this);
        }
    }

    public int getButtonCount() {
        return this.buttons.size();
    }

    public Iterator getElements() {
        return Collections.unmodifiableSet(this.buttons).iterator();
    }

    public ButtonModel getSelection() {
        return this.selection;
    }

    public boolean isSelected(ButtonModel buttonModel) {
        return buttonModel.isSelected();
    }

    public void remove(AbstractButton button) {
        if (this.buttons.contains(button)) {
            this.buttons.remove(button);
            button.getModel().setGroup(null);
        }
    }

    public void setSelected(ButtonModel buttonModel, boolean selected) {
        if (selected && this.selection != null && buttonModel != this.selection && this.selection.isSelected()) {
            this.selection.setSelected(false);
        }
        if (buttonModel.isSelected() != selected) {
            buttonModel.setSelected(selected);
        }
        if (selected) {
            this.selection = buttonModel;
        }
    }
}

