/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import nextapp.echo.Color;
import nextapp.echo.EchoInstance;
import nextapp.echo.Font;
import nextapp.echo.Style;
import nextapp.echo.event.EventListenerList;
import nextapp.echo.event.HierarchyEvent;
import nextapp.echo.event.HierarchyListener;

public abstract class Component
implements Serializable {
    private static final int CHILD_LIST_CAPACITY = 3;
    private static final Component[] EMPTY_COMPONENT_ARRAY = new Component[0];
    public static final String BACKGROUND_CHANGED_PROPERTY = "background";
    public static final String CHILDREN_CHANGED_PROPERTY = "children";
    public static final String ENABLED_CHANGED_PROPERTY = "enabled";
    public static final String FONT_CHANGED_PROPERTY = "font";
    public static final String FOREGROUND_CHANGED_PROPERTY = "foreground";
    public static final String IDENTIFIER_CHANGED_PROPERTY = "identifier";
    public static final String LOCALE_CHANGED_PROPERTY = "locale";
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String TAB_INDEX_CHANGED_PROPERTY = "tabIndex";
    public static final String UPDATE_PROPERTY = "update";
    public static final String VISIBLE_CHANGED_PROPERTY = "visible";
    private static final int FLAG_ENABLED = 1;
    private static final int FLAG_VISIBLE = 2;
    private static final int FLAG_REGISTERED = 4;
    private static final int FLAG_INITIALIZED = 8;
    private static final int FLAGS_TAB_INDEX = 0x7FFF0000;
    public static final String STYLE_BACKGROUND = "background";
    public static final String STYLE_FONT = "font";
    public static final String STYLE_FOREGROUND = "foreground";
    private PropertyChangeSupport propertyChangeSupport = null;
    private List children = null;
    private Component parent = null;
    private Color background = null;
    private Font font = null;
    private Color foreground = null;
    Locale locale = null;
    protected EventListenerList listenerList = new EventListenerList();
    private Object identifier = null;
    private int flags = 3;
    static /* synthetic */ Class class$nextapp$echo$event$HierarchyListener;

    public Component() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public void add(Component c) {
        this.add(c, -1);
    }

    public void add(Component c, int n) {
        if (c.parent != null) {
            c.parent.remove(c);
        }
        if (this.children == null) {
            this.children = new ArrayList(3);
        }
        c.parent = this;
        if (n == -1) {
            this.children.add(c);
        } else {
            this.children.add(n, c);
        }
        long changeFlags = 2L;
        if (this.isRegistered()) {
            c.setRegistered(true);
            changeFlags |= 4L;
            if (c.isRecursivelyVisible()) {
                changeFlags |= 1L;
            }
        }
        this.firePropertyChange(CHILDREN_CHANGED_PROPERTY, null, c);
        if (changeFlags != 0L) {
            c.processHierarchyEvent(changeFlags, c, c.parent);
        }
    }

    public void addHierarchyListener(HierarchyListener l) {
        this.listenerList.addListener(class$nextapp$echo$event$HierarchyListener == null ? (class$nextapp$echo$event$HierarchyListener = Component.class$("nextapp.echo.event.HierarchyListener")) : class$nextapp$echo$event$HierarchyListener, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void applyStyle(Style style) {
        if (style.hasAttribute("background")) {
            this.setBackground((Color)style.getAttribute("background"));
        }
        if (style.hasAttribute("font")) {
            this.setFont((Font)style.getAttribute("font"));
        }
        if (style.hasAttribute("foreground")) {
            this.setForeground((Color)style.getAttribute("foreground"));
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, new Float(oldValue), new Float(newValue));
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, new Long(oldValue), new Long(newValue));
    }

    public Color getBackground() {
        return this.background;
    }

    public Component getComponent(int n) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException();
        }
        return (Component)this.children.get(n);
    }

    public int getComponentCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public Component[] getComponents() {
        if (this.children == null) {
            return EMPTY_COMPONENT_ARRAY;
        }
        return this.children.toArray(new Component[this.children.size()]);
    }

    public EchoInstance getEchoInstance() {
        if (this.parent == null) {
            return EchoInstance.getEchoInstance();
        }
        return this.parent.getEchoInstance();
    }

    public Font getFont() {
        return this.font;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public Locale getLocale() {
        EchoInstance echoInstance;
        Object locale = this.locale == null ? (this.parent == null ? ((echoInstance = EchoInstance.getEchoInstance()) == null ? null : echoInstance.getLocale()) : this.parent.getLocale()) : this.locale;
        return locale;
    }

    public Component getParent() {
        return this.parent;
    }

    public int getTabIndex() {
        return (this.flags & 0x7FFF0000) >> 16;
    }

    public int indexOf(Component c) {
        if (this.children == null) {
            return -1;
        }
        return this.children.indexOf(c);
    }

    protected void init() {
    }

    public boolean isAncestorOf(Component c) {
        while (c != null && c != this) {
            c = c.parent;
        }
        return c == this;
    }

    public boolean isEnabled() {
        return (1 & this.flags) != 0;
    }

    public boolean isFocused() {
        EchoInstance instance = this.getEchoInstance();
        return instance != null && instance.getFocusedComponent() == this;
    }

    private boolean isRecursivelyVisible() {
        return this.isVisible() && (this.parent == null || this.parent.isRecursivelyVisible());
    }

    public final boolean isRegistered() {
        return (4 & this.flags) != 0;
    }

    public final boolean isShowing() {
        return this.isRegistered() && this.isRecursivelyVisible();
    }

    public final boolean isVisible() {
        return (2 & this.flags) != 0;
    }

    void processHierarchyEvent(long changeFlags, Component changed, Component changedParent) {
        EventListener[] listeners;
        Component[] children = this.getComponents();
        if (this.isRegistered() && (this.flags & 8) == 0) {
            this.flags |= 8;
            this.init();
        }
        if ((listeners = this.listenerList.getListeners(class$nextapp$echo$event$HierarchyListener == null ? (class$nextapp$echo$event$HierarchyListener = Component.class$("nextapp.echo.event.HierarchyListener")) : class$nextapp$echo$event$HierarchyListener)).length > 0) {
            HierarchyEvent e = new HierarchyEvent(this, changeFlags, changed, changedParent);
            for (int index = 0; index < listeners.length; ++index) {
                ((HierarchyListener)listeners[index]).hierarchyChanged(e);
            }
        }
        for (int index = 0; index < children.length; ++index) {
            children[index].processHierarchyEvent(changeFlags, changed, changedParent);
        }
    }

    public void remove(Component c) {
        if (this.children == null || !this.children.contains(c)) {
            return;
        }
        long changeFlags = 2L;
        if (this.isRegistered()) {
            c.setRegistered(false);
            changeFlags |= 4L;
            if (c.isRecursivelyVisible()) {
                changeFlags |= 1L;
            }
        }
        Component oldParent = c.parent;
        this.children.remove(c);
        c.parent = null;
        this.firePropertyChange(CHILDREN_CHANGED_PROPERTY, c, null);
        c.processHierarchyEvent(changeFlags, c, oldParent);
    }

    public void remove(int n) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException();
        }
        this.remove(this.getComponent(n));
    }

    public void removeAll() {
        if (this.children != null) {
            while (this.children.size() > 0) {
                Component c = (Component)this.children.get(this.children.size() - 1);
                this.remove(c);
            }
            this.children = null;
        }
    }

    public void removeHierarchyListener(HierarchyListener l) {
        this.listenerList.removeListener(class$nextapp$echo$event$HierarchyListener == null ? (class$nextapp$echo$event$HierarchyListener = Component.class$("nextapp.echo.event.HierarchyListener")) : class$nextapp$echo$event$HierarchyListener, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void setBackground(Color newValue) {
        Color oldValue = this.background;
        this.background = newValue;
        this.firePropertyChange("background", oldValue, newValue);
    }

    public void setEnabled(boolean newValue) {
        boolean oldValue;
        boolean bl = oldValue = (1 & this.flags) != 0;
        if (oldValue != newValue) {
            this.flags ^= 1;
        }
        this.firePropertyChange(ENABLED_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setFocused(boolean newValue) {
        EchoInstance instance = this.getEchoInstance();
        if (instance == null) {
            return;
        }
        instance.setFocusedComponent(this);
    }

    public void setFont(Font newValue) {
        Font oldValue = this.font;
        this.font = newValue;
        this.firePropertyChange("font", oldValue, newValue);
    }

    public void setForeground(Color newValue) {
        Color oldValue = this.foreground;
        this.foreground = newValue;
        this.firePropertyChange("foreground", oldValue, newValue);
    }

    public void setIdentifier(Object newValue) {
        Object oldValue = this.identifier;
        this.identifier = newValue;
        this.firePropertyChange(IDENTIFIER_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setLocale(Locale newValue) {
        Locale oldValue = this.locale;
        this.locale = newValue;
        this.firePropertyChange(LOCALE_CHANGED_PROPERTY, oldValue, newValue);
    }

    void setRegistered(boolean registered) {
        this.flags = registered ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
        if (this.children != null) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                ((Component)it.next()).setRegistered(registered);
            }
        }
    }

    public void setTabIndex(int newValue) {
        int oldValue = this.getTabIndex();
        this.flags = this.flags & 0x8000FFFF | (newValue &= Short.MAX_VALUE) << 16;
        this.firePropertyChange(TAB_INDEX_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setVisible(boolean newValue) {
        boolean oldValue;
        boolean bl = oldValue = (2 & this.flags) != 0;
        if (oldValue != newValue) {
            this.flags ^= 2;
            this.firePropertyChange(VISIBLE_CHANGED_PROPERTY, oldValue, newValue);
            if (this.isRegistered()) {
                this.processHierarchyEvent(1L, this, this.parent);
            }
        }
    }

    public void update() {
        this.firePropertyChange(null, null, null);
    }

    public void validate() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

