/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import nextapp.echo.Color;
import nextapp.echo.Component;
import nextapp.echo.Font;
import nextapp.echo.Window;

public abstract class EchoInstance
implements Serializable {
    private static final ThreadLocal activeInstance = new InheritableThreadLocal();
    public static final Color DEFAULT_BACKGROUND = Color.WHITE;
    public static final Font DEFAULT_FONT = new Font(Font.SANS_SERIF, 0, 10);
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final int DEFAULT_WINDOW_HEIGHT = 100;
    public static final int DEFAULT_WINDOW_WIDTH = 100;
    public static final String ID_STRING = "NextApp Echo v1.1.4";
    public static final String FOCUSED_COMPONENT_CHANGED_PROPERTY = "focusedComponent";
    public static final String LOCALE_CHANGED_PROPERTY = "locale";
    public static final String WINDOWS_CHANGED_PROPERTY = "windows";
    private Map attributes = null;
    private Set windows = new HashSet();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Locale locale = null;
    private WeakReference focusedComponent = null;

    public static final EchoInstance getEchoInstance() {
        return (EchoInstance)activeInstance.get();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void addWindow(Window w) {
        if (this.windows.contains(w)) {
            return;
        }
        w.setEchoInstance(this);
        if (w.getWidth() == Integer.MIN_VALUE) {
            w.setWidth(100);
        }
        if (w.getHeight() == Integer.MIN_VALUE) {
            w.setHeight(100);
        }
        this.windows.add(w);
        w.fireWindowOpened();
        this.propertyChangeSupport.firePropertyChange(WINDOWS_CHANGED_PROPERTY, null, w);
        w.notifyRegistrationChange(true);
    }

    public final void doExit() {
        while (!this.windows.isEmpty()) {
            this.removeWindow((Window)this.windows.iterator().next());
        }
        this.exit();
    }

    public final Window doInit() {
        Window firstWindow = this.init();
        this.windows.add(firstWindow);
        firstWindow.setEchoInstance(this);
        firstWindow.notifyRegistrationChange(true);
        this.doValidation();
        return firstWindow;
    }

    public final void doValidation() {
        Iterator it = this.windows.iterator();
        while (it.hasNext()) {
            this.doValidation((Window)it.next());
        }
    }

    private void doValidation(Component c) {
        c.validate();
        int size = c.getComponentCount();
        for (int index = 0; index < size; ++index) {
            this.doValidation(c.getComponent(index));
        }
    }

    public void exit() {
    }

    public Object getAttribute(String key) {
        Object attribute = this.attributes == null ? null : this.attributes.get(key);
        return attribute;
    }

    public Component getFocusedComponent() {
        if (this.focusedComponent == null) {
            return null;
        }
        return (Component)this.focusedComponent.get();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Window[] getWindows() {
        return this.windows.toArray(new Window[this.windows.size()]);
    }

    protected abstract Window init();

    public void markActive(boolean active) {
        if (active) {
            activeInstance.set(this);
        } else {
            activeInstance.set(null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void removeWindow(Window w) {
        if (!this.windows.contains(w)) {
            return;
        }
        w.setEchoInstance(null);
        this.windows.remove(w);
        w.fireWindowClosed();
        this.propertyChangeSupport.firePropertyChange(WINDOWS_CHANGED_PROPERTY, w, null);
        w.notifyRegistrationChange(false);
    }

    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(key, value);
    }

    public void setFocusedComponent(Component newValue) {
        Component oldValue = this.getFocusedComponent();
        this.focusedComponent = newValue == null ? null : new WeakReference<Component>(newValue);
        this.propertyChangeSupport.firePropertyChange(FOCUSED_COMPONENT_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setLocale(Locale newValue) {
        Locale oldValue = this.locale;
        this.locale = newValue;
        this.propertyChangeSupport.firePropertyChange(LOCALE_CHANGED_PROPERTY, oldValue, newValue);
    }
}

