/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.io.Serializable;

public class Extent
implements Comparable,
Serializable {
    public static final int PX = 1;
    public static final int PERCENT = 2;
    public static final int PT = 3;
    public static final int CM = 4;
    public static final int MM = 5;
    public static final int IN = 6;
    public static final int EM = 7;
    public static final int EX = 8;
    public static final int PC = 9;
    private int value;
    private int units;

    public static Extent add(Extent a, Extent b) {
        if (a.getUnits() == b.getUnits()) {
            return new Extent(a.getValue() + b.getValue(), a.getUnits());
        }
        if (a.isPrint() && b.isPrint()) {
            if (a.isEnglish() && b.isEnglish()) {
                return new Extent(a.toPoint() + b.toPoint(), 3);
            }
            return new Extent(a.toMm() + b.toMm(), 5);
        }
        return null;
    }

    public Extent(int value, int units) {
        this.value = value;
        this.units = units;
    }

    public int compareTo(Object o) {
        Extent that = (Extent)o;
        if (this.isPrint() && that.isPrint()) {
            return this.toPoint() - that.toPoint();
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Extent) {
            Extent that = (Extent)o;
            return this.value == that.value && this.units == that.units;
        }
        return false;
    }

    public int getValue() {
        return this.value;
    }

    public int getUnits() {
        return this.units;
    }

    public boolean isComparableTo(Extent that) {
        return this.units == that.units || this.isPrint() && that.isPrint();
    }

    public boolean isEnglish() {
        return this.units == 6 || this.units == 9 || this.units == 3;
    }

    public boolean isSI() {
        return this.units == 5 || this.units == 4;
    }

    public boolean isPercentage() {
        return this.units == 2;
    }

    public boolean isPrint() {
        return this.units == 6 || this.units == 9 || this.units == 3 || this.units == 5 || this.units == 4;
    }

    public int toMm() {
        switch (this.units) {
            case 5: {
                return this.value;
            }
            case 4: {
                return this.value * 10;
            }
            case 6: {
                return (int)((double)this.value * 25.4);
            }
            case 3: {
                return (int)((double)(this.value / 72) * 25.4);
            }
            case 9: {
                return (int)((double)(this.value / 6) * 25.4);
            }
        }
        throw new IllegalStateException("Cannot convert to mm.");
    }

    public int toPoint() {
        switch (this.units) {
            case 3: {
                return this.value;
            }
            case 9: {
                return this.value * 12;
            }
            case 6: {
                return this.value * 72;
            }
            case 5: {
                return (int)((double)this.value / 25.4 * 72.0);
            }
            case 4: {
                return (int)((double)this.value / 2.54 * 72.0);
            }
        }
        throw new IllegalStateException("Cannot convert to pt.");
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append(this.value);
        switch (this.units) {
            case 4: {
                out.append("cm");
                break;
            }
            case 7: {
                out.append("em");
                break;
            }
            case 8: {
                out.append("ex");
                break;
            }
            case 6: {
                out.append("in");
                break;
            }
            case 5: {
                out.append("mm");
                break;
            }
            case 9: {
                out.append("pc");
                break;
            }
            case 2: {
                out.append("%");
                break;
            }
            case 3: {
                out.append("pt");
                break;
            }
            case 1: {
                out.append("px");
            }
        }
        return out.toString();
    }
}

