/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.io.Serializable;
import java.util.Arrays;
import nextapp.echo.EchoInstance;
import nextapp.echo.Extent;

public class Font
implements Serializable {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int OVERLINE = 8;
    public static final int LINE_THROUGH = 16;
    public static final String[] ARIAL = new String[]{"Arial", "Helvetica", "Sans-Serif"};
    public static final String[] HELVETICA = new String[]{"Helvetica", "Sans-Serif"};
    public static final String[] MONOSPACE = new String[]{"Monospace"};
    public static final String[] SANS_SERIF = new String[]{"Sans-Serif"};
    public static final String[] SERIF = new String[]{"Serif"};
    public static final String[] TIMES = new String[]{"Times", "Serif"};
    public static final String[] TIMES_NEW_ROMAN = new String[]{"Times New Roman", "Times Roman", "Times", "Serif"};
    public static final String[] TIMES_ROMAN = new String[]{"Times Roman", "Times", "Serif"};
    public static final String[] VERDANA = new String[]{"Verdana", "Arial", "Helvetica", "Sans-Serif"};
    private String[] names;
    private Extent sizeExtent;
    private int style;

    public Font(String name, int style, int size) {
        this(new String[]{name}, style, size);
    }

    public Font(String[] names, int style, int size) {
        this(names, style, new Extent(size, 3));
    }

    public Font(String[] names, int style, Extent sizeExtent) {
        this.names = names == null || names.length == 0 || names[0] == null ? EchoInstance.DEFAULT_FONT.getNames() : names;
        this.style = style;
        this.sizeExtent = sizeExtent;
    }

    public boolean equals(Object o) {
        boolean equal;
        if (this == o) {
            equal = true;
        } else if (o instanceof Font) {
            Font that = (Font)o;
            boolean sizeEqual = this.sizeExtent == that.sizeExtent || this.sizeExtent != null && this.sizeExtent.equals(that.sizeExtent);
            equal = sizeEqual && that.style == this.style && Arrays.equals(this.names, that.names);
        } else {
            equal = false;
        }
        return equal;
    }

    public String[] getNames() {
        String[] namesCopy;
        if (this.names == null) {
            namesCopy = null;
        } else {
            namesCopy = new String[this.names.length];
            System.arraycopy(this.names, 0, namesCopy, 0, this.names.length);
        }
        return namesCopy;
    }

    public int getSize() {
        return this.sizeExtent.toPoint();
    }

    public Extent getSizeExtent() {
        return this.sizeExtent;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.names != null && this.names.length > 0) {
            hashCode += this.names[0].hashCode();
        }
        return hashCode ^= this.sizeExtent.getValue() + this.style * 256;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isLineThrough() {
        return (this.style & 0x10) != 0;
    }

    public boolean isOverline() {
        return (this.style & 8) != 0;
    }

    public boolean isUnderline() {
        return (this.style & 4) != 0;
    }

    public String toString() {
        StringBuffer out = new StringBuffer("Font: ");
        for (int index = 0; index < this.names.length; ++index) {
            out.append(this.names[index]);
            if (index >= this.names.length) continue;
            out.append(", ");
        }
        if (this.isBold()) {
            out.append(" Bold");
        }
        if (this.isItalic()) {
            out.append(" Italic");
        }
        if (this.isLineThrough()) {
            out.append(" LineThrough");
        }
        if (this.isOverline()) {
            out.append(" Overline");
        }
        if (this.isUnderline()) {
            out.append(" Underline");
        }
        out.append(" ");
        out.append(this.sizeExtent);
        return out.toString();
    }
}

