/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import nextapp.echo.Color;
import nextapp.echo.Component;
import nextapp.echo.Coordinate;
import nextapp.echo.Dimension;
import nextapp.echo.ImageReference;
import nextapp.echo.Insets;
import nextapp.echo.Style;
import nextapp.echo.util.DynamicIntegerArray;

public class Grid
extends Component {
    public static final int CELL_LAYOUT_ORIENTATION_HORIZONTAL = 0;
    public static final int CELL_LAYOUT_ORIENTATION_VERTICAL = 1;
    public static final int PIXEL_UNITS = 1;
    public static final int PERCENT_INDIVIDUAL_PIXEL_TOTAL_UNITS = 3;
    public static final int PERCENT_UNITS = 2;
    public static final String STYLE_BORDER_COLOR = "borderColor";
    public static final String STYLE_BORDER_SIZE = "borderSize";
    public static final String STYLE_CELL_MARGIN = "cellMargin";
    public static final String STYLE_COLUMN_WIDTHS = "columnWidths";
    public static final String STYLE_HEIGHT = "height";
    public static final String STYLE_HEIGHT_UNITS = "heightUnits";
    public static final String STYLE_ROW_HEIGHTS = "rowHeights";
    public static final String STYLE_WIDTH = "width";
    public static final String STYLE_WIDTH_UNITS = "widthUnits";
    public static final int UNKNOWN_SIZE = Integer.MIN_VALUE;
    public static final String BORDER_COLOR_CHANGED_PROPERTY = "borderColor";
    public static final String BORDER_SIZE_CHANGED_PROPERTY = "borderSize";
    public static final String CELL_MARGIN_CHANGED_PROPERTY = "cellMargin";
    public static final String CELL_LAYOUT_ORIENTATION_CHANGED_PROPERTY = "cellLayoutOrientation";
    public static final String COLUMN_DELETED_PROPERTY = "columnDeleted";
    public static final String COLUMN_INSERTED_PROPERTY = "columnInserted";
    public static final String COLUMN_WIDTH_CHANGED_PROPERTY = "columnWidth";
    public static final String COLUMNS_CHANGED_PROPERTY = "columns";
    public static final String HEIGHT_CHANGED_PROPERTY = "height";
    public static final String HEIGHT_UNITS_CHANGED_PROPERTY = "heightUnits";
    public static final String ROW_DELETED_PROPERTY = "rowDeleted";
    public static final String ROW_HEIGHT_CHANGED_PROPERTY = "rowHeight";
    public static final String ROW_INSERTED_PROPERTY = "rowInserted";
    public static final String ROWS_CHANGED_PROPERTY = "rows";
    public static final String WIDTH_CHANGED_PROPERTY = "width";
    public static final String WIDTH_UNITS_CHANGED_PROPERTY = "widthUnits";
    private SortedMap explicitPositionedCells = new TreeMap();
    private Map autoPositionedCellPositions;
    private Color borderColor = null;
    private int borderSize = 0;
    private int cellMargin = 0;
    private int columns = -1;
    private DynamicIntegerArray columnWidths = new DynamicIntegerArray(Integer.MIN_VALUE);
    private int height = Integer.MIN_VALUE;
    private int heightUnits = 1;
    private DynamicIntegerArray rowHeights = new DynamicIntegerArray(Integer.MIN_VALUE);
    private int rows = -1;
    private boolean valid = false;
    private int width = Integer.MIN_VALUE;
    private int widthUnits = 1;
    private int cellLayoutOrientation = 0;
    private Dimension size = null;

    public void add(Component c, int index) {
        if (!(c instanceof Cell)) {
            throw new IllegalArgumentException("Cannot add component to grid that is not a derivative of nextapp.echo.Grid$Cell.");
        }
        Cell cell = (Cell)c;
        this.removePositionData(cell);
        super.add(cell, -1);
        this.addPositionData(cell);
    }

    public void add(Coordinate position, Cell cell) {
        cell.setPosition(position);
        this.add(cell, -1);
    }

    public void add(int column, int row, Cell cell) {
        this.add(new Coordinate(column, row), cell);
    }

    public Cell add(int column, int row, Component component) {
        Cell cell = new Cell(component);
        this.add(column, row, cell);
        return cell;
    }

    private void addPositionData(Cell cell) {
        Cell oldCell;
        this.invalidate();
        if (cell.getPosition() != null && (oldCell = this.explicitPositionedCells.put(cell.getPosition(), cell)) != null && oldCell != cell) {
            this.remove(oldCell);
        }
    }

    public void applyStyle(Style style) {
        int index;
        super.applyStyle(style);
        if (style.hasAttribute("borderColor")) {
            this.setBorderColor((Color)style.getAttribute("borderColor"));
        }
        if (style.hasAttribute("borderSize")) {
            this.setBorderSize(style.getIntegerAttribute("borderSize"));
        }
        if (style.hasAttribute("cellMargin")) {
            this.setCellMargin(style.getIntegerAttribute("cellMargin"));
        }
        if (style.hasAttribute(STYLE_COLUMN_WIDTHS)) {
            int[] widths = (int[])style.getAttribute(STYLE_COLUMN_WIDTHS);
            for (index = 0; index < widths.length; ++index) {
                this.setColumnWidth(index, widths[index]);
            }
        }
        if (style.hasAttribute("height")) {
            this.setHeight(style.getIntegerAttribute("height"));
        }
        if (style.hasAttribute("heightUnits")) {
            this.setHeightUnits(style.getIntegerAttribute("heightUnits"));
        }
        if (style.hasAttribute(STYLE_ROW_HEIGHTS)) {
            int[] heights = (int[])style.getAttribute(STYLE_ROW_HEIGHTS);
            for (index = 0; index < heights.length; ++index) {
                this.setRowHeight(index, heights[index]);
            }
        }
        if (style.hasAttribute("width")) {
            this.setWidth(style.getIntegerAttribute("width"));
        }
        if (style.hasAttribute("widthUnits")) {
            this.setWidthUnits(style.getIntegerAttribute("widthUnits"));
        }
    }

    public void deleteColumn(int column) {
        Cell cell;
        ArrayList<Cell> removedCells = new ArrayList<Cell>();
        ArrayList<Cell> relocatedCells = new ArrayList<Cell>();
        Iterator<Object> it = this.explicitPositionedCells.values().iterator();
        while (it.hasNext()) {
            cell = (Cell)it.next();
            if (cell.getColumn() < column) {
                if (cell.getColumn() + cell.columnSpan - 1 < column) continue;
                cell.columnSpan--;
                continue;
            }
            if (cell.getColumn() == column) {
                if (cell.columnSpan > 1) {
                    cell.columnSpan--;
                    continue;
                }
                removedCells.add(cell);
                continue;
            }
            relocatedCells.add(cell);
        }
        it = removedCells.iterator();
        while (it.hasNext()) {
            this.remove((Cell)it.next());
        }
        it = relocatedCells.iterator();
        while (it.hasNext()) {
            this.remove((Cell)it.next());
        }
        it = relocatedCells.iterator();
        while (it.hasNext()) {
            cell = (Cell)it.next();
            int cellColumn = cell.position.getX();
            int cellRow = cell.position.getY();
            this.add(cellColumn - 1, cellRow, cell);
        }
        this.firePropertyChange(COLUMN_DELETED_PROPERTY, null, null);
    }

    public void deleteRow(int row) {
        Cell cell;
        ArrayList<Cell> removedCells = new ArrayList<Cell>();
        ArrayList<Cell> relocatedCells = new ArrayList<Cell>();
        Iterator<Object> it = this.explicitPositionedCells.values().iterator();
        while (it.hasNext()) {
            cell = (Cell)it.next();
            if (cell.getRow() < row) {
                if (cell.getRow() + cell.rowSpan - 1 < row) continue;
                cell.rowSpan--;
                continue;
            }
            if (cell.getRow() == row) {
                if (cell.rowSpan > 1) {
                    cell.rowSpan--;
                    continue;
                }
                removedCells.add(cell);
                continue;
            }
            relocatedCells.add(cell);
        }
        it = removedCells.iterator();
        while (it.hasNext()) {
            this.remove((Cell)it.next());
        }
        it = relocatedCells.iterator();
        while (it.hasNext()) {
            this.remove((Cell)it.next());
        }
        it = relocatedCells.iterator();
        while (it.hasNext()) {
            cell = (Cell)it.next();
            int cellColumn = cell.position.getX();
            int cellRow = cell.position.getY();
            this.add(cellColumn, cellRow - 1, cell);
        }
        this.firePropertyChange(ROW_DELETED_PROPERTY, null, null);
    }

    public Cell get(Coordinate position) {
        return (Cell)this.explicitPositionedCells.get(position);
    }

    public Cell get(int column, int row) {
        return this.get(new Coordinate(column, row));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public int getCellLayoutOrientation() {
        return this.cellLayoutOrientation;
    }

    public int getCellMargin() {
        return this.cellMargin;
    }

    public Coordinate getCellPosition(Cell cell) {
        Coordinate position = cell.getPosition();
        if (position == null) {
            position = (Coordinate)this.autoPositionedCellPositions.get(cell);
        }
        return position;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getColumnWidth(int column) {
        return this.columnWidths.get(column);
    }

    public int getHeight() {
        return this.height;
    }

    public int getHeightUnits() {
        return this.heightUnits;
    }

    public int getRowHeight(int row) {
        return this.rowHeights.get(row);
    }

    public Dimension getSize() {
        this.validate();
        return this.size;
    }

    public int getRows() {
        return this.rows;
    }

    public int getWidth() {
        return this.width;
    }

    public int getWidthUnits() {
        return this.widthUnits;
    }

    public void insertColumn(int column) {
        Cell cell;
        ArrayList<Cell> relocatedCells = new ArrayList<Cell>();
        Iterator<Object> it = this.explicitPositionedCells.values().iterator();
        while (it.hasNext()) {
            cell = (Cell)it.next();
            if (cell.getColumn() < column) {
                if (cell.getColumn() + cell.columnSpan <= column) continue;
                cell.columnSpan++;
                continue;
            }
            relocatedCells.add(cell);
        }
        it = relocatedCells.iterator();
        while (it.hasNext()) {
            this.remove((Cell)it.next());
        }
        it = relocatedCells.iterator();
        while (it.hasNext()) {
            cell = (Cell)it.next();
            int cellColumn = cell.position.getX();
            int cellRow = cell.position.getY();
            this.add(cellColumn + 1, cellRow, cell);
        }
        this.firePropertyChange(ROW_DELETED_PROPERTY, null, null);
    }

    public void insertRow(int row) {
        Cell cell;
        ArrayList<Cell> relocatedCells = new ArrayList<Cell>();
        Iterator<Object> it = this.explicitPositionedCells.values().iterator();
        while (it.hasNext()) {
            cell = (Cell)it.next();
            if (cell.getRow() < row) {
                if (cell.getRow() + cell.rowSpan <= row) continue;
                cell.rowSpan++;
                continue;
            }
            relocatedCells.add(cell);
        }
        it = relocatedCells.iterator();
        while (it.hasNext()) {
            this.remove((Cell)it.next());
        }
        it = relocatedCells.iterator();
        while (it.hasNext()) {
            cell = (Cell)it.next();
            int cellColumn = cell.position.getX();
            int cellRow = cell.position.getY();
            this.add(cellColumn, cellRow + 1, cell);
        }
        this.firePropertyChange(ROW_DELETED_PROPERTY, null, null);
    }

    public void invalidate() {
        this.autoPositionedCellPositions = null;
        this.valid = false;
    }

    public Iterator iterator() {
        this.validate();
        TreeMap<Coordinate, Cell> cells = new TreeMap<Coordinate, Cell>(this.explicitPositionedCells);
        Iterator it = this.autoPositionedCellPositions.keySet().iterator();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            Coordinate coordinate = (Coordinate)this.autoPositionedCellPositions.get(cell);
            cells.put(coordinate, cell);
        }
        return cells.values().iterator();
    }

    public void remove(Component component) {
        Cell cell = (Cell)component;
        this.removePositionData(cell);
        super.remove(cell);
    }

    public Cell remove(Coordinate position) {
        Cell cell = this.get(position);
        if (cell != null) {
            this.remove(cell);
        }
        return cell;
    }

    public Cell remove(int column, int row) {
        return this.remove(new Coordinate(column, row));
    }

    private void removePositionData(Cell cell) {
        this.invalidate();
        if (cell.getPosition() != null) {
            this.explicitPositionedCells.remove(cell.getPosition());
        }
    }

    private void renderCells() {
        Component[] components = this.getComponents();
        this.autoPositionedCellPositions = new HashMap();
        RenderingWorkspace workspace = new RenderingWorkspace();
        Iterator it = this.explicitPositionedCells.values().iterator();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            Coordinate position = cell.getPosition();
            int x2 = position.getX() + cell.getColumnSpan() - 1;
            int y2 = position.getY() + cell.getRowSpan() - 1;
            if (!workspace.isRegionEmpty(position.getX(), position.getY(), x2, y2)) {
                throw new GridCellOverlapException("Grid region (" + position.getX() + ", " + position.getY() + ")-(" + x2 + "," + y2 + ") is occupied by multiple explicity positioned cells.");
            }
            workspace.markRegionFilled(position.getX(), position.getY(), x2, y2);
        }
        int cursorX = 0;
        int cursorY = 0;
        for (int index = 0; index < components.length; ++index) {
            int y2;
            int x2;
            boolean positioned;
            Cell cell = (Cell)components[index];
            if (cell.getPosition() != null) continue;
            if (this.getCellLayoutOrientation() == 1) {
                if (this.getRows() > 0 && cell.getRowSpan() > this.getRows()) {
                    throw new GridCellOverlapException("Cell row span larger than grid row size.");
                }
                positioned = false;
                while (!positioned) {
                    x2 = cursorX + cell.getColumnSpan() - 1;
                    y2 = cursorY + cell.getRowSpan() - 1;
                    if ((this.getRows() <= 0 || y2 < this.getRows()) && workspace.isRegionEmpty(cursorX, cursorY, x2, y2)) {
                        workspace.markRegionFilled(cursorX, cursorY, x2, y2);
                        this.autoPositionedCellPositions.put(cell, new Coordinate(cursorX, cursorY));
                        positioned = true;
                    }
                    if (this.getRows() <= 0 || cursorY < this.getRows() - 1) {
                        ++cursorY;
                        continue;
                    }
                    cursorY = 0;
                    ++cursorX;
                }
                continue;
            }
            if (this.getColumns() > 0 && cell.getColumnSpan() > this.getColumns()) {
                throw new GridCellOverlapException("Cell column span larger than grid column size.");
            }
            positioned = false;
            while (!positioned) {
                x2 = cursorX + cell.getColumnSpan() - 1;
                y2 = cursorY + cell.getRowSpan() - 1;
                if ((this.getColumns() <= 0 || x2 < this.getColumns()) && workspace.isRegionEmpty(cursorX, cursorY, x2, y2)) {
                    workspace.markRegionFilled(cursorX, cursorY, x2, y2);
                    this.autoPositionedCellPositions.put(cell, new Coordinate(cursorX, cursorY));
                    positioned = true;
                }
                if (this.getColumns() <= 0 || cursorX < this.getColumns() - 1) {
                    ++cursorX;
                    continue;
                }
                cursorX = 0;
                ++cursorY;
            }
        }
        this.size = new Dimension(workspace.getColumnCount(), workspace.getRowCount());
    }

    public void setBorderColor(Color newValue) {
        Color oldValue = this.borderColor;
        this.borderColor = newValue;
        this.firePropertyChange("borderColor", oldValue, newValue);
    }

    public void setBorderSize(int newValue) {
        int oldValue = this.borderSize;
        this.borderSize = newValue;
        this.firePropertyChange("borderSize", oldValue, newValue);
    }

    public void setCellLayoutOrientation(int newValue) {
        int oldValue = this.cellLayoutOrientation;
        this.cellLayoutOrientation = newValue;
        this.firePropertyChange(CELL_LAYOUT_ORIENTATION_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setCellMargin(int newValue) {
        this.invalidate();
        int oldValue = this.cellMargin;
        this.cellMargin = newValue;
        this.firePropertyChange("cellMargin", oldValue, newValue);
    }

    public void setColumns(int newValue) {
        int oldValue = this.columns;
        this.columns = newValue;
        this.firePropertyChange(COLUMNS_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setColumnWidth(int column, int newValue) {
        this.columnWidths.set(column, newValue);
        this.firePropertyChange(COLUMN_WIDTH_CHANGED_PROPERTY, null, null);
    }

    public void setHeight(int newValue) {
        int oldValue = this.height;
        this.height = newValue;
        this.firePropertyChange("height", oldValue, newValue);
    }

    public void setHeightUnits(int newValue) {
        int oldValue = this.heightUnits;
        this.heightUnits = newValue;
        this.firePropertyChange("heightUnits", oldValue, newValue);
    }

    public void setRowHeight(int row, int newValue) {
        this.rowHeights.set(row, newValue);
        this.firePropertyChange(ROW_HEIGHT_CHANGED_PROPERTY, null, null);
    }

    public void setRows(int newValue) {
        int oldValue = this.rows;
        this.rows = newValue;
        this.firePropertyChange(ROWS_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setWidth(int newValue) {
        int oldValue = this.width;
        this.width = newValue;
        this.firePropertyChange("width", oldValue, newValue);
    }

    public void setWidthUnits(int newValue) {
        int oldValue = this.widthUnits;
        this.widthUnits = newValue;
        this.firePropertyChange("widthUnits", oldValue, newValue);
    }

    public void validate() {
        if (this.valid) {
            return;
        }
        this.renderCells();
        this.valid = true;
    }

    public class GridCellOverlapException
    extends IllegalStateException {
        protected GridCellOverlapException(String cause) {
            super(cause);
        }
    }

    private static class RenderingWorkspace {
        private static final String FILLER = "filler";
        private List rows = new ArrayList();

        private RenderingWorkspace() {
        }

        public int getColumnCount() {
            int maxColumns = 0;
            Iterator it = this.rows.iterator();
            while (it.hasNext()) {
                List row = (List)it.next();
                if (row == null || row.size() <= maxColumns) continue;
                maxColumns = row.size();
            }
            return maxColumns;
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public boolean isRegionEmpty(int x1, int y1, int x2, int y2) {
            if (y2 >= this.getRowCount()) {
                y2 = this.getRowCount() - 1;
            }
            for (int y = y1; y <= y2; ++y) {
                List row = (List)this.rows.get(y);
                if (row == null) continue;
                int rowSize = row.size();
                for (int x = x1; x <= x2 && x < rowSize; ++x) {
                    if (row.get(x) == null) continue;
                    return false;
                }
            }
            return true;
        }

        public void markRegionFilled(int x1, int y1, int x2, int y2) {
            int ySize;
            int y;
            for (y = ySize = this.rows.size(); y <= y2; ++y) {
                this.rows.add(null);
            }
            for (y = y1; y <= y2; ++y) {
                int xSize;
                int x;
                ArrayList<String> row = (ArrayList<String>)this.rows.get(y);
                if (row == null) {
                    row = new ArrayList<String>();
                    this.rows.set(y, row);
                }
                for (x = xSize = row.size(); x <= x2; ++x) {
                    row.add(null);
                }
                for (x = x1; x <= x2; ++x) {
                    row.set(x, FILLER);
                }
            }
        }
    }

    public static class Cell
    extends Component {
        public static final int FLOW_DOWN = 2;
        public static final int FLOW_LEFT = 4;
        public static final int FLOW_RIGHT = 1;
        public static final int FLOW_UP = 8;
        public static final String STYLE_BACKGROUND_IMAGE = "backgroundImage";
        public static final String STYLE_HORIZONTAL_ALIGNMENT = "horizontalAlignment";
        public static final String STYLE_INSETS = "insets";
        public static final String STYLE_LINE_WRAP = "lineWrap";
        public static final String STYLE_VERTICAL_ALIGNMENT = "verticalAlignment";
        public static final String BACKGROUND_IMAGE_CHANGED_PROPERTY = "backgroundImage";
        public static final String FLOW_CHANGED_PROPERTY = "flowChanged";
        public static final String FLOW_PRIORITY_CHANGED_PROPERTY = "flowPriorityChanged";
        public static final String HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY = "horizontalAlignment";
        public static final String LINE_WRAP_CHANGED_PROPERTY = "lineWrap";
        public static final String INSETS_CHANGED_PROPERTY = "insets";
        public static final String POSITION_CHANGED_PROPERTY = "position";
        public static final String VERTICAL_ALIGNMENT_CHANGED_PROPERTY = "verticalAlignment";
        private ImageReference backgroundImage = null;
        private int columnSpan = 1;
        private int flow = 0;
        private int flowPriority = 0;
        private int horizontalAlignment = 2;
        private Insets insets = null;
        private Coordinate position = null;
        private int rowSpan = 1;
        private int verticalAlignment = 1;
        private boolean lineWrap = true;

        public Cell() {
            this(1, 1);
        }

        public Cell(Component c) {
            this(1, 1);
            this.add(c);
        }

        public Cell(int columnSpan, int rowSpan) {
            this.columnSpan = columnSpan;
            this.rowSpan = rowSpan;
        }

        public Cell(int columnSpan, int rowSpan, Component c) {
            this(columnSpan, rowSpan);
            this.add(c);
        }

        public void applyStyle(Style style) {
            super.applyStyle(style);
            if (style.hasAttribute("backgroundImage")) {
                this.setBackgroundImage((ImageReference)style.getAttribute("backgroundImage"));
            }
            if (style.hasAttribute("horizontalAlignment")) {
                this.setHorizontalAlignment(style.getIntegerAttribute("horizontalAlignment"));
            }
            if (style.hasAttribute("insets")) {
                this.setInsets((Insets)style.getAttribute("insets"));
            }
            if (style.hasAttribute("verticalAlignment")) {
                this.setVerticalAlignment(style.getIntegerAttribute("verticalAlignment"));
            }
        }

        public ImageReference getBackgroundImage() {
            return this.backgroundImage;
        }

        public final int getColumn() {
            if (this.position == null) {
                return -1;
            }
            return this.position.getX();
        }

        public final int getColumnSpan() {
            return this.columnSpan;
        }

        public int getFlow() {
            return this.flow;
        }

        public int getFlowPriority() {
            return this.flowPriority;
        }

        public int getHorizontalAlignment() {
            return this.horizontalAlignment;
        }

        public Insets getInsets() {
            return this.insets;
        }

        public boolean getLineWrap() {
            return this.lineWrap;
        }

        public Coordinate getPosition() {
            return this.position;
        }

        public final int getRow() {
            if (this.position == null) {
                return -1;
            }
            return this.position.getY();
        }

        public final int getRowSpan() {
            return this.rowSpan;
        }

        public int getVerticalAlignment() {
            return this.verticalAlignment;
        }

        public void setBackgroundImage(ImageReference newValue) {
            ImageReference oldValue = this.backgroundImage;
            this.backgroundImage = newValue;
            this.firePropertyChange("backgroundImage", oldValue, newValue);
        }

        public final void setColumnSpan(int newValue) {
            int oldValue = this.columnSpan;
            this.columnSpan = newValue;
            this.firePropertyChange("columnSpan", oldValue, newValue);
        }

        public void setFlow(int newValue) {
            int oldValue = this.flow;
            this.flow = newValue;
            this.firePropertyChange(FLOW_CHANGED_PROPERTY, oldValue, newValue);
        }

        public void setFlowPriority(int newValue) {
            int oldValue = this.flowPriority;
            this.flowPriority = newValue;
            this.firePropertyChange(FLOW_PRIORITY_CHANGED_PROPERTY, oldValue, newValue);
        }

        public void setHorizontalAlignment(int newValue) {
            int oldValue = this.horizontalAlignment;
            this.horizontalAlignment = newValue;
            this.firePropertyChange("horizontalAlignment", oldValue, newValue);
        }

        public void setInsets(Insets newValue) {
            Insets oldValue = this.insets;
            this.insets = newValue;
            this.firePropertyChange("insets", oldValue, newValue);
        }

        public void setLineWrap(boolean newValue) {
            boolean oldValue = this.lineWrap;
            this.lineWrap = newValue;
            this.firePropertyChange("lineWrap", oldValue, newValue);
        }

        public void setPosition(Coordinate newValue) {
            Grid parentGrid;
            Component parentComponent = this.getParent();
            Grid grid = parentGrid = parentComponent instanceof Grid ? (Grid)parentComponent : null;
            if (parentGrid != null) {
                parentGrid.removePositionData(this);
            }
            Coordinate oldValue = this.position;
            this.position = newValue;
            if (parentGrid != null) {
                parentGrid.addPositionData(this);
            }
            this.firePropertyChange(POSITION_CHANGED_PROPERTY, oldValue, newValue);
        }

        public final void setRowSpan(int newValue) {
            int oldValue = this.rowSpan;
            this.rowSpan = newValue;
            this.firePropertyChange("rowSpan", oldValue, newValue);
        }

        public void setVerticalAlignment(int newValue) {
            int oldValue = this.verticalAlignment;
            this.verticalAlignment = newValue;
            this.firePropertyChange("verticalAlignment", oldValue, newValue);
        }
    }
}

