/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import nextapp.echo.Component;
import nextapp.echo.ImageReference;
import nextapp.echo.Style;

public class Label
extends Component {
    public static final String STYLE_HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String STYLE_HORIZONTAL_TEXT_POSITION = "horizontalTextPosition";
    public static final String STYLE_ICON_TEXT_MARGIN = "iconTextMargin";
    public static final String STYLE_VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String STYLE_VERTICAL_TEXT_POSITION = "verticalTextPosition";
    public static final String HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY = "horizontalAlignment";
    public static final String HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY = "horizontalTextPosition";
    public static final String ICON_CHANGED_PROPERTY = "icon";
    public static final String ICON_TEXT_MARGIN_CHANGED_PROPERTY = "iconTextMargin";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final String VERTICAL_ALIGNMENT_CHANGED_PROPERTY = "verticalAlignment";
    public static final String VERTICAL_TEXT_POSITION_CHANGED_PROPERTY = "verticalTextPosition";
    private String text = null;
    private ImageReference icon = null;
    private int iconTextMargin = 3;
    private int horizontalAlignment = 2;
    private int horizontalTextPosition = 8;
    private int verticalAlignment = 4;
    private int verticalTextPosition = 4;

    public Label() {
        this(null, null);
    }

    public Label(String text) {
        this(text, null);
    }

    public Label(ImageReference icon) {
        this(null, icon);
    }

    public Label(String text, ImageReference icon) {
        this.setIcon(icon);
        this.setText(text);
    }

    public void applyStyle(Style style) {
        super.applyStyle(style);
        if (style.hasAttribute("horizontalAlignment")) {
            this.setHorizontalAlignment(style.getIntegerAttribute("horizontalAlignment"));
        }
        if (style.hasAttribute("horizontalTextPosition")) {
            this.setHorizontalTextPosition(style.getIntegerAttribute("horizontalTextPosition"));
        }
        if (style.hasAttribute("iconTextMargin")) {
            this.setIconTextMargin(style.getIntegerAttribute("iconTextMargin"));
        }
        if (style.hasAttribute("verticalAlignment")) {
            this.setVerticalAlignment(style.getIntegerAttribute("verticalAlignment"));
        }
        if (style.hasAttribute("verticalTextPosition")) {
            this.setVerticalTextPosition(style.getIntegerAttribute("verticalTextPosition"));
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public ImageReference getIcon() {
        return this.icon;
    }

    public int getIconTextMargin() {
        return this.iconTextMargin;
    }

    public String getText() {
        return this.text;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public void setHorizontalAlignment(int newValue) {
        int oldValue = this.horizontalAlignment;
        this.horizontalAlignment = newValue;
        this.firePropertyChange("horizontalAlignment", oldValue, newValue);
    }

    public void setHorizontalTextPosition(int newValue) {
        int oldValue = this.horizontalTextPosition;
        this.horizontalTextPosition = newValue;
        this.firePropertyChange("horizontalTextPosition", oldValue, newValue);
    }

    public void setIcon(ImageReference newValue) {
        ImageReference oldValue = this.icon;
        this.icon = newValue;
        this.firePropertyChange(ICON_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setIconTextMargin(int newValue) {
        int oldValue = this.iconTextMargin;
        this.iconTextMargin = newValue;
        this.firePropertyChange("iconTextMargin", oldValue, newValue);
    }

    public void setText(String newValue) {
        String oldValue = this.text;
        this.text = newValue;
        this.firePropertyChange(TEXT_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setVerticalAlignment(int newValue) {
        int oldValue = this.verticalAlignment;
        this.verticalAlignment = newValue;
        this.firePropertyChange("verticalAlignment", oldValue, newValue);
    }

    public void setVerticalTextPosition(int newValue) {
        int oldValue = this.verticalTextPosition;
        this.verticalTextPosition = newValue;
        this.firePropertyChange("verticalTextPosition", oldValue, newValue);
    }
}

