/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo.Color;
import nextapp.echo.Component;
import nextapp.echo.Container;
import nextapp.echo.Coordinate;
import nextapp.echo.Style;
import nextapp.echo.event.TableColumnModelEvent;
import nextapp.echo.event.TableColumnModelListener;
import nextapp.echo.event.TableModelEvent;
import nextapp.echo.event.TableModelListener;
import nextapp.echo.table.DefaultTableCellRenderer;
import nextapp.echo.table.DefaultTableColumnModel;
import nextapp.echo.table.DefaultTableModel;
import nextapp.echo.table.TableCellRenderer;
import nextapp.echo.table.TableColumn;
import nextapp.echo.table.TableColumnModel;
import nextapp.echo.table.TableHeader;
import nextapp.echo.table.TableModel;
import nextapp.echo.util.DynamicIntegerArray;

public class Table
extends Component {
    public static final int PIXEL_UNITS = 1;
    public static final int PERCENT_INDIVIDUAL_PIXEL_TOTAL_UNITS = 3;
    public static final int PERCENT_UNITS = 2;
    public static final String STYLE_BORDER_COLOR = "borderColor";
    public static final String STYLE_BORDER_SIZE = "borderSize";
    public static final String STYLE_CELL_MARGIN = "cellMargin";
    public static final String STYLE_COLUMN_WIDTHS = "columnWidths";
    public static final String STYLE_HEIGHT = "height";
    public static final String STYLE_HEIGHT_UNITS = "heightUnits";
    public static final String STYLE_ROW_HEIGHTS = "rowHeights";
    public static final String STYLE_WIDTH = "width";
    public static final String STYLE_WIDTH_UNITS = "widthUnits";
    public static final TableCellRenderer DEFAULT_TABLE_CELL_RENDERER = new DefaultTableCellRenderer();
    public static final String AUTO_CREATE_COLUMNS_FROM_MODEL_CHANGED_PROPERTY = "autoCreateColumnsFromModel";
    public static final String BORDER_COLOR_CHANGED_PROPERTY = "borderColor";
    public static final String BORDER_SIZE_CHANGED_PROPERTY = "borderSize";
    public static final String CELL_MARGIN_CHANGED_PROPERTY = "cellMargin";
    public static final String TABLE_HEADER_CHANGED_PROPERTY = "tableHeader";
    public static final String TABLE_COLUMN_MODEL_CHANGED_PROPERTY = "tableColumnModel";
    public static final String ROW_HEIGHT_CHANGED_PROPERTY = "rowHeight";
    public static final String HEIGHT_CHANGED_PROPERTY = "height";
    public static final String HEIGHT_UNITS_CHANGED_PROPERTY = "heightUnits";
    public static final String WIDTH_CHANGED_PROPERTY = "width";
    public static final String WIDTH_UNITS_CHANGED_PROPERTY = "widthUnits";
    private boolean autoCreateColumnsFromModel = false;
    private Color borderColor = Color.BLACK;
    private int borderSize = 1;
    private int cellMargin = 3;
    private TableHeader tableHeader = null;
    private Map componentPositionMap = new HashMap();
    private Map defaultRenderers = new HashMap(3);
    private TableModel model;
    private TableModelListener modelListener = new TableModelHandler();
    private TableColumnModel columnModel = new DefaultTableColumnModel();
    private TableColumnModelListener columnModelListener = new TableColumnModelHandler();
    private DynamicIntegerArray rowHeights = new DynamicIntegerArray(Integer.MIN_VALUE);
    private int width = Integer.MIN_VALUE;
    private int widthUnits = 1;
    private int height = Integer.MIN_VALUE;
    private int heightUnits = 1;
    private boolean valid;
    private Container renderedCells = new Container();
    private Container headerContainer;

    public Table() {
        this(new DefaultTableModel());
    }

    public Table(int columns, int rows) {
        this(new DefaultTableModel(columns, rows));
    }

    public Table(TableModel model) {
        this(model, null);
    }

    public Table(TableModel model, TableColumnModel columnModel) {
        this.add(this.renderedCells);
        this.headerContainer = new Container();
        this.add(this.headerContainer);
        if (columnModel == null) {
            this.setColumnModel(new DefaultTableColumnModel());
            this.setAutoCreateColumnsFromModel(true);
        } else {
            this.setColumnModel(columnModel);
        }
        this.setModel(model);
        this.setTableHeader(new TableHeader());
    }

    public void applyStyle(Style style) {
        int index;
        super.applyStyle(style);
        if (style.hasAttribute("borderColor")) {
            this.setBorderColor((Color)style.getAttribute("borderColor"));
        }
        if (style.hasAttribute("borderSize")) {
            this.setBorderSize(style.getIntegerAttribute("borderSize"));
        }
        if (style.hasAttribute("cellMargin")) {
            this.setCellMargin(style.getIntegerAttribute("cellMargin"));
        }
        if (style.hasAttribute(STYLE_COLUMN_WIDTHS)) {
            int[] widths = (int[])style.getAttribute(STYLE_COLUMN_WIDTHS);
            for (index = 0; index < widths.length; ++index) {
                this.getColumnModel().getColumn(index).setWidth(widths[index]);
            }
        }
        if (style.hasAttribute("height")) {
            this.setHeight(style.getIntegerAttribute("height"));
        }
        if (style.hasAttribute("heightUnits")) {
            this.setHeightUnits(style.getIntegerAttribute("heightUnits"));
        }
        if (style.hasAttribute(STYLE_ROW_HEIGHTS)) {
            int[] heights = (int[])style.getAttribute(STYLE_ROW_HEIGHTS);
            for (index = 0; index < heights.length; ++index) {
                this.setRowHeight(index, heights[index]);
            }
        }
        if (style.hasAttribute("width")) {
            this.setWidth(style.getIntegerAttribute("width"));
        }
        if (style.hasAttribute("widthUnits")) {
            this.setWidthUnits(style.getIntegerAttribute("widthUnits"));
        }
    }

    public void createDefaultColumnsFromModel() {
        if (this.model != null) {
            while (this.columnModel.getColumnCount() > 0) {
                this.columnModel.removeColumn(this.columnModel.getColumn(0));
            }
            int columnCount = this.model.getColumnCount();
            for (int index = 0; index < columnCount; ++index) {
                this.columnModel.addColumn(new TableColumn(index));
            }
        }
    }

    private void doLayout() {
        this.valid = true;
        this.renderedCells.removeAll();
        this.componentPositionMap.clear();
        this.doLayoutDataRows();
    }

    private void doLayoutDataRows() {
        int columns = this.getColumnCount();
        int rows = this.getRowCount();
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                Component cell;
                TableColumn tableColumn = this.columnModel.getColumn(column);
                Object value = this.model.getValueAt(tableColumn.getModelIndex(), row);
                TableCellRenderer renderer = null;
                if (tableColumn != null) {
                    renderer = tableColumn.getCellRenderer();
                }
                if (renderer == null) {
                    renderer = this.getDefaultRenderer(this.model.getColumnClass(tableColumn.getModelIndex()));
                }
                if ((cell = renderer.getTableCellRendererComponent(this, value, tableColumn.getModelIndex(), row)) == null) continue;
                this.renderedCells.add(cell);
                this.componentPositionMap.put(new Coordinate(column, row), cell);
            }
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public int getCellMargin() {
        return this.cellMargin;
    }

    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public Component getComponent(Coordinate coordinate) {
        return this.getRenderedComponent(coordinate);
    }

    public Component getRenderedComponent(Coordinate coordinate) {
        if (coordinate.getY() == -1) {
            if (this.tableHeader != null) {
                return this.tableHeader.getRenderedComponent(coordinate.getX());
            }
            return null;
        }
        return (Component)this.componentPositionMap.get(coordinate);
    }

    public TableCellRenderer getDefaultRenderer(Class columnClass) {
        TableCellRenderer renderer = null;
        while (renderer == null && columnClass != null) {
            renderer = (TableCellRenderer)this.defaultRenderers.get(columnClass);
            if (renderer != null) continue;
            columnClass = columnClass.getSuperclass();
        }
        if (renderer == null) {
            renderer = DEFAULT_TABLE_CELL_RENDERER;
        }
        return renderer;
    }

    public int getHeight() {
        return this.height;
    }

    public int getHeightUnits() {
        return this.heightUnits;
    }

    public TableModel getModel() {
        return this.model;
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public int getRowHeight(int row) {
        if (row == -1) {
            return this.tableHeader.getHeight();
        }
        return this.rowHeights.get(row);
    }

    public TableHeader getTableHeader() {
        return this.tableHeader;
    }

    public int getWidth() {
        return this.width;
    }

    public int getWidthUnits() {
        return this.widthUnits;
    }

    public void invalidate() {
        this.valid = false;
    }

    public boolean isAutoCreateColumnsFromModel() {
        return this.autoCreateColumnsFromModel;
    }

    public void setAutoCreateColumnsFromModel(boolean newValue) {
        boolean oldValue = this.autoCreateColumnsFromModel;
        this.autoCreateColumnsFromModel = newValue;
        if (!oldValue && newValue) {
            this.createDefaultColumnsFromModel();
        }
        this.firePropertyChange(AUTO_CREATE_COLUMNS_FROM_MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setBorderColor(Color newValue) {
        Color oldValue = this.borderColor;
        this.borderColor = newValue;
        this.firePropertyChange("borderColor", oldValue, newValue);
    }

    public void setBorderSize(int newValue) {
        int oldValue = this.borderSize;
        this.borderSize = newValue;
        this.firePropertyChange("borderSize", oldValue, newValue);
    }

    public void setCellMargin(int newValue) {
        int oldValue = this.cellMargin;
        this.cellMargin = newValue;
        this.firePropertyChange("cellMargin", oldValue, newValue);
    }

    public void setColumnModel(TableColumnModel newValue) {
        this.invalidate();
        if (this.columnModel == null) {
            throw new IllegalArgumentException("A non-null column model is required.");
        }
        TableColumnModel oldValue = this.columnModel;
        if (oldValue != null) {
            oldValue.removeColumnModelListener(this.columnModelListener);
        }
        this.columnModel = newValue;
        newValue.addColumnModelListener(this.columnModelListener);
        this.firePropertyChange(TABLE_COLUMN_MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setDefaultRenderer(Class columnClass, TableCellRenderer defaultRenderer) {
        this.invalidate();
        if (defaultRenderer == null) {
            this.defaultRenderers.remove(columnClass);
        } else {
            this.defaultRenderers.put(columnClass, defaultRenderer);
        }
    }

    public void setHeight(int newValue) {
        int oldValue = this.height;
        this.height = newValue;
        this.firePropertyChange("height", oldValue, newValue);
    }

    public void setHeightUnits(int newValue) {
        int oldValue = this.heightUnits;
        this.heightUnits = newValue;
        this.firePropertyChange("heightUnits", oldValue, newValue);
    }

    public void setModel(TableModel newValue) {
        this.invalidate();
        if (newValue == null) {
            throw new IllegalArgumentException("A non-null model is required.");
        }
        TableModel oldValue = this.model;
        if (oldValue != null) {
            oldValue.removeTableModelListener(this.modelListener);
        }
        newValue.addTableModelListener(this.modelListener);
        this.model = newValue;
        this.updateColumnModel();
        this.firePropertyChange("model", oldValue, newValue);
    }

    public void setRowHeight(int row, int newValue) {
        if (row == -1) {
            this.tableHeader.setHeight(newValue);
        } else {
            this.rowHeights.set(row, newValue);
            this.firePropertyChange(ROW_HEIGHT_CHANGED_PROPERTY, null, null);
        }
    }

    public void setTableHeader(TableHeader newValue) {
        this.invalidate();
        TableHeader oldValue = this.tableHeader;
        this.tableHeader = newValue;
        if (oldValue != null && oldValue.getTable() == this) {
            oldValue.setTable(null);
        }
        if (newValue != null && newValue.getTable() != this) {
            newValue.setTable(this);
        }
        this.headerContainer.removeAll();
        this.headerContainer.add(this.tableHeader);
        this.firePropertyChange(TABLE_HEADER_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setWidth(int newValue) {
        int oldValue = this.width;
        this.width = newValue;
        this.firePropertyChange("width", oldValue, newValue);
    }

    public void setWidthUnits(int newValue) {
        int oldValue = this.widthUnits;
        this.widthUnits = newValue;
        this.firePropertyChange("widthUnits", oldValue, newValue);
    }

    private void updateColumnModel() {
        if (this.isAutoCreateColumnsFromModel()) {
            this.createDefaultColumnsFromModel();
        }
    }

    public void validate() {
        while (!this.valid) {
            this.doLayout();
        }
    }

    private class TableColumnModelHandler
    implements Serializable,
    TableColumnModelListener {
        private TableColumnModelHandler() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            Table.this.invalidate();
        }

        public void columnMoved(TableColumnModelEvent e) {
            Table.this.invalidate();
        }

        public void columnRemoved(TableColumnModelEvent e) {
            Table.this.invalidate();
        }
    }

    private class TableModelHandler
    implements Serializable,
    TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent e) {
            Table.this.invalidate();
            if (e == null || e.getType() == 4) {
                Table.this.updateColumnModel();
            }
        }
    }
}

