/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import nextapp.echo.Style;
import nextapp.echo.text.Document;
import nextapp.echo.text.StringDocument;
import nextapp.echo.text.TextComponent;

public class TextArea
extends TextComponent {
    private static final int DEFAULT_COLUMNS = 20;
    private static final int DEFAULT_ROWS = 4;
    public static final String COLUMNS_CHANGED_PROPERTY = "columns";
    public static final String COLUMN_UNITS_CHANGED_PROPERTY = "columnUnits";
    public static final String LINE_WRAP_CHANGED_PROPERTY = "lineWrap";
    public static final String ROWS_CHANGED_PROPERTY = "rows";
    public static final String ROW_UNITS_CHANGED_PROPERTY = "rowUnits";
    private int columns = -1;
    private int rows = -1;
    private int columnUnits = 0;
    private int rowUnits = 0;
    private boolean lineWrap = true;

    public TextArea() {
        this(null, 20, 4);
    }

    public TextArea(String text) {
        this(text, 20, 4);
    }

    public TextArea(int columns, int rows) {
        this(null, columns, rows);
    }

    public TextArea(String text, int columns, int rows) {
        this(new StringDocument(), text, columns, rows);
    }

    public TextArea(Document document) {
        this(document, null, 20, 4);
    }

    public TextArea(Document document, String text, int columns, int rows) {
        this.setDocument(document);
        if (text != null) {
            this.setText(text);
        }
        this.setColumns(columns);
        this.setRows(rows);
    }

    public void applyStyle(Style style) {
        super.applyStyle(style);
        if (style.hasAttribute(COLUMNS_CHANGED_PROPERTY)) {
            this.setColumns(style.getIntegerAttribute(COLUMNS_CHANGED_PROPERTY));
        }
        if (style.hasAttribute(ROWS_CHANGED_PROPERTY)) {
            this.setRows(style.getIntegerAttribute(ROWS_CHANGED_PROPERTY));
        }
        if (style.hasAttribute(LINE_WRAP_CHANGED_PROPERTY)) {
            this.setLineWrap(style.getBooleanAttribute(LINE_WRAP_CHANGED_PROPERTY));
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public int getColumnUnits() {
        return this.columnUnits;
    }

    public boolean getLineWrap() {
        return this.lineWrap;
    }

    public int getRows() {
        return this.rows;
    }

    public int getRowUnits() {
        return this.rowUnits;
    }

    public void setColumns(int newValue) {
        int oldValue = this.columns;
        this.columns = newValue;
        this.firePropertyChange(COLUMNS_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setColumnUnits(int newValue) {
        int oldValue = this.columnUnits;
        this.columnUnits = newValue;
        this.firePropertyChange(COLUMN_UNITS_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setLineWrap(boolean newValue) {
        boolean oldValue = this.lineWrap;
        this.lineWrap = newValue;
        this.firePropertyChange(LINE_WRAP_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setRows(int newValue) {
        int oldValue = this.rows;
        this.rows = newValue;
        this.firePropertyChange(ROWS_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setRowUnits(int newValue) {
        int oldValue = this.rowUnits;
        this.rowUnits = newValue;
        this.firePropertyChange(ROW_UNITS_CHANGED_PROPERTY, oldValue, newValue);
    }
}

