/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo;

import java.util.EventListener;
import java.util.Locale;
import nextapp.echo.AbstractPane;
import nextapp.echo.Component;
import nextapp.echo.EchoInstance;
import nextapp.echo.Style;
import nextapp.echo.event.WindowEvent;
import nextapp.echo.event.WindowListener;

public class Window
extends Component {
    public static final String STYLE_DEFAULT_CLOSE_OPERATION = "defaultCloseOperation";
    public static final String STYLE_HEIGHT = "height";
    public static final String STYLE_WIDTH = "width";
    public static final int SIZE_UNKNOWN = Integer.MIN_VALUE;
    public static final int DO_NOTHING_ON_CLOSE = 1;
    public static final int HIDE_ON_CLOSE = 2;
    public static final int DISPOSE_ON_CLOSE = 3;
    public static final String HEIGHT_CHANGED_PROPERTY = "height";
    public static final String WIDTH_CHANGED_PROPERTY = "width";
    public static final String TITLE_CHANGED_PROPERTY = "title";
    public static final String Z_INDEX_CHANGED_PROPERTY = "zIndex";
    private String title = null;
    private int width = Integer.MIN_VALUE;
    private int height = Integer.MIN_VALUE;
    private EchoInstance echoInstance = null;
    private int defaultCloseOperation = 1;
    static /* synthetic */ Class class$nextapp$echo$event$WindowListener;

    public Window() {
    }

    public Window(String title) {
        this.title = title;
    }

    public void add(Component c, int index) {
        if (!(c instanceof AbstractPane)) {
            throw new IllegalArgumentException("Windows may only have AbstractPanes as children.");
        }
        if (this.getComponentCount() > 0) {
            throw new IllegalStateException("Windows may only have a single child component.");
        }
        super.add(c, index);
    }

    public void addWindowListener(WindowListener l) {
        this.listenerList.addListener(class$nextapp$echo$event$WindowListener == null ? (class$nextapp$echo$event$WindowListener = Window.class$("nextapp.echo.event.WindowListener")) : class$nextapp$echo$event$WindowListener, l);
    }

    public void applyStyle(Style style) {
        super.applyStyle(style);
        if (style.hasAttribute(STYLE_DEFAULT_CLOSE_OPERATION)) {
            this.setDefaultCloseOperation(style.getIntegerAttribute(STYLE_DEFAULT_CLOSE_OPERATION));
        }
        if (style.hasAttribute("height")) {
            this.setHeight(style.getIntegerAttribute("height"));
        }
        if (style.hasAttribute("width")) {
            this.setWidth(style.getIntegerAttribute("width"));
        }
    }

    public void dispose() {
        if (this.echoInstance != null) {
            this.echoInstance.removeWindow(this);
        }
    }

    void fireWindowClosed() {
        WindowEvent e = new WindowEvent(this);
        EventListener[] listeners = this.listenerList.getListeners(class$nextapp$echo$event$WindowListener == null ? (class$nextapp$echo$event$WindowListener = Window.class$("nextapp.echo.event.WindowListener")) : class$nextapp$echo$event$WindowListener);
        for (int index = 0; index < listeners.length; ++index) {
            ((WindowListener)listeners[index]).windowClosed(e);
        }
    }

    private void fireWindowClosing() {
        WindowEvent e = new WindowEvent(this);
        EventListener[] listeners = this.listenerList.getListeners(class$nextapp$echo$event$WindowListener == null ? (class$nextapp$echo$event$WindowListener = Window.class$("nextapp.echo.event.WindowListener")) : class$nextapp$echo$event$WindowListener);
        for (int index = 0; index < listeners.length; ++index) {
            ((WindowListener)listeners[index]).windowClosing(e);
        }
    }

    void fireWindowOpened() {
        WindowEvent e = new WindowEvent(this);
        EventListener[] listeners = this.listenerList.getListeners(class$nextapp$echo$event$WindowListener == null ? (class$nextapp$echo$event$WindowListener = Window.class$("nextapp.echo.event.WindowListener")) : class$nextapp$echo$event$WindowListener);
        for (int index = 0; index < listeners.length; ++index) {
            ((WindowListener)listeners[index]).windowOpened(e);
        }
    }

    public final AbstractPane getContent() {
        if (this.getComponentCount() > 0) {
            return (AbstractPane)this.getComponent(0);
        }
        return null;
    }

    public EchoInstance getEchoInstance() {
        if (this.echoInstance == null) {
            return EchoInstance.getEchoInstance();
        }
        return this.echoInstance;
    }

    public int getHeight() {
        return this.height;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            if (this.echoInstance == null) {
                EchoInstance activeEchoInstance = EchoInstance.getEchoInstance();
                if (activeEchoInstance == null) {
                    return null;
                }
                return activeEchoInstance.getLocale();
            }
            return this.echoInstance.getLocale();
        }
        return this.locale;
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public String getTitle() {
        return this.title;
    }

    public int getWidth() {
        return this.width;
    }

    void notifyRegistrationChange(boolean registered) {
        this.setRegistered(registered);
        long changeFlags = 4L;
        if (this.isVisible()) {
            changeFlags |= 1L;
        }
        this.processHierarchyEvent(changeFlags, this, null);
    }

    public void toBack() {
        this.firePropertyChange(Z_INDEX_CHANGED_PROPERTY, 0, -1);
    }

    public void toFront() {
        this.firePropertyChange(Z_INDEX_CHANGED_PROPERTY, 0, 1);
    }

    public void removeWindowListener(WindowListener l) {
        this.listenerList.removeListener(class$nextapp$echo$event$WindowListener == null ? (class$nextapp$echo$event$WindowListener = Window.class$("nextapp.echo.event.WindowListener")) : class$nextapp$echo$event$WindowListener, l);
    }

    public final void setContent(AbstractPane newValue) {
        this.removeAll();
        this.add(newValue);
    }

    public void setDefaultCloseOperation(int defaultCloseOperation) {
        this.defaultCloseOperation = defaultCloseOperation;
    }

    void setEchoInstance(EchoInstance echoInstance) {
        if (this.echoInstance != null && echoInstance != null) {
            throw new IllegalStateException("Window is already registered to an Echo instance.");
        }
        this.echoInstance = echoInstance;
    }

    public void setHeight(int newValue) {
        int oldValue = this.height;
        this.height = newValue;
        this.firePropertyChange("height", oldValue, newValue);
    }

    public void setTitle(String newValue) {
        String oldValue = this.title;
        this.title = newValue;
        this.firePropertyChange(TITLE_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setWidth(int newValue) {
        int oldValue = this.width;
        this.width = newValue;
        this.firePropertyChange("width", oldValue, newValue);
    }

    public void userClose() {
        this.fireWindowClosing();
        switch (this.getDefaultCloseOperation()) {
            case 2: {
                this.setVisible(false);
                break;
            }
            case 3: {
                this.dispose();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

