/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import nextapp.echo.event.EventListenerList;
import nextapp.echo.event.TableColumnModelEvent;
import nextapp.echo.event.TableColumnModelListener;
import nextapp.echo.table.TableColumn;
import nextapp.echo.table.TableColumnModel;

public class DefaultTableColumnModel
implements Serializable,
TableColumnModel {
    private List columns = new ArrayList();
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$nextapp$echo$event$TableColumnModelListener;

    public void addColumn(TableColumn column) {
        this.columns.add(column);
        this.fireColumnAdded(new TableColumnModelEvent(this, -1, this.columns.size() - 1));
    }

    public void addColumnModelListener(TableColumnModelListener l) {
        this.listenerList.addListener(class$nextapp$echo$event$TableColumnModelListener == null ? (class$nextapp$echo$event$TableColumnModelListener = DefaultTableColumnModel.class$("nextapp.echo.event.TableColumnModelListener")) : class$nextapp$echo$event$TableColumnModelListener, l);
    }

    protected void fireColumnAdded(TableColumnModelEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(class$nextapp$echo$event$TableColumnModelListener == null ? (class$nextapp$echo$event$TableColumnModelListener = DefaultTableColumnModel.class$("nextapp.echo.event.TableColumnModelListener")) : class$nextapp$echo$event$TableColumnModelListener);
        for (int index = 0; index < listeners.length; ++index) {
            ((TableColumnModelListener)listeners[index]).columnAdded(e);
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(class$nextapp$echo$event$TableColumnModelListener == null ? (class$nextapp$echo$event$TableColumnModelListener = DefaultTableColumnModel.class$("nextapp.echo.event.TableColumnModelListener")) : class$nextapp$echo$event$TableColumnModelListener);
        for (int index = 0; index < listeners.length; ++index) {
            ((TableColumnModelListener)listeners[index]).columnMoved(e);
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(class$nextapp$echo$event$TableColumnModelListener == null ? (class$nextapp$echo$event$TableColumnModelListener = DefaultTableColumnModel.class$("nextapp.echo.event.TableColumnModelListener")) : class$nextapp$echo$event$TableColumnModelListener);
        for (int index = 0; index < listeners.length; ++index) {
            ((TableColumnModelListener)listeners[index]).columnRemoved(e);
        }
    }

    public TableColumn getColumn(int index) {
        if (this.getColumnCount() - 1 < index) {
            return null;
        }
        return (TableColumn)this.columns.get(index);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getColumnIndex(Object identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Null not allowed as identifier value.");
        }
        Iterator it = this.columns.iterator();
        int index = 0;
        while (it.hasNext()) {
            TableColumn column = (TableColumn)it.next();
            if (identifier.equals(column.getIdentifier())) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException("No column found with specified identifier: " + identifier);
    }

    public Iterator getColumns() {
        return this.columns.iterator();
    }

    public void moveColumn(int columnIndex, int newIndex) {
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            throw new IllegalArgumentException("No column exists at index: " + columnIndex);
        }
        if (newIndex < 0 || newIndex >= this.columns.size()) {
            throw new IllegalArgumentException("Attempt to move column to invalid index: " + newIndex);
        }
        TableColumn column = (TableColumn)this.columns.remove(columnIndex);
        this.columns.add(newIndex, column);
        this.fireColumnMoved(new TableColumnModelEvent(this, columnIndex, newIndex));
    }

    public void removeColumn(TableColumn column) {
        int columnIndex = this.columns.indexOf(column);
        this.columns.remove(columnIndex);
        this.fireColumnAdded(new TableColumnModelEvent(this, columnIndex, -1));
    }

    public void removeColumnModelListener(TableColumnModelListener l) {
        this.listenerList.removeListener(class$nextapp$echo$event$TableColumnModelListener == null ? (class$nextapp$echo$event$TableColumnModelListener = DefaultTableColumnModel.class$("nextapp.echo.event.TableColumnModelListener")) : class$nextapp$echo$event$TableColumnModelListener, l);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

