/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nextapp.echo.Component;
import nextapp.echo.Container;
import nextapp.echo.Label;
import nextapp.echo.Table;
import nextapp.echo.event.TableColumnModelEvent;
import nextapp.echo.event.TableColumnModelListener;
import nextapp.echo.event.TableModelEvent;
import nextapp.echo.event.TableModelListener;
import nextapp.echo.table.TableCellRenderer;
import nextapp.echo.table.TableColumn;
import nextapp.echo.table.TableColumnModel;
import nextapp.echo.table.TableModel;

public class TableHeader
extends Component
implements Serializable {
    public static final String HEIGHT_CHANGED_PROPERTY = "height";
    private TableCellRenderer defaultRenderer = new DefaultHeaderRenderer();
    private TableColumnModelListener columnModelListener = new TableColumnModelHandler();
    private TableModelListener modelListener = new TableModelHandler();
    private Table table = null;
    private Container renderedCells;
    private List renderedCellsList = new ArrayList();
    private boolean valid = false;
    private int height;

    public TableHeader() {
        this.renderedCells = new Container();
        this.add(this.renderedCells);
    }

    private void doLayout() {
        this.valid = true;
        this.renderedCells.removeAll();
        this.renderedCellsList.clear();
        TableColumnModel columnModel = this.table.getColumnModel();
        TableModel model = this.table.getModel();
        int columns = columnModel.getColumnCount();
        for (int column = 0; column < columns; ++column) {
            TableCellRenderer renderer;
            TableColumn tableColumn = columnModel.getColumn(column);
            Object value = tableColumn.getHeaderValue();
            if (value == null) {
                value = model.getColumnName(column);
            }
            if ((renderer = tableColumn.getHeaderRenderer()) == null) {
                renderer = this.defaultRenderer;
            }
            Component cell = null;
            if (renderer != null && (cell = renderer.getTableCellRendererComponent(this.table, value, tableColumn.getModelIndex(), -1)) != null) {
                this.renderedCells.add(cell);
            }
            this.renderedCellsList.add(cell);
        }
    }

    public TableCellRenderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public int getHeight() {
        return this.height;
    }

    public Component getRenderedComponent(int column) {
        return (Component)this.renderedCellsList.get(column);
    }

    public Table getTable() {
        return this.table;
    }

    public void invalidate() {
        this.valid = false;
    }

    public void setDefaultRenderer(TableCellRenderer defaultRenderer) {
        this.defaultRenderer = defaultRenderer;
        this.invalidate();
    }

    public void setTable(Table newValue) {
        Table oldValue = this.table;
        this.table = newValue;
        if (oldValue != null) {
            oldValue.getColumnModel().removeColumnModelListener(this.columnModelListener);
            oldValue.getModel().removeTableModelListener(this.modelListener);
            if (oldValue.getTableHeader() == this) {
                oldValue.setTableHeader(null);
            }
        }
        if (newValue != null) {
            newValue.getColumnModel().addColumnModelListener(this.columnModelListener);
            newValue.getModel().addTableModelListener(this.modelListener);
            if (newValue.getTableHeader() != this) {
                newValue.setTableHeader(this);
            }
        }
        this.invalidate();
    }

    public void setHeight(int newValue) {
        int oldValue = this.height;
        this.height = newValue;
        this.firePropertyChange(HEIGHT_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void validate() {
        super.validate();
        while (!this.valid) {
            this.doLayout();
        }
    }

    private class TableModelHandler
    implements Serializable,
    TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent e) {
            TableHeader.this.invalidate();
        }
    }

    private class TableColumnModelHandler
    implements Serializable,
    TableColumnModelListener {
        private TableColumnModelHandler() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            TableHeader.this.invalidate();
        }

        public void columnMoved(TableColumnModelEvent e) {
            TableHeader.this.invalidate();
        }

        public void columnRemoved(TableColumnModelEvent e) {
            TableHeader.this.invalidate();
        }
    }

    public static class DefaultHeaderRenderer
    implements Serializable,
    TableCellRenderer {
        public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
            Label label = value == null ? null : new Label(value.toString());
            return label;
        }
    }
}

