/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.text;

import java.io.Serializable;
import nextapp.echo.Color;
import nextapp.echo.Component;
import nextapp.echo.Style;
import nextapp.echo.ToolTipSupport;
import nextapp.echo.event.DocumentEvent;
import nextapp.echo.event.DocumentListener;
import nextapp.echo.text.Document;

public abstract class TextComponent
extends Component
implements ToolTipSupport {
    public static final String STYLE_BORDER_COLOR = "borderColor";
    public static final String STYLE_BORDER_SIZE = "borderSize";
    public static final String STYLE_BORDER_STYLE = "borderStyle";
    public static final String STYLE_COLUMNS = "columns";
    public static final String STYLE_HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String STYLE_ROWS = "rows";
    public static final int CHARACTER_UNITS = 0;
    public static final int PIXEL_UNITS = 1;
    public static final int PERCENT_UNITS = 2;
    public static final String STYLE_LINE_WRAP = "lineWrap";
    public static final String BORDER_COLOR_CHANGED_PROPERTY = "borderColor";
    public static final String BORDER_SIZE_CHANGED_PROPERTY = "borderSize";
    public static final String BORDER_STYLE_CHANGED_PROPERTY = "borderStyle";
    public static final String DOCUMENT_CHANGED_PROPERTY = "document";
    public static final String EDITABLE_CHANGED_PROPERTY = "editable";
    public static final String HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY = "horizontalAlignment";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final int BORDER_DEFAULT = -1;
    public static final int BORDER_NONE = 0;
    public static final int BORDER_SOLID = 1;
    public static final int BORDER_INSET = 2;
    public static final int BORDER_OUTSET = 3;
    private Color borderColor = null;
    private int borderSize = -1;
    private int borderStyle = -1;
    private Document document = null;
    private DocumentListener documentHandler = new DocumentHandler();
    private boolean editable = true;
    private String toolTipText;
    private int horizontalAlignment = 2;

    public void applyStyle(Style style) {
        super.applyStyle(style);
        if (style.hasAttribute("borderColor")) {
            this.setBorderColor((Color)style.getAttribute("borderColor"));
        }
        if (style.hasAttribute("borderSize")) {
            this.setBorderSize(style.getIntegerAttribute("borderSize"));
        }
        if (style.hasAttribute("borderStyle")) {
            this.setBorderStyle(style.getIntegerAttribute("borderStyle"));
        }
        if (style.hasAttribute("horizontalAlignment")) {
            this.setHorizontalAlignment(style.getIntegerAttribute("horizontalAlignment"));
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public Document getDocument() {
        return this.document;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public String getText() {
        return this.document.getText();
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setBorderColor(Color newValue) {
        Color oldValue = this.borderColor;
        this.borderColor = newValue;
        this.firePropertyChange("borderColor", oldValue, newValue);
    }

    public void setBorderSize(int newValue) {
        int oldValue = this.borderSize;
        this.borderSize = newValue;
        this.firePropertyChange("borderSize", oldValue, newValue);
    }

    public void setBorderStyle(int newValue) {
        int oldValue = this.borderStyle;
        this.borderStyle = newValue;
        this.firePropertyChange("borderStyle", oldValue, newValue);
    }

    public void setDocument(Document newValue) {
        Document oldValue = this.document;
        if (oldValue != null) {
            oldValue.removeDocumentListener(this.documentHandler);
        }
        this.document = newValue;
        if (newValue != null) {
            newValue.addDocumentListener(this.documentHandler);
        }
        this.firePropertyChange(DOCUMENT_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setEditable(boolean newValue) {
        boolean oldValue = this.editable;
        this.editable = newValue;
        this.firePropertyChange(EDITABLE_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setHorizontalAlignment(int newValue) {
        int oldValue = this.horizontalAlignment;
        this.horizontalAlignment = newValue;
        this.firePropertyChange("horizontalAlignment", oldValue, newValue);
    }

    public void setText(String newValue) {
        String oldValue = this.document.getText();
        this.document.setText(newValue);
        this.firePropertyChange(TEXT_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setToolTipText(String newValue) {
        String oldValue = this.toolTipText;
        this.toolTipText = newValue;
        this.firePropertyChange("toolTipText", oldValue, newValue);
    }

    private class DocumentHandler
    implements DocumentListener,
    Serializable {
        private DocumentHandler() {
        }

        public void documentUpdate(DocumentEvent e) {
            TextComponent.this.update();
        }
    }
}

