/* 
 * This file is part of the Echo Web Application Framework (hereinafter "Echo").
 * Copyright (C) 2002-2004 NextApp, Inc.
 *
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 */

package nextapp.echoservlet.resource;

/**
 * A container of resource name constants.
 */
public interface ResourceNames {

    static final String RESOURCE_PATH = "/nextapp/echoservlet/resource/";
    static final String STATIC_RESOURCE_PATH = RESOURCE_PATH + "static/";
    static final String TEMPLATE_RESOURCE_PATH = RESOURCE_PATH + "template/";

    public static final String BLANK_PIXEL             = STATIC_RESOURCE_PATH   + "BlankPixel.gif";
    public static final String BLANK_DOCUMENT          = STATIC_RESOURCE_PATH   + "BlankDocument.html";
    public static final String CHECK_BOX_OFF           = STATIC_RESOURCE_PATH   + "CheckBoxOff.gif";
    public static final String CHECK_BOX_ON            = STATIC_RESOURCE_PATH   + "CheckBoxOn.gif";
    public static final String RADIO_BUTTON_OFF        = STATIC_RESOURCE_PATH   + "RadioButtonOff.gif";
    public static final String RADIO_BUTTON_ON         = STATIC_RESOURCE_PATH   + "RadioButtonOn.gif";
    public static final String COLLECTIONS_SCRIPT      = STATIC_RESOURCE_PATH   + "Collections.js";
    public static final String CONTENT_PANE_SCRIPT     = STATIC_RESOURCE_PATH   + "ContentPane.js";
    public static final String CLIENT_MODEL_SCRIPT     = STATIC_RESOURCE_PATH   + "ClientModel.js";
    public static final String CONTROLLER_SCRIPT       = STATIC_RESOURCE_PATH   + "Controller.js";
    public static final String WINDOW_SCRIPT           = STATIC_RESOURCE_PATH   + "Window.js";
    public static final String IMAGE_SWAP_SCRIPT       = STATIC_RESOURCE_PATH   + "ImageSwap.js";
    public static final String CSS_SWAP_SCRIPT         = STATIC_RESOURCE_PATH   + "CssSwap.js";
    public static final String ROLLOVER_SCRIPT         = STATIC_RESOURCE_PATH   + "Rollover.js";
    public static final String TOGGLE_BUTTON_SCRIPT    = STATIC_RESOURCE_PATH   + "ToggleButton.js";
    public static final String SELECT_FIELD_SCRIPT     = STATIC_RESOURCE_PATH   + "SelectField.js";
    public static final String INIT_FRAME_SCRIPT       = STATIC_RESOURCE_PATH   + "InitFrame.js";
    public static final String LIST_BOX_SCRIPT         = STATIC_RESOURCE_PATH   + "ListBox.js";
    public static final String TEXT_FIELD_SCRIPT       = STATIC_RESOURCE_PATH   + "TextField.js";
    public static final String BUTTON_SCRIPT           = STATIC_RESOURCE_PATH   + "Button.js";

    public static final String SAFE_INVOKE_DEFAULT_SCRIPT           = STATIC_RESOURCE_PATH + "SafeInvoke_Default.js";
    public static final String SAFE_INVOKE_EXCEPTION_SUPPORT_SCRIPT = STATIC_RESOURCE_PATH + "SafeInvoke_ExceptionSupport.js";
    
    public static final String CLIENT_ERROR_SCRIPT     = TEMPLATE_RESOURCE_PATH + "ClientError.js";
    public static final String CLIENT_DETECT           = TEMPLATE_RESOURCE_PATH + "ClientDetect.html";
    public static final String STARTUP_CONTAINER       = TEMPLATE_RESOURCE_PATH + "StartupContainer.html";
    public static final String SESSION_EXPIRED         = TEMPLATE_RESOURCE_PATH + "SessionExpired.html";

    public static final String CONTROLLER_DEBUG_SCRIPT = STATIC_RESOURCE_PATH + "ControllerDebug.js";
}
