/* 
 * This file is part of the Echo Web Application Framework (hereinafter "Echo").
 * Copyright (C) 2002-2004 NextApp, Inc.
 *
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 */

/**
 * Raises and lowers windows.
 * This method takes a variable number of arguments, which must be even.
 * Each pair of arguments represents a window id and the direction in which
 * the window's z-index should be adjusted.  Positive values will raise the
 * window to the front and negative ones will lower it.
 */
function E_adjustWindowZIndices() {
    var E_clientModel = parent.E_getClientModel();
    var E_argIndex = 0;
    var E_window;
    while (E_argIndex < arguments.length) {
        E_window = E_clientModel.E_getWindow(arguments[E_argIndex++]);
        if (arguments[E_argIndex++] > 0) {
            E_window.focus();
        } else {
            E_window.blur();
        }
    }
}

/**
 * Changes the content of one or more frames.
 *
 * This method takes a variable number of arguments.
 * Arguments are divided into groups.
 * The first argument of a group specifies the number of frame Ids in the group.
 * The second argument specifies the new URI the frame should contain.
 * The third argument specifies the window id.
 * The remaining arguments are the frame names, a path leading to the desired frame
 * to refresh.    
 */
function E_changeFrameContent() {
    var E_childIndex;
    var E_childCount;
    var E_objName;
    var E_frame;
    var E_uri;
    var E_argIndex = 0;
    
    while (E_argIndex < arguments.length) {
        E_childCount = parseInt(arguments[E_argIndex++]);
        E_uri = arguments[E_argIndex++];
        E_objName = "parent.E_getClientModel().E_getWindow(\'" + arguments[E_argIndex++] + "\').frames[0]";

        for (E_childIndex = 0; E_childIndex < E_childCount; ++E_childIndex, ++E_argIndex) {
            E_objName += ".frames[\'E_C_" + arguments[E_argIndex] + "\']";
        }
        
        E_frame = eval(E_objName);
        E_frame.location.replace(E_incrementCacheId(E_uri));
    }
}

/**
 * Closes a window.
 */
function E_closeWindow(E_id) {
    var E_clientModel = parent.E_getClientModel();
    var E_window = E_clientModel.E_getWindow(E_id);
    
    if (E_window != null) {
        // Only attempt to close window if it exists in client model.
        
        if (E_window.E_isRootWindow()) {
            // Case where the root window is closing itself.  A new root window
            // must be appointed if other windows exist.
            E_window.E_closePending = true;
        } else {
            E_clientModel.E_removeWindow(E_id);
            E_window.E_close();
        }
    }
}

/**
 * Retrieves the value of a parameter from the form.
 */
function E_getParameter(E_id) {
    var E_element = eval("document.forms.E_controllerForm.E_in_" + E_id);
    return E_element.value;
}

/**
 * Increments the cache id parameter of a url, forcing the browser to recognize it as a new document.
 * This is necessary because some browsers (Mozilla 0.9.7) refuse to otherwise reload the document.
 */
function E_incrementCacheId(E_location) {
    var E_uri = "" + E_location;
    if (E_uri.charAt(0) == "/") {
        // Only modify local URIs.
        
        var E_cacheIdStartIndex = E_uri.indexOf("&E_z=");

        if (E_cacheIdStartIndex == -1) {
            E_cacheIdStartIndex = E_uri.indexOf("?E_z=");
        }

        var E_cacheId;
        var E_cacheIdEndIndex;

        if (E_cacheIdStartIndex != -1) {
            E_cacheIdStartIndex += 5;
            E_cacheIdEndIndex = E_uri.indexOf("&", E_cacheIdStartIndex + 1);
            
            // Skip VM instance specific cache identifier
            var E_underscorePos = E_uri.indexOf("_", E_cacheIdStartIndex);
            if (E_underscorePos != -1 && (E_cacheIdEndIndex == -1 || E_underscorePos < E_cacheIdEndIndex)) {
                E_cacheIdStartIndex = E_underscorePos + 1;
            }

            if (E_cacheIdEndIndex == -1) {
                E_cacheId = parseInt(E_uri.substring(E_cacheIdStartIndex)) + 1;
                E_uri = E_uri.substring(0, E_cacheIdStartIndex) + E_cacheId;
            } else {
                E_cacheId = parseInt(E_uri.substring(E_cacheIdStartIndex, E_cacheIdEndIndex)) + 1;
                E_uri = E_uri.substring(0, E_cacheIdStartIndex) + E_cacheId + E_uri.substring(E_cacheIdEndIndex);
            }
        } else {
            E_cacheId = 0;
            if (E_uri.indexOf("?") == -1) {
                E_uri += "?E_z=0";
            } else {
                E_uri += "&E_z=0";
            }
        }
    }

    return E_uri;
}

/**
 * Increments the "sequence number" controller frame hidden field.  The
 * sequence number will be evaluated on the server to be certain that this
 * controller frame submission has not been previously made.
 */
function E_incrementSequenceNumber() {
    document.forms.E_controllerForm.E_sequenceNumber.value = 
            parseInt(document.forms.E_controllerForm.E_sequenceNumber.value) + 1;
}

/**
 * Notifies the server that the state of the client is valid.
 */
function E_notifyServerStateValid() {
    // Increment sequence number.
    E_incrementSequenceNumber();
                
    document.forms.E_controllerForm.E_requestType.value = "v";
    document.forms.E_controllerForm.submit();
}

/**
 * Notifies the server that the user has clicked a close button on one or more windows.
 */
function E_notifyServerWindowsClosed(E_closedWindows) {
    // Increment sequence number.
    E_incrementSequenceNumber();
                
    document.forms.E_controllerForm.E_requestType.value = "c";
    document.forms.E_controllerForm.E_requestData.value = E_closedWindows;
    document.forms.E_controllerForm.submit();
}

/**
 * Notifies the server that one or more windows that are supposed to be open are not.
 */
function E_notifyServerWindowsMissing(E_missingWindows) {
    // Increment sequence number.
    E_incrementSequenceNumber();
                
    document.forms.E_controllerForm.E_requestType.value = "m";
    document.forms.E_controllerForm.E_requestData.value = E_missingWindows;
    document.forms.E_controllerForm.submit();
}

/**
 * Opens a window.
 *
 * Most of the parameters in E_options are useful only for debugging.  Passing in zero
 * is the normal behavior.
 * The window.opener property of the new window will be set to the root window.
 */
function E_openWindow(E_id, E_uri, E_width, E_height, E_options) {
    var E_optionString = "width=" + E_width +",height=" + E_height;
    
    E_optionString += ",resizable="   + ((E_options & 0x0001) ? "no" : "yes");
    E_optionString += ",toolbar="     + ((E_options & 0x0002) ? "yes" : "no");
    E_optionString += ",menubar="     + ((E_options & 0x0004) ? "yes" : "no");
    E_optionString += ",location=" + ((E_options & 0x0008) ? "yes" : "no");
    E_optionString += ",status="   + ((E_options & 0x0010) ? "yes" : "no");

    if (E_newWindows == null) {
        E_newWindows = new E_List();
    }
    E_newWindows.E_add(E_id);
    var E_newWindow = parent.open(E_uri, "E_C_" + E_id, E_optionString);
    E_newWindow.opener = parent; // Fixes issue with Opera not setting parent correctly.
}

/**
 * Reloads the content of one or more frames.
 *
 * This method takes a variable number of arguments.
 * Arguments are divided into groups.
 * The first argument of a group specifies the number of frame Ids in the group.
 * The second argument specifies the window id.
 * The remaining arguments are the frame Ids, a path leading to the desired frame
 *   to refresh.    
 *
 * For example, if this method were invoked like this:
 *  E_refreshFrames(2, '1a', '22', '24', 3, '7f', '9a', '1c1', '1df');
 * The first groups arguments are: 2, '1a', '22', '24'
 * The second groups arguments are: 3, '7f', '9a', '1c1', '1df'
 * The first group of arguments is an instruction to refresh a frame in window 1a,
 *  which will cause this statement to be executed:
 *   parent.E_getClientModel().E_getWindow('1a').frame.E_C_1a.frames.E_C_24.location.reload();
 *  and the second group will execute:
 *   parent.E_getClientModel().E_getWindow('7f').frame.E_C_9a.frames.E_C_1c1.frames.E_C_1df.location.reload();
 */
function E_refreshFrames() {
    var E_childIndex;
    var E_childCount;
    var E_objName;
    var E_frame;
    var E_argIndex = 0;
    
    while (E_argIndex < arguments.length) {
        E_childCount = parseInt(arguments[E_argIndex++]);
        E_objName = "parent.E_getClientModel().E_getWindow(\'" + arguments[E_argIndex++] + "\')";

        for (E_childIndex = 0; E_childIndex < E_childCount; ++E_childIndex, ++E_argIndex) {
            E_objName += ".frames.E_C_" + arguments[E_argIndex];
        }
        E_frame = eval(E_objName);
        E_frame.location = E_incrementCacheId(E_frame.location);
    }
}

/**
 * Sends a request to the server, submtiting the form data.
 * Scrollbar positions are stored prior to sending the request.
 */
function E_sendRequest() {
    E_storeScrollbarPositions();
    document.forms.E_controllerForm.submit();
}

/**
 * Sets the action command and submits all data to server.
 */
function E_setAction(E_id, E_command) {

    // Only set action if no pending action is set.
    if (E_ready && E_pendingAction == null) {
        // lock script to prevent other actions from being sent.
        E_pendingAction = E_id;
        
        // Increment sequence number.
        E_incrementSequenceNumber();
                
        // Set request type to "action"
        document.forms.E_controllerForm.E_requestType.value = "a";
        
        // Set action Id and command.
        document.forms.E_controllerForm.E_requestData.value = E_id + "," + E_command ;
        
        // Send request.
        E_sendRequest();
    } else {
        E_alertNotReady();
    }
}

/**
 * Sets the value of a parameter in the form.
 */
function E_setParameter(E_id, E_value) {
    if (E_ready) {
        var E_element = eval("document.forms.E_controllerForm.E_in_" + E_id);
        if (E_element) {
            E_element.value = "x" + E_value;
        }
    }
}

/**
 * Sets window titles on windows that have had their titles changed.
 */
function E_setWindowTitles() {
    var E_argIndex = 0;
    var E_id;
    var E_title;
    
    while (E_argIndex < arguments.length) {
        E_id = arguments[E_argIndex++];
        E_title = arguments[E_argIndex++];
        
        parent.E_getClientModel().E_getWindow(E_id).document.title = E_title;
    }
}

/**
 * Stores the positions of ALL frames' scrollbars in the controller form.
 */
function E_storeScrollbarPositions() {
    var E_clientModel = parent.E_getClientModel();
    var E_windowIds = E_clientModel.E_getWindowIds();
    var E_windowCount = E_windowIds.E_size();
    var E_index;
    var E_window;

    for (E_index = 0; E_index < E_windowCount; ++E_index) {
        E_window = E_clientModel.E_getWindow(E_windowIds.E_get(E_index));
        E_try(null, "E_storeWindowScrollbarPositions", E_window);
    }
}

/** 
 * Stores the positions of a frame's scrollbars in the controller form.
 * Each position is stored as a coordinate in the form "X,Y".
 */
function E_storeWindowScrollbarPositions(E_window) {
    var E_index;

    if (E_window.frames.length == 0) {
        var E_x = 0;
        var E_y = 0;
        
        if (E_window.pageXOffset) {
            E_x = E_window.pageXOffset;
        } else if (E_window.document.body && E_window.document.body.scrollLeft) {
            E_x = E_window.document.body.scrollLeft;
        }
        
        if (E_window.pageYOffset) {
            E_y = E_window.pageYOffset;
        } else if (E_window.document.body && E_window.document.body.scrollTop) {
            E_y = E_window.document.body.scrollTop;
        }
        
        var E_position = eval("document.forms.E_controllerForm.E_psp_" + E_window.name.substring(4)); // "E_C_".length = 4
        
        if (E_position) {
            E_position.value = E_x + "," + E_y;
        }
    } else {
        for (E_index = 0; E_index < E_window.frames.length; ++E_index) {
            if (E_window.frames[E_index].name != "E_cf") {
                E_storeWindowScrollbarPositions(E_window.frames[E_index]);
            }
        }
    }
}

/**
 * A do-nothing submit action on the controller frame.  
 * Used when waiting to see if a window has closed or just reloaded.
 */
function E_synchronize() {
    // Increment sequence number.
    E_incrementSequenceNumber();
                
    document.forms.E_controllerForm.E_requestType.value = "s";
    document.forms.E_controllerForm.submit();
}

/**
 * Verifies the client browser appears as the server intends it.
 *
 * The first test is to make sure that all the windows the server believes
 * are open are in fact open.  If any discrepancies are found, a "missing
 * windows event" is immediately sent to the server, and further tests are not 
 * performed.  If the first test passes, the second test is run.  The second 
 * test analyzes each window registered with the client model to make certain it
 * has a proper "window" object associated with its Id and that the window
 * is not closed.  If this test fails, a "closed windows event" is sent to the
 * server immediately.
 *
 * This method excepts a variable number of arguments.  The first argument is a
 * boolean flag that when true requests that the controller send a "state 
 * valid" request back to the server immediately.  Each argument thereafter is 
 * the a Window Id.
 */
function E_verifyClientState() {
    var E_clientModel = parent.E_getClientModel();
    var E_serverInteractionRequired = arguments[0];

    // "Trouble Windows" is a comma-delimited string of window ids that 
    // are in an incorrect state.
    var E_troubleWindows = null;
    
    if (E_clientModel == null) {
        alert("ERROR: Client model not available.");
    } else {
        if (parent.E_closePending) {
            // The root window is to be closed: a new root window must be assigned.
            E_clientModel.E_changeRootWindow();
            if (E_clientModel.E_getRootWindow() == null) {
                // No new root window could be found as the window being closed is the ONLY window: just close the window.
                parent.E_closeFinalWindow();
            }
        } else {
            E_clientModel.E_verify(true);

            var E_argIndex;
            var E_windowIds = E_clientModel.E_getWindowIds();

            // Determine if any windows that the server believes should be open are
            // missing on the client.  Add any such windows to the "Trouble Windows"
            // string.
            for (E_argIndex = 1; E_argIndex < arguments.length; ++E_argIndex) {
                if (!E_windowIds.E_contains(arguments[E_argIndex]) 
                        && !(E_newWindows != null && E_newWindows.E_contains(arguments[E_argIndex]))) {
                    // The server believes a window exists that does not exist on the client.
                    if (E_troubleWindows == null) {
                        E_troubleWindows = arguments[E_argIndex];
                    } else {
                        E_troubleWindows += "," + arguments[E_argIndex];
                    }
                }
            }

            if (E_troubleWindows != null) {
                // The server believes one or more windows should be open on the
                // client that are not.  The server is notified with a "missing 
                // windows event."
                E_notifyServerWindowsMissing(E_troubleWindows);
            } else {
                // Determine if any windows that are registered with the ClientModel
                // have been closed or simply "no longer exist".  If any such 
                // windows are found, they will be added to the "Trouble Windows"
                // string and the server will be notified with a "closed windows 
                // event."
                var E_windowIdCount = E_windowIds.E_size();
                var E_index = 0;
                var E_window;
                var E_windowId;

                for (E_index = 0; E_index < E_windowIdCount; ++E_index) {
                    E_windowId = E_windowIds.E_get(E_index);
                    E_window = E_clientModel.E_getWindow(E_windowId);
                    if (E_window && E_window.closed) {
                        // A "lame window" has been found.  It is removed
                        // from the client model immediately.
                        E_clientModel.E_removeWindow(E_windowId);
                        if (E_troubleWindows == null) {
                            E_troubleWindows = E_windowId;
                        } else {
                            E_troubleWindows += "," + E_windowId;
                        }
                    }
                }

                if (E_troubleWindows != null) {
                    E_notifyServerWindowsClosed(E_troubleWindows);
                }
            }
        }
    }
    
    if (E_troubleWindows == null && E_serverInteractionRequired) {
        E_notifyServerStateValid();
    }
}

/**
 * Handles a window unload event, where a window is either being closed or
 * reloaded.
 */
function E_windowUnload() {
    E_incrementSequenceNumber();

    document.forms.E_controllerForm.E_requestType.value = "u";
    document.forms.E_controllerForm.submit();
}
