/* 
 * This file is part of the Echo Web Application Framework (hereinafter "Echo").
 * Copyright (C) 2002-2004 NextApp, Inc.
 *
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 */

/**
 * Called when a check box is clicked.
 *
 * E_id: The ID of the checkbox clicked
 * E_originalState: The state of the checkbox when the page was originally rendered.
 * E_notify: True if the server should be notified immediately of state changes (via control frame submit)
 * E_defaultImageUri: The URI of the state image displayed when the check box is not selected (unchecked).
 * E_selectedImageUri: The URI of the state image displayed when the check box is selected (checked).
 */
function E_checkBoxAction(E_id, E_originalState, E_notify, E_defaultImageUri, E_selectedImageUri) {
    // Get state and invert
    var E_state;
    var E_parameterValue = E_getParameter(E_id);
    
    if (E_parameterValue != null && E_parameterValue.indexOf("1") != -1) {
        E_state = false;
    } else if (E_parameterValue != null && E_parameterValue.indexOf("0") != -1) {
        E_state = true;
    } else {
        E_state = !E_originalState;
    }

    // Store new selection data in control form
    E_setParameter(E_id, E_state ? "1" : "0");

    // Update checkbox icon.
    document.images["E_TBIMG_" + E_id].src = (E_state ? E_selectedImageUri : E_defaultImageUri);

    // Notify server of change if necessary
    if (E_notify) {
        E_setAction(E_id, "press");
    }
}

/**
 * Called when a radio button is clicked.
 *
 * E_id: The ID of the radio button clicked
 * E_groupId: The radio button's group ID.  The selected value will be stored in the parameter for this ID.
 * E_originalSelectedId: The ID of the selected radio button when the page was originally rendered.
 * E_notify: True if the server should be notified immediately of state changes (via control frame submit)
 * E_defaultImageUri: The URI of the state image displayed when the radio button is not selected (unchecked).
 * E_selectedImageUri: The URI of the state image displayed when the radio button is selected (checked).
 */
function E_radioButtonAction(E_id, E_groupId, E_originalSelectedId, E_notify, E_defaultImageUri, E_selectedImageUri) {
    // Determine previously selected id.
    var E_selectedId;
    var E_parameterValue = E_getParameter(E_groupId);
    if (E_parameterValue != null && E_parameterValue.length > 0 && E_parameterValue.charAt(0) == "x") {
        E_selectedId = E_parameterValue.substring(1);
    } else  {
        E_selectedId = E_originalSelectedId;
    }

    // Store new selection data in control form
    E_setParameter(E_groupId, E_id);

    // Disable previously selected button.
    if (E_selectedId != null && E_selectedId != "" && E_id != E_selectedId) {
        document.images["E_TBIMG_" + E_selectedId].src = E_defaultImageUri;
    }

    // Enabled new selected button.
    if (E_id != null && E_id != "") {
        document.images["E_TBIMG_" + E_id].src = E_selectedImageUri;
    }

    // Notify server of change if necessary
    if (E_notify) {
        E_setAction(E_id, "press");
    }
}

function E_toggleRollover(E_id, E_stateId, E_imageUri, E_selectedImageUri, E_styleName) {
    if (E_imageUri != null) {
        var E_state = E_getParameter(E_stateId);
        if (E_state != null && E_state.length >= 2) {
            var E_stateString = E_state.substring(1);
            if (E_stateString == "1" || E_stateString == E_id) {
                E_imageSwap("E_TBIMG_" + E_id, E_selectedImageUri);
            } else {
                E_imageSwap("E_TBIMG_" + E_id, E_imageUri);
            }
        } else {
            E_imageSwap("E_TBIMG_" + E_id, E_imageUri);
        }
    }
    if (E_styleName != null) {
        E_applyStyleGroup("E_C_" + E_id, E_getStyle(E_styleName));
    }
}
