/* 
 * This file is part of the Echo Web Application Framework (hereinafter "Echo").
 * Copyright (C) 2002-2004 NextApp, Inc.
 *
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 */

/* List */

function E_List_E_add(E_element) {
    this.E_contents[this.E_contents.length] = E_element;
}

function E_List_E_contains(E_element) {
    return this.E_indexOf(E_element) != -1;
}

function E_List_E_indexOf(E_element) {
    var E_i;

    for (E_i = 0; E_i < this.E_contents.length; ++E_i) {
        if (this.E_contents[E_i] == E_element) {
            return E_i;
        }
    }
    
    return -1;
}

function E_List_E_get(E_index) {
    return this.E_contents[E_index];
}

function E_List_E_remove(E_index) {
    var E_i;
    
    for (E_i = E_index; E_i < this.E_contents.length - 1; ++E_i) {
        this.E_contents[E_i] = this.E_contents[E_i + 1];
    }
    
    this.E_contents.length = this.E_contents.length - 1;
}

function E_List_E_size() {
    return this.E_contents.length;
}

function E_List() {
    this.E_contents = new Array(0);
    this.E_add = E_List_E_add;
    this.E_contains = E_List_E_contains;
    this.E_get = E_List_E_get;
    this.E_indexOf = E_List_E_indexOf;
    this.E_remove = E_List_E_remove;
    this.E_size = E_List_E_size;
}

/* Set */

function E_Set_E_add(E_element) {
    if (! this.E_list.E_contains(E_element)) {
        this.E_list.E_add(E_element);
    }
}

function E_Set_E_contains(E_element) {
    return this.E_list.E_contains(E_element);
}

function E_Set_E_get(E_element) {
    return this.E_list.E_get(E_element);
}

function E_Set_E_indexOf(E_element) {
    return this.E_list.E_indexOf(E_element);
}

function E_Set_E_remove(E_element) {
    var E_i = this.E_list.E_indexOf(E_element);
    if (E_i != -1) {
        this.E_list.E_remove(E_i);
    }
}

function E_Set_E_size() {
    return this.E_list.E_size();
}

function E_Set() {
    this.E_list = new E_List();
    this.E_add = E_Set_E_add;
    this.E_contains = E_Set_E_contains;
    this.E_get = E_Set_E_get;
    this.E_indexOf = E_Set_E_indexOf;
    this.E_remove = E_Set_E_remove;
    this.E_size = E_Set_E_size;
}

/* Map */

function E_Map_E_get(E_key) {
    if (this.E_keys.E_contains(E_key)) {
        return this.E_values[E_key];
    } else {
        return null;
    }
}

function E_Map_E_keySet() {
    return this.E_keys;
}

function E_Map_E_put(E_key, E_value) {
    this.E_keys.E_add(E_key);
    this.E_values[E_key] = E_value;
}

function E_Map_E_remove(E_key) {
    if (this.E_keys.E_contains(E_key)) {
        this.E_keys.E_remove(E_key);
        this.E_values[E_key] = null;
    }
}

function E_Map_E_size() {
    return this.E_keys.E_size();
}

function E_Map() {
    this.E_keys = new E_Set();
    this.E_values = new Array();
    this.E_get = E_Map_E_get;
    this.E_keySet = E_Map_E_keySet;
    this.E_put = E_Map_E_put;
    this.E_remove = E_Map_E_remove;
    this.E_size = E_Map_E_size;
}
