/* 
 * This file is part of the Echo Web Application Framework (hereinafter "Echo").
 * Copyright (C) 2002-2004 NextApp, Inc.
 *
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 */

var E_rootFrame = null;
 
function E_focusByElementId(E_id) {
    var E_element = document.getElementById(E_id);
    if (E_element != null) {
        E_element.focus();
    }
} 
 
/**
 * Returns the controller frame if it is ready, and null if it is not.
 */
function E_getController() {
    var E_root = E_getRoot();
    if (E_root && E_root.E_getClientModel && E_root.E_getClientModel() && E_root.E_getClientModel().E_getController) {
        var E_controller = E_root.E_getClientModel().E_getController();
        if (E_controller && E_controller.E_ready) {
            return E_controller;
        } else {
            return null;
        }
    } else {
        return null;
    }
}

function E_isApplicationWindowRootContent() {
    return top.E_rootFrame;
}

/**
 * Returns the root frame of the Echo application.
 */
function E_getRoot() {
    if (E_rootFrame != null) {
        return E_rootFrame;
    }
    
    if (E_try(null, "E_isApplicationWindowRootContent")) {
        E_rootFrame = top;
    } else {
        var E_testFrame = window;
        while (E_testFrame.parent != null && E_testFrame.parent != E_testFrame) {
            if (E_testFrame.E_rootFrame) {
                E_rootFrame = E_testFrame;
            }
            E_testFrame = E_testFrame.parent;
        }
        // For testing only.
        // alert("Cannot retrieve root frame");
    }
    
    return E_rootFrame;
}

/**
 * Returns the value in the controller form's parameter field for E_id.
 * If the controller is not ready, null is returned.
 */
function E_getParameter(E_id) {
    var E_controller = E_getController();
    
    if (E_controller) {
        return E_controller.E_getParameter(E_id);
    } else {
        return null;
    }
}

/**
 * Sets the value in controller form's parameter field for E_id.
 * Returns true if the controller form was ready and the field was set,
 * and false if it was not.
 */
function E_setParameter(E_id, E_value) {
    var E_controller = E_getController();

    if (E_controller) {
        E_controller.E_setParameter(E_id, E_value);
        return true;
    } else {
        return false;
    }
}

/**
 * Sets the action command, causing the controller frame to submit.  
 */
function E_setAction(E_id, E_command) {
    var E_controller = E_getController();

    if (E_controller) {
        E_controller.E_setAction(E_id, E_command);
    } else {
        E_alertNotReady();
    }
}
