/* 
 * This file is part of the Echo Web Application Framework (hereinafter "Echo").
 * Copyright (C) 2002-2004 NextApp, Inc.
 *
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 */

function E_getStatus() {
    var E_clientModel = parent.E_getClientModel();
    var E_windowIds = E_clientModel.E_getWindowIds();
    var E_output = "Echo Window/Application Status\n";
    
    E_output += "Window Id: " + parent.E_id + "\n";
    E_output += "Root Window: " + (parent == E_clientModel.E_getRootWindow()) + "\n";
    E_output += "CM verification: " + (E_clientModel.E_verify(false) ? "ERRORS EXIST" : "clean") + "\n";
    E_output += "Open Windows: " + E_windowIds.E_size() + "\n";
    E_output += "Controller Sequence#: " + parent.frames.E_cf.document.forms[0].E_sequenceNumber.value + "\n";
    
    var E_widnowId;
    for (E_windowId = 0; E_windowId < E_windowIds.E_size(); ++E_windowId) {
        E_output += "Window[" + E_windowId + "] = " + E_windowIds.E_get(E_windowId) + "\n";
    }
    alert(E_output);
}

function E_inspectField() {
    if (document.forms[0].E_inspect.value) {
        var E_fieldName = "document.forms[0]." + document.forms[0].E_inspect.value;
        var E_field = eval(E_fieldName);
    
        if (E_field) {
            alert(E_field.value);
        } else {
            alert("Invalid Field:" + E_fieldName);
        }
    } else {
        alert("No Field Specified");
    }
}

function E_inspectProperty() {
    if (document.forms[0].E_inspect.value) {
        var E_propertyName = document.forms[0].E_inspect.value;
        var E_property = eval(E_propertyName);
    
        alert(E_property);
    } else {
        alert("No Property Specified");
    }
}
