/* 
 * This file is part of the Echo Web Application Framework (hereinafter "Echo").
 * Copyright (C) 2002-2004 NextApp, Inc.
 *
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 */

/**
 * Applys the specified style's background and foreground colors to the
 * specified element.
 */
function E_applyStyle(E_element, E_style) {
	if (E_element == null || E_style == null) {
	    return;
	}

    E_element.style.color = E_style.color;
    E_element.style.backgroundColor = E_style.backgroundColor;
    E_element.style.fontFamily = E_style.fontFamily;
    E_element.style.fontSize = E_style.fontSize;
    E_element.style.fontStyle = E_style.fontStyle;
    E_element.style.fontWeight = E_style.fontWeight;
    E_element.style.textDecoration = E_style.textDecoration;
    E_element.style.borderColor = E_style.borderColor;
    E_element.style.borderStyle = E_style.borderStyle;
}

function E_applyStyleGroup(E_groupName, E_style) {
    if (document.getElementById) {
        var E_i = 0;
        var E_element;

        do {
            E_element = document.getElementById(E_groupName + "_" + E_i);
            if (E_element) {
                E_applyStyle(E_element, E_style);
            }
            ++E_i;
        } while (E_element);
    }
}

/**
 * Returns the style object with the specified name.
 */
function E_getStyle(E_styleName) {
    var E_style = null;
    var E_i = 0;
    var E_rules;
    var E_length;
    var E_testName = E_styleName.toLowerCase();
    var E_name;
    var E_dotIndex;
    
    if (document.styleSheets && document.styleSheets[0]) {
        if (document.styleSheets[0].cssRules) {
            E_rules = document.styleSheets[0].cssRules;
        } else if (document.styleSheets[0].rules) {
            E_rules = document.styleSheets[0].rules;
        }
    }

    if (E_rules) {
        E_length = E_rules.length;

        while (E_i < E_length && E_style == null) {
            E_name = E_rules[E_i].selectorText.toLowerCase();
            E_dotIndex = E_name.indexOf(".");
            if (E_dotIndex >= 0) {
                E_name = E_name.substring(E_dotIndex + 1);
            }
            if (E_name == E_testName) {
                E_style = E_rules[E_i].style;
            }
            ++E_i;
        }
    }

    return E_style;
}
