/* 
 * This file is part of the Echo Web Application Framework (hereinafter "Echo").
 * Copyright (C) 2002-2004 NextApp, Inc.
 *
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 */

/** Indicates this frame has been initialized */
var E_initialized = false;

/**
 * Frame initialization event.
 * This script causes the E_initializeTasks() methods to be called in all 
 * browser frames, in a bottom-up order (the inverse of the top-down order
 * that onLoad() methods are called).  Frames are guaranteed that their 
 * parent frames E_initializeTasks() method has been executed before their own.
 */
function E_initialize() {

    if (window.E_rootFrame) {
        // Frame IS top frame.
        E_initialized = true;
    } else {
        // Frame is NOT top frame.
        if (parent.E_initialized) {
            E_initialized = true;
        }
    }

    if (E_initialized) {
        // Frame is top frame or parent frame has been initialized.
        if (this.E_initializeTasks) {
            // Call initializeTasks for this frame if it has not been done yet.
            E_initializeTasks();
        }

        for (var E_i = 0; E_i < frames.length; ++E_i) {
        
            // Safely determine if each child frame has initialization tasks.
            // This must be done with SafeInvoke because the frame might be
            // foreign (for example, if it's an HttpPane), in which case
            // the browser will throw an exception to maintain cross-site
            // scripting security.
            if (E_try(null, "E_hasInitializer", frames[E_i])) {
                if (! frames[E_i].E_initialized) {
                    frames[E_i].E_initialize();
                }
            }
        }
    }
}

/**
 * Returns true if the given frame has an initializeTasks() method.
 * This is done as a separate method so that it may called with
 * SafeInvoke.
 */
function E_hasInitializer(E_frame) {
    return E_frame.E_initialize;
}
