/* 
 * This file is part of the Echo Web Application Framework (hereinafter "Echo").
 * Copyright (C) 2002-2004 NextApp, Inc.
 *
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 */

var E_rootFrame = true;
var E_clientModel = null;
var E_notifyUnload = true;
var E_id = null;
var E_closePending = false;

/**
 * Closes this window.  If the window is the root window, notifies 
 * the client model to change the root window.
 */
function E_close() {
    E_notifyUnload = false;
    if (E_isRootWindow()) {
        E_clientModel.E_changeRootWindow();
    }
    window.close();
}

/**
 * Closes the window under the circumstance that it is the final window.
 * The client model does not need to be notified in this case.
 */
function E_closeFinalWindow() {
    E_notifyUnload = false;
    window.close();
}

/** 
 * Returns the client model for this window.
 */
function E_getClientModel() {
    return E_clientModel;
}

/**
 * Returns true if this window is the root window.
 */
function E_isRootWindow() {
    return window == E_clientModel.E_getRootWindow();
}

/**
 * Unregisters and closes all registered windows that have their
 * "closePending" flag set.
 */
function E_handleClosePendingWindows() {
    var E_windowIds = E_clientModel.E_getWindowIds();
    var E_length = E_windowIds.E_size();
    for (E_i = 0; E_i < E_length; ++E_i) {
        var E_windowId = E_windowIds.E_get(E_i);
        var E_window = E_clientModel.E_getWindow(E_windowId);
        if (E_window.E_closePending) {
            if (E_window.E_isRootWindow()) {
                alert("Error changing controller from closing window.");
            }
            if (E_clientModel) {
                E_clientModel.E_removeWindow(E_windowId);
                E_window.E_close();
            }
        }
    }
}

/**
 * Called when this window is unloaded (closed or reloaded).
 */
function E_handleUnload() {
    if (E_notifyUnload && E_clientModel && !E_clientModel.E_verify(false)) {
        if (E_isRootWindow()) {
            E_clientModel.E_changeRootWindow();
        } else {
            if (E_clientModel.E_getController().E_ready) {
                E_clientModel.E_getController().E_windowUnload();
            }
        }
    }
}

/**
 * Tests whether the windows opener has a clientModel.  
 * This method may throw permission exceptions if opener is not served
 * from same server for Cross-Site Scripting security reasons.
 */
function E_isOpenerAccessible() {
    if (window.opener && !window.opener.closed && window.opener.E_clientModel) {
        return true;
    } else {
        return false;
    }
}

/**
 * Called when this window is initialized so that it may establish
 * a connection to the ClientModel.
 */
function E_initClientModel(E_thisWindowId) {
    E_id = E_thisWindowId;
    if (E_try(null, "E_isOpenerAccessible")) { 
        E_clientModel = window.opener.E_clientModel;
        E_clientModel.E_addWindow(E_thisWindowId, window);
    } else {
        window.opener = null;
        E_clientModel = new E_ClientModel(E_thisWindowId);
    }
}

/**
 * Resynchronizes with the server.
 */
function E_refresh() {
    if (frames && frames.E_cf && frames.E_cf.E_ready && frames.E_cf.E_sendRequest) {
        frames.E_cf.E_sendRequest();
    }
}

/**
 * Sets this window as the root window.
 * - Sets this window's window.opener to null.
 * - Sets all other window's window.opener property to this window.
 * - Creates new ClientModel and copies data from old one (A new
 *   ClientModel must be created because the old one may become
 *   invalid when it instantiating window is destroyed).
 *   Sets all other window's client model to newly created one.
 * - Closes windows that are "pending close" (as is the case when
 *   the window containing the old controller needs to be closed).
 * - Sends a synchronize event through the new Controller.
 */
function E_setAsRootWindow() {
    // Create new client model.
    var E_newClientModel = new E_ClientModel(E_id);
    var E_i;
    var E_windowIds = E_clientModel.E_getWindowIds();
    var E_length = E_windowIds.E_size();
    
    // The root window's opener should be null.
    window.opener = null;
    
    // Iterate through all open window ids.
    for (E_i = 0; E_i < E_length; ++E_i) {
        var E_windowId = E_windowIds.E_get(E_i);
        if (E_windowId != E_id) {
            // E_windowId is not this window.
            
            // Get the window.
            var E_window = E_clientModel.E_getWindow(E_windowId);
            
            // Add the window to the new client model's list of windows.
            E_newClientModel.E_addWindow(E_windowId, E_window);
            
            // Set the window's client model to the new client model.
            E_window.E_setClientModel(E_newClientModel);
            
            // Set the window's opener to this window.
            E_window.opener = window;
        }
    }
    
    // Set this window's client model to the new client model.
    E_setClientModel(E_newClientModel);
    
    // Close pending windows.
    E_handleClosePendingWindows();
    
    // Send synchronize event.
    E_clientModel.E_getController().E_synchronize();
}

/**
 * Sets this window's client model.  Used only by setAsRootwindow().
 */
function E_setClientModel(E_newValue) {
    E_clientModel = E_newValue;
}

/**
 * Shuts down the application, redirecting the root window to 
 * the specified URI.
 */
function E_shutdown(E_uri) {
    var E_windowIds = E_clientModel.E_getWindowIds();
    var E_windowId;
    var E_window;
    
    for (var E_i = 0; E_i < E_windowIds.E_size(); ++E_i) {
        E_windowId = E_windowIds.E_get(E_i);
        E_window = E_clientModel.E_getWindow(E_windowId);
        E_window.E_notifyUnload = false;
        if (E_windowId != E_id) {
            E_window.close();
        }
    }
    
    window.location = E_uri;
}
