/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jstl.core;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import com.sun.facelets.tag.jstl.core.IndexedValueExpression;
import com.sun.facelets.tag.jstl.core.IterationStatus;
import com.sun.facelets.tag.jstl.core.IterationStatusExpression;
import com.sun.facelets.tag.jstl.core.MappedValueExpression;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;

public final class ForEachHandler
extends TagHandler {
    private final TagAttribute begin;
    private final TagAttribute end;
    private final TagAttribute items = this.getAttribute("items");
    private final TagAttribute step;
    private final TagAttribute tranzient;
    private final TagAttribute var = this.getAttribute("var");
    private final TagAttribute varStatus;

    public ForEachHandler(TagConfig config) {
        super(config);
        this.begin = this.getAttribute("begin");
        this.end = this.getAttribute("end");
        this.step = this.getAttribute("step");
        this.varStatus = this.getAttribute("varStatus");
        this.tranzient = this.getAttribute("transient");
        if (this.items == null && this.begin != null && this.end == null) {
            throw new TagAttributeException(this.tag, this.begin, "If the 'items' attribute is not specified, but the 'begin' attribute is, then the 'end' attribute is required");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        Iterator itr;
        int i;
        int s = this.getBegin(ctx);
        int e = this.getEnd(ctx);
        int m = this.getStep(ctx);
        Integer sO = this.begin != null ? new Integer(s) : null;
        Integer eO = this.end != null ? new Integer(e) : null;
        Integer mO = this.step != null ? new Integer(m) : null;
        boolean t = this.getTransient(ctx);
        Object src = null;
        ValueExpression srcVE = null;
        if (this.items != null) {
            srcVE = this.items.getValueExpression(ctx, Object.class);
            src = srcVE.getValue((ELContext)ctx);
        } else {
            byte[] b = new byte[e + 1];
            for (i = 0; i < b.length; ++i) {
                b[i] = (byte)i;
            }
            src = b;
        }
        if (src != null && (itr = this.toIterator(src)) != null) {
            for (i = 0; i < s && itr.hasNext(); ++i) {
                itr.next();
            }
            String v = this.getVarName(ctx);
            String vs = this.getVarStatusName(ctx);
            VariableMapper vars = ctx.getVariableMapper();
            ValueExpression ve = null;
            ValueExpression vO = this.capture(v, vars);
            ValueExpression vsO = this.capture(vs, vars);
            int mi = 0;
            Object value = null;
            try {
                boolean first = true;
                while (i <= e && itr.hasNext()) {
                    value = itr.next();
                    if (v != null) {
                        if (t || srcVE == null) {
                            ctx.setAttribute(v, value);
                        } else {
                            ve = this.getVarExpr(srcVE, src, value, i);
                            vars.setVariable(v, ve);
                        }
                    }
                    if (vs != null) {
                        IterationStatus itrS = new IterationStatus(first, !itr.hasNext(), i, sO, eO, mO);
                        if (t || srcVE == null) {
                            ctx.setAttribute(vs, itrS);
                        } else {
                            ve = new IterationStatusExpression(itrS);
                            vars.setVariable(vs, ve);
                        }
                    }
                    this.nextHandler.apply(ctx, parent);
                    mi = 1;
                    while (mi < m && itr.hasNext()) {
                        itr.next();
                        ++mi;
                        ++i;
                    }
                    ++i;
                    first = false;
                }
            }
            finally {
                if (v != null) {
                    vars.setVariable(v, vO);
                }
                if (vs != null) {
                    vars.setVariable(vs, vsO);
                }
            }
        }
    }

    private final ValueExpression capture(String name, VariableMapper vars) {
        if (name != null) {
            return vars.setVariable(name, null);
        }
        return null;
    }

    private final int getBegin(FaceletContext ctx) {
        if (this.begin != null) {
            return this.begin.getInt(ctx);
        }
        return 0;
    }

    private final int getEnd(FaceletContext ctx) {
        if (this.end != null) {
            return this.end.getInt(ctx);
        }
        return Integer.MAX_VALUE;
    }

    private final int getStep(FaceletContext ctx) {
        if (this.step != null) {
            return this.step.getInt(ctx);
        }
        return 1;
    }

    private final boolean getTransient(FaceletContext ctx) {
        if (this.tranzient != null) {
            return this.tranzient.getBoolean(ctx);
        }
        return false;
    }

    private final ValueExpression getVarExpr(ValueExpression ve, Object src, Object value, int i) {
        if (src instanceof Collection || src.getClass().isArray()) {
            return new IndexedValueExpression(ve, i);
        }
        if (src instanceof Map && value instanceof Map.Entry) {
            return new MappedValueExpression(ve, (Map.Entry)value);
        }
        throw new IllegalStateException("Cannot create VE for: " + src);
    }

    private final String getVarName(FaceletContext ctx) {
        if (this.var != null) {
            return this.var.getValue(ctx);
        }
        return null;
    }

    private final String getVarStatusName(FaceletContext ctx) {
        if (this.varStatus != null) {
            return this.varStatus.getValue(ctx);
        }
        return null;
    }

    private final Iterator toIterator(Object src) {
        if (src == null) {
            return null;
        }
        if (src instanceof Collection) {
            return ((Collection)src).iterator();
        }
        if (src instanceof Map) {
            return ((Map)src).entrySet().iterator();
        }
        if (src.getClass().isArray()) {
            return new ArrayIterator(src);
        }
        throw new TagAttributeException(this.tag, this.items, "Must evaluate to a Collection, Map, Array, or null.");
    }

    private static class ArrayIterator
    implements Iterator {
        protected final Object array;
        protected int i = 0;
        protected final int len;

        public ArrayIterator(Object src) {
            this.array = src;
            this.len = Array.getLength(src);
        }

        public boolean hasNext() {
            return this.i < this.len;
        }

        public Object next() {
            return Array.get(this.array, this.i++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

