/*
 * Decompiled with CFR 0.152.
 */
package jmaki.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AddWidgetTask
extends Task {
    String library;
    String widget;
    String target;
    String fileSep = System.getProperty("file.separator");
    boolean force = false;
    Properties libs = null;
    String libraryDefs = null;
    boolean fail = false;

    public void setLibrary(String library) {
        this.library = library;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setWidget(String widget) {
        this.widget = widget;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setLibraryDefs(String libraryDefs) {
        this.libraryDefs = libraryDefs;
    }

    private void loadLibraryDefs() {
        try {
            if (this.libraryDefs != null) {
                this.libs = new Properties();
                FileInputStream in = new FileInputStream(this.libraryDefs);
                this.libs.load(in);
                in.close();
            }
        }
        catch (Exception ex) {
            this.log("Failed to load Library Definitions : " + this.libraryDefs);
            this.fail = true;
        }
    }

    public void setFail(boolean b) {
        this.fail = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        InputStream is = null;
        try {
            this.loadLibraryDefs();
            if (this.library == null && this.libs != null) {
                this.library = this.getLibraryName(this.widget);
            }
            this.log("Library: " + this.library);
            this.log("Widget: " + this.widget);
            this.log("Target: " + this.target);
            if (this.library != null && this.widget != null && this.target != null) {
                JSONObject config;
                ZipFile zip = new ZipFile(this.library);
                String wBase = "resources/" + this.widget.replace(".", "/");
                ZipEntry ze = zip.getEntry(wBase + "/widget.json");
                is = zip.getInputStream(ze);
                JSONArray compResources = new JSONArray();
                compResources.put((Object)(wBase + "/"));
                int ccount = this.copyResources(compResources, zip, wBase, this.target);
                this.log("Coppied  " + ccount + " widget resources.");
                JSONObject widget = AddWidgetTask.loadJSONObject(is);
                if (widget.has("config") && (config = widget.getJSONObject("config")).has("type")) {
                    int count;
                    JSONArray libs;
                    this.log("Copying resources specified in widget.json");
                    JSONObject type = config.getJSONObject("type");
                    if (type.has("libs")) {
                        libs = type.getJSONArray("libs");
                        count = this.copyResources(libs, zip, wBase, this.target);
                        this.log("Coppied  " + count + " script(s).");
                    }
                    if (type.has("styles")) {
                        libs = type.getJSONArray("styles");
                        count = this.copyResources(libs, zip, wBase, this.target);
                        this.log("Coppied  " + count + " style(s).");
                    }
                    if (type.has("resources")) {
                        JSONArray resources = type.getJSONArray("resources");
                        count = this.copyResources(resources, zip, wBase, this.target);
                        this.log("Coppied  " + count + " resources.");
                    }
                }
            }
        }
        catch (Exception ex) {
            this.fail = true;
            ex.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (this.fail) {
            throw new BuildException("Fail to copy widget.");
        }
    }

    private String getLibraryName(String widgetName) {
        int index = widgetName.indexOf(".");
        if (index != -1) {
            String library = widgetName.substring(0, index);
            return this.libs.getProperty(library);
        }
        return null;
    }

    private int copyResources(JSONArray items, ZipFile zip, String wBase, String target) throws IOException, JSONException {
        int counter = 0;
        for (int i = 0; i < items.length(); ++i) {
            FileOutputStream fos;
            File f;
            String item = items.getString(i);
            String path = this.computeRelativeFile(wBase, item);
            ZipEntry ze = zip.getEntry(path);
            if (ze != null && !ze.isDirectory() && ze.getSize() <= 0L) {
                path = path + "/";
                ze = zip.getEntry(path);
            }
            if (ze != null && !ze.isDirectory()) {
                String dir = path;
                String name = "";
                if (path.indexOf("/") != -1) {
                    int index = path.lastIndexOf("/");
                    dir = path.substring(0, index);
                    name = path.substring(index + 1, path.length());
                }
                File dirf = new File(target, dir);
                dirf.mkdirs();
                f = new File(dirf, name);
                if (f.exists() && !this.force) continue;
                f.createNewFile();
                fos = new FileOutputStream(f);
                this.copyZipResource(zip.getInputStream(ze), fos);
                ++counter;
                continue;
            }
            if (ze != null) {
                ArrayList entries = this.getEntriesForPath(zip, path);
                Iterator it = entries.iterator();
                while (it.hasNext()) {
                    ZipEntry entry = (ZipEntry)it.next();
                    if (entry.isDirectory()) {
                        File dirf = new File(target + this.fileSep + entry.getName());
                        dirf.mkdirs();
                        continue;
                    }
                    f = new File(target + this.fileSep + entry.getName());
                    if (f.exists() && !this.force) continue;
                    f.createNewFile();
                    fos = new FileOutputStream(f);
                    this.copyZipResource(zip.getInputStream(entry), fos);
                    ++counter;
                }
                continue;
            }
            this.log("Could not find " + path + " in " + zip);
        }
        return counter;
    }

    private ArrayList getEntriesForPath(ZipFile zip, String path) {
        Enumeration<? extends ZipEntry> e = zip.entries();
        ArrayList<ZipEntry> re = new ArrayList<ZipEntry>();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!entry.getName().startsWith(path)) continue;
            re.add(entry);
        }
        return re;
    }

    private String computeRelativeFile(String base, String item) {
        String path = "";
        int depth = 0;
        int index = 0;
        String[] basePaths = base.split("/");
        if (item.startsWith("../")) {
            while (item.indexOf("../", index) != -1) {
                ++depth;
                index = item.indexOf("../", index) + 3;
            }
            String[] dest = new String[basePaths.length - depth];
            System.arraycopy(basePaths, 0, dest, 0, basePaths.length - depth);
            for (int i = 0; i < dest.length; ++i) {
                path = path + dest[i] + "/";
            }
            path = path + item.substring(index, item.length());
        }
        if ("".equals(path)) {
            path = base;
        }
        return path;
    }

    public void copyZipResource(InputStream in, OutputStream out) {
        try {
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            in.close();
            out.close();
        }
        catch (IOException iox) {
            System.err.println("AddWidgetTask Error: " + iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject loadJSONObject(InputStream in) {
        ByteArrayOutputStream out = null;
        try {
            byte[] buffer = new byte[1024];
            int read = 0;
            out = new ByteArrayOutputStream();
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            JSONObject jSONObject = new JSONObject(out.toString());
            return jSONObject;
        }
        catch (Exception e) {
            System.out.println("GenWidgetDocTask: error reading in json " + e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

